/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.util.Random;

public class StringUtils {
    private static final Random RANDOM = new Random();

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static String randomAscii(int count) {
        return StringUtils.random(count, 32, 127, false, false);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers) {
        return StringUtils.random(count, start, end, letters, numbers, null, RANDOM);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (start == 0 && end == 0) {
            end = 123;
            start = 32;
            if (!letters && !numbers) {
                start = 0;
                end = Integer.MAX_VALUE;
            }
        }
        StringBuffer buffer = new StringBuffer();
        int gap = end - start;
        while (count-- != 0) {
            char ch = chars == null ? (char)(random.nextInt(gap) + start) : chars[random.nextInt(gap) + start];
            if (letters && numbers && Character.isLetterOrDigit(ch) || letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                buffer.append(ch);
                continue;
            }
            ++count;
        }
        return buffer.toString();
    }
}

