/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.diff;

import com.alkacon.diff.rangedifferencer.I_RangeComparator;
import java.util.ArrayList;
import java.util.List;

class BlockComparator
implements I_RangeComparator {
    private List m_tokens;

    public BlockComparator(StringBuffer text) {
        this.m_tokens = this.splitLineTokens(text);
    }

    public int getRangeCount() {
        return this.m_tokens.size();
    }

    public boolean rangesEqual(int thisIndex, I_RangeComparator other, int otherIndex) {
        String thisToken = this.getToken(thisIndex);
        String otherToken = ((BlockComparator)other).getToken(otherIndex);
        if (thisToken.equals(" ") && otherToken.equals("\n") || thisToken.equals("\n") && otherToken.equals(" ")) {
            return true;
        }
        return thisToken.equals(otherToken);
    }

    public boolean skipRangeComparison(int length, int maxLength, I_RangeComparator other) {
        return false;
    }

    public String substring(int startToken) {
        return this.substring(startToken, this.m_tokens.size());
    }

    public String substring(int startToken, int endToken) {
        if (startToken == endToken) {
            return (String)this.m_tokens.get(startToken);
        }
        StringBuffer result = new StringBuffer();
        int i = startToken;
        while (i < endToken) {
            result.append((String)this.m_tokens.get(i));
            ++i;
        }
        return result.toString();
    }

    public String[] substringSplitted(int startToken) {
        return this.substringSplitted(startToken, this.m_tokens.size());
    }

    public String[] substringSplitted(int startToken, int endToken) {
        if (startToken == endToken) {
            return new String[]{(String)this.m_tokens.get(startToken)};
        }
        int resultPos = -1;
        String[] result = null;
        StringBuffer resultBuffer = new StringBuffer();
        int i = startToken;
        while (i < endToken) {
            String token = (String)this.m_tokens.get(i);
            if (token.equals("\n")) {
                if (resultBuffer.length() > 0) {
                    result = this.grow(result, 2);
                    result[++resultPos] = resultBuffer.toString();
                    result[++resultPos] = "\n";
                    resultBuffer.setLength(0);
                } else {
                    result = this.grow(result, 1);
                    result[++resultPos] = "\n";
                }
            } else {
                resultBuffer.append(token);
            }
            ++i;
        }
        if (resultBuffer.length() > 0) {
            result = this.grow(result, 1);
            result[++resultPos] = resultBuffer.toString();
        } else if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    private String getToken(int i) {
        if (i < this.m_tokens.size()) {
            return (String)this.m_tokens.get(i);
        }
        return "";
    }

    private String[] grow(String[] strings, int count) {
        if (strings == null) {
            return new String[count];
        }
        String[] result = new String[strings.length + count];
        System.arraycopy(strings, 0, result, 0, strings.length);
        return result;
    }

    private ArrayList splitLineTokens(StringBuffer text) {
        ArrayList<String> tokens = new ArrayList<String>(100);
        StringBuffer currentWord = new StringBuffer(100);
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    if (currentWord.length() > 0) {
                        tokens.add(currentWord.toString());
                        currentWord.setLength(0);
                    }
                    currentWord.append(c);
                    break;
                }
                case '/': {
                    if (currentWord.length() == 1 && currentWord.charAt(0) == '<') {
                        currentWord.append(c);
                        break;
                    }
                }
                case '>': {
                    if (currentWord.length() > 2 && currentWord.charAt(0) == '<' && currentWord.charAt(1) == '/') {
                        currentWord.append(c);
                        break;
                    }
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '!': 
                case '\"': 
                case '\'': 
                case ',': 
                case '.': 
                case ';': 
                case '=': 
                case '?': {
                    if (currentWord.length() > 0) {
                        tokens.add(currentWord.toString());
                        currentWord.setLength(0);
                    }
                    tokens.add(String.valueOf(c));
                    break;
                }
                default: {
                    currentWord.append(c);
                }
            }
            ++i;
        }
        if (currentWord.length() > 0) {
            tokens.add(currentWord.toString());
        }
        return tokens;
    }
}

