/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.diff;

import com.alkacon.diff.DiffLineType;
import com.alkacon.diff.I_DiffConfiguration;
import com.alkacon.diff.I_HtmlDiffConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HtmlDiffConfiguration
implements I_HtmlDiffConfiguration {
    private final I_DiffConfiguration m_baseConf;
    private Map m_divStyles = new HashMap();
    private Map m_spanStyles = new HashMap();

    public HtmlDiffConfiguration(I_DiffConfiguration baseConf) {
        this.m_baseConf = baseConf;
    }

    public String getDivStyleName(DiffLineType type) {
        return this.m_divStyles.get(type).toString();
    }

    public int getLinesBeforeSkip() {
        return this.m_baseConf.getLinesBeforeSkip();
    }

    public String getMessageEqualLinesSkipped(int lines) {
        return this.m_baseConf.getMessageEqualLinesSkipped(lines);
    }

    public String getSpanStyleName(DiffLineType type) {
        if (type != DiffLineType.UNCHANGED) {
            return this.m_spanStyles.get(type).toString();
        }
        return (String)this.m_spanStyles.get(type);
    }

    public void setDivStyleNames(String unchanged, String added, String removed, String skipped) {
        this.m_divStyles.put(DiffLineType.UNCHANGED, unchanged);
        this.m_divStyles.put(DiffLineType.ADDED, added);
        this.m_divStyles.put(DiffLineType.REMOVED, removed);
        this.m_divStyles.put(DiffLineType.SKIPPED, skipped);
        this.m_divStyles = Collections.unmodifiableMap(this.m_divStyles);
    }

    public void setSpanStyleNames(String unchanged, String added, String removed) {
        if (unchanged != null) {
            this.m_spanStyles.put(DiffLineType.UNCHANGED, unchanged);
        }
        this.m_spanStyles.put(DiffLineType.ADDED, added);
        this.m_spanStyles.put(DiffLineType.REMOVED, removed);
        this.m_spanStyles = Collections.unmodifiableMap(this.m_spanStyles);
    }
}

