/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.diff;

import com.alkacon.diff.DiffLineType;
import com.alkacon.diff.I_DiffOutput;
import com.alkacon.diff.I_TextDiffConfiguration;
import java.io.Writer;

public class TextDiffOutput
implements I_DiffOutput {
    private final StringBuffer m_contentLine = new StringBuffer();
    private boolean m_currentLineHasChangedText = false;
    private final StringBuffer m_markLine = new StringBuffer();
    private final Writer m_writer;
    private final I_TextDiffConfiguration m_config;

    public TextDiffOutput(Writer writer, I_TextDiffConfiguration config) {
        this.m_writer = writer;
        this.m_config = config;
    }

    private boolean markLines() {
        return this.m_config.getChangedCharMarker() != ' ';
    }

    public void addChangedText(String text) throws Exception {
        if (this.markLines()) {
            int i;
            if (!this.m_currentLineHasChangedText) {
                this.m_currentLineHasChangedText = true;
                i = 0;
                while (i < this.m_contentLine.length() - 4) {
                    this.m_markLine.append(' ');
                    ++i;
                }
            }
            i = 0;
            while (i < text.length()) {
                this.m_markLine.append(this.m_config.getChangedCharMarker());
                ++i;
            }
        }
        this.m_contentLine.append(text);
    }

    public void addUnchangedText(String text) throws Exception {
        if (this.markLines() && this.m_currentLineHasChangedText) {
            int i = 0;
            while (i < text.length()) {
                this.m_markLine.append(' ');
                ++i;
            }
        }
        this.m_contentLine.append(text);
    }

    public void endLine() throws Exception {
        this.m_writer.write(this.m_contentLine.toString());
        this.m_writer.write(10);
        if (this.markLines() && this.m_currentLineHasChangedText && this.m_markLine.length() > 0) {
            this.m_writer.write("    ");
            this.m_writer.write(this.m_markLine.toString());
            this.m_writer.write(10);
        }
    }

    public void skippedLines(int linesSkipped) throws Exception {
        this.m_writer.write(this.m_config.getMessageEqualLinesSkipped(linesSkipped));
        this.m_writer.write("\n");
    }

    public void startLine(DiffLineType type) throws Exception {
        this.m_contentLine.setLength(0);
        if (type == DiffLineType.UNCHANGED) {
            this.m_contentLine.append("    ");
        } else if (type == DiffLineType.ADDED) {
            this.m_contentLine.append("+++ ");
        } else if (type == DiffLineType.REMOVED) {
            this.m_contentLine.append("--- ");
        }
        this.m_currentLineHasChangedText = false;
        if (this.markLines()) {
            this.m_markLine.setLength(0);
        }
    }
}

