/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.diff.rangedifferencer;

public class RangeDifference {
    public static final int ANCESTOR = 4;
    public static final int CHANGE = 2;
    public static final int CONFLICT = 1;
    public static final int ERROR = 5;
    public static final int LEFT = 3;
    public static final int NOCHANGE = 0;
    public static final int RIGHT = 2;
    private int m_fKind;
    int m_fLeftLength;
    int m_fLeftStart;
    int m_fRightLength;
    int m_fRightStart;
    int m_lAncestorLength;
    int m_lAncestorStart;

    RangeDifference(int changeKind) {
        this.m_fKind = changeKind;
    }

    RangeDifference(int kind, int rightStart, int rightLength, int leftStart, int leftLength) {
        this.m_fKind = kind;
        this.m_fRightStart = rightStart;
        this.m_fRightLength = rightLength;
        this.m_fLeftStart = leftStart;
        this.m_fLeftLength = leftLength;
    }

    RangeDifference(int kind, int rightStart, int rightLength, int leftStart, int leftLength, int ancestorStart, int ancestorLength) {
        this(kind, rightStart, rightLength, leftStart, leftLength);
        this.m_lAncestorStart = ancestorStart;
        this.m_lAncestorLength = ancestorLength;
    }

    public int ancestorEnd() {
        return this.m_lAncestorStart + this.m_lAncestorLength;
    }

    public int ancestorLength() {
        return this.m_lAncestorLength;
    }

    public int ancestorStart() {
        return this.m_lAncestorStart;
    }

    public int kind() {
        return this.m_fKind;
    }

    public int leftEnd() {
        return this.m_fLeftStart + this.m_fLeftLength;
    }

    public int leftLength() {
        return this.m_fLeftLength;
    }

    public int leftStart() {
        return this.m_fLeftStart;
    }

    public int maxLength() {
        return Math.max(this.m_fRightLength, Math.max(this.m_fLeftLength, this.m_lAncestorLength));
    }

    public int rightEnd() {
        return this.m_fRightStart + this.m_fRightLength;
    }

    public int rightLength() {
        return this.m_fRightLength;
    }

    public int rightStart() {
        return this.m_fRightStart;
    }
}

