/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.applet.upload;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FileSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 7474825906798331943L;
    private String m_rootPath;
    private FileSelectionPane m_selectionPane;

    public FileSelectionPanel(List paths, String rootPath) {
        super(new GridLayout(1, 0));
        this.m_rootPath = rootPath.replace('\\', '/');
        this.m_selectionPane = new FileSelectionPane(paths);
        JScrollPane scrollPane = new JScrollPane(this.m_selectionPane);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)scrollPane, "Center");
        this.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
    }

    private void findFilesRecursive(File file, List files) {
        if (file.isFile()) {
            files.add(file);
        } else if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.findFilesRecursive(children[i], files);
            }
        }
    }

    public File[] getSelectedFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Component[] rows = this.m_selectionPane.getComponents();
        for (int i = rows.length - 2; i >= 0; --i) {
            Row row = (Row)rows[i];
            boolean selected = row.getCheckBox().isSelected();
            if (!selected) continue;
            File file = new File(this.m_rootPath + "/" + row.getPathLabel().getText());
            if (file.isFile()) {
                files.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.findFilesRecursive(file, files);
        }
        File[] result = files.toArray(new File[files.size()]);
        return result;
    }

    static class Row
    extends JPanel {
        private static final long serialVersionUID = -1002437588400330504L;
        private JCheckBox m_checkBox;
        private JLabel m_pathLabel;

        Row(String fileName) {
            Insets insets;
            this.setBackground(Color.WHITE);
            this.m_checkBox = new JCheckBox();
            this.m_checkBox.setBackground(Color.WHITE);
            this.m_checkBox.setSelected(true);
            this.m_pathLabel = new JLabel(fileName);
            Dimension dimension = new Dimension(340, 20);
            this.m_pathLabel.setPreferredSize(dimension);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = insets = new Insets(0, 2, 0, 2);
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            this.add((Component)this.m_checkBox, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            this.add((Component)this.m_pathLabel, gbc);
        }

        public JCheckBox getCheckBox() {
            return this.m_checkBox;
        }

        public JLabel getPathLabel() {
            return this.m_pathLabel;
        }

        public void setPathLabel(JLabel pathLabel) {
            this.m_pathLabel = pathLabel;
        }
    }

    static class FileSelectionPane
    extends JPanel {
        private static final long serialVersionUID = -3040601958000155698L;

        public FileSelectionPane(List paths) {
            Insets insets;
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.WHITE);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = insets = new Insets(0, 2, 0, 2);
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                this.add((Component)new Row((String)it.next()), gbc);
                ++gbc.gridy;
            }
            JPanel dummy = new JPanel();
            dummy.setBackground(Color.WHITE);
            gbc.weighty = 1.0;
            gbc.anchor = 15;
            this.add((Component)dummy, gbc);
        }
    }
}

