/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.applet.upload;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.opencms.applet.upload.FileSelectionPanel;
import org.opencms.applet.upload.FileUploadThread;
import org.opencms.applet.upload.ImageFileView;
import org.opencms.applet.upload.ImageFilter;
import org.opencms.applet.upload.ImagePreview;
import org.opencms.applet.upload.ModalDialog;
import org.opencms.applet.upload.OfficeFilter;
import org.opencms.applet.upload.UploadAppletFileChooser;
import org.opencms.applet.upload.WebFilter;

public class FileUploadApplet
extends JApplet
implements Runnable {
    public static final String C_JSESSIONID = "JSESSIONID";
    public static final String DIALOG_CHECK_OVERWRITE = "checkoverwrite";
    private static final long serialVersionUID = -3710093915699772778L;
    private String m_action = "";
    private String m_actionOutputCount = "Counting resources ....";
    private String m_actionOutputCreate = "Creating Zip-File...";
    private String m_actionOutputError = "Error";
    private String m_actionOutputSelect = "Seleting files for upload....";
    private String m_actionOutputUpload = "Upload Zip-File";
    private String m_actionOverwriteCheck = "Checking file existance on server...";
    private boolean m_certificateAccepted;
    private String m_certificateErrorMessage = "The required Applet certificate has not been accepted!";
    private String m_certificateErrorTitle = "Error initializing the OpenCms Upload Applet";
    private String m_clientFolder = null;
    private HashMap m_colors = new HashMap();
    private String m_errorLine1 = "An error has occurred on the server:";
    private String m_errorUrl = "";
    private String m_fileExtensions = "";
    private String m_fileFilterSelection = "";
    private UploadAppletFileChooser m_fileSelector;
    private Image m_floater;
    private int m_floaterPos = 50;
    private Font m_font;
    private long m_maxsize = -1L;
    private String m_message = "";
    private String m_messageNoPreview = "no preview available";
    private String m_messageOutputAdding = "Adding ";
    private String m_messageOutputErrorSize = "Zip file too big:";
    private String m_messageOutputErrorZip = "Error creating Zip-File, see Java Console.";
    private String m_messageOutputUpload = "Please wait, uploading data...";
    private FontMetrics m_metrics;
    private Graphics m_offgraphics;
    private Image m_offscreen;
    private String m_opencms = "";
    private int m_outputMode;
    private ModalDialog m_overwriteDialog;
    private String m_overwriteDialogCancel = "Cancel";
    private String m_overwriteDialogIntro = "The files listed below already exist on the server. \nAll checked files will be overwritten.";
    private String m_overwriteDialogLocale = "en";
    private String m_overwriteDialogOk = "Ok";
    private String m_overwriteDialogTitle = "Select the files to overwrite on the server";
    private List m_overwrites;
    private String m_redirectTargetFrame = "";
    private String m_redirectUrl = "";
    private int m_resources;
    private Thread m_runner;
    private Image m_source;
    private int m_step;
    private Image m_target;
    private String m_targetUrl = "";
    private String m_uploadFolder = "";

    private void addFileToZip(ZipOutputStream zipStream, File file) throws Exception {
        String name = file.getAbsolutePath().replace('\\', '/');
        name = name.substring(this.m_fileSelector.getCurrentDirectory().getAbsolutePath().length());
        this.m_message = this.m_messageOutputAdding + " " + name + "..";
        ++this.m_step;
        this.repaint();
        ZipEntry entry = new ZipEntry(name);
        zipStream.putNextEntry(entry);
        this.writeFileBytes(file, zipStream);
        zipStream.closeEntry();
    }

    private void addFolderToZip(ZipOutputStream zipStream, File file) throws Exception {
        File[] children = file.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                this.addFolderToZip(zipStream, child);
                continue;
            }
            this.addFileToZip(zipStream, child);
        }
    }

    private File[] addOverwrites(File[] files, File[] overwriteFiles) {
        int i;
        ArrayList<File> result = new ArrayList<File>(files.length + overwriteFiles.length);
        for (i = files.length - 1; i >= 0; --i) {
            result.add(files[i]);
        }
        for (i = overwriteFiles.length - 1; i >= 0; --i) {
            result.add(overwriteFiles[i]);
        }
        return result.toArray(new File[result.size()]);
    }

    int checkServerOverwrites(File[] files) {
        this.m_action = this.m_actionOverwriteCheck;
        this.repaint();
        int rtv = -1;
        ArrayList fileNames = new ArrayList();
        for (int i = 0; i < files.length; ++i) {
            this.getRelativeFilePaths(files[i], fileNames);
        }
        StringBuffer uploadFiles = new StringBuffer();
        Iterator it = fileNames.iterator();
        int count = 0;
        HttpClient client = new HttpClient();
        this.m_overwrites = new ArrayList();
        try {
            while (it.hasNext()) {
                uploadFiles.append((String)it.next()).append('\n');
                if (++count % 40 != 0 && it.hasNext()) continue;
                PostMethod post = new PostMethod(this.m_targetUrl);
                Header postHeader = new Header("uploadFiles", URLEncoder.encode(uploadFiles.toString(), "utf-8"));
                post.addRequestHeader(postHeader);
                Header header2 = new Header("uploadFolder", URLEncoder.encode(this.getParameter("filelist"), "utf-8"));
                post.addRequestHeader(header2);
                post.setParameter("action", DIALOG_CHECK_OVERWRITE);
                String sessionId = this.getParameter("sessionId");
                String query = ";" + C_JSESSIONID.toLowerCase() + "=" + sessionId;
                post.setQueryString(query);
                post.addRequestHeader(C_JSESSIONID, sessionId);
                HttpConnectionManagerParams connectionParams = client.getHttpConnectionManager().getParams();
                connectionParams.setConnectionTimeout(5000);
                client.getState();
                client.getHostConfiguration().getHost();
                HttpState initialState = new HttpState();
                URI uri = new URI(this.m_targetUrl, false);
                Cookie sessionCookie = new Cookie(uri.getHost(), C_JSESSIONID, sessionId, "/", null, false);
                initialState.addCookie(sessionCookie);
                client.setState(initialState);
                int status = client.executeMethod(post);
                if (status == 200) {
                    String response = post.getResponseBodyAsString();
                    List duplications = this.parseDuplicateFiles(URLDecoder.decode(response, "utf-8"));
                    this.m_overwrites.addAll(duplications);
                } else {
                    String error = this.m_errorLine1 + "\n" + post.getStatusLine();
                    System.err.println(error);
                }
                count = 0;
                uploadFiles = new StringBuffer();
            }
            rtv = this.m_overwrites.size() > 0 ? this.showDuplicationsDialog(this.m_overwrites) : 0;
        }
        catch (HttpException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return rtv;
    }

    private int countResources(File[] files) {
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                ++count;
                continue;
            }
            count += this.countSubresources(files[i]);
        }
        return count;
    }

    private int countSubresources(File folder) {
        int count = 0;
        count = folder.isFile() ? 1 : this.countResources(folder.listFiles());
        return count;
    }

    private File createZipFile(File[] files) {
        File targetFile = null;
        if (files.length > 0) {
            this.m_action = this.m_actionOutputCreate;
            try {
                String zipFileName = ".opencms_upload.zip";
                String userHome = System.getProperty("user.home");
                if (userHome != null) {
                    if (!userHome.endsWith(File.separator)) {
                        userHome = userHome + File.separator;
                    }
                    zipFileName = userHome + zipFileName;
                }
                ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(zipFileName));
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isFile()) {
                        this.addFileToZip(zipStream, files[i]);
                    } else {
                        this.addFolderToZip(zipStream, files[i]);
                    }
                    this.repaint();
                    files[i] = null;
                }
                zipStream.close();
                targetFile = new File(zipFileName);
            }
            catch (Exception e) {
                System.err.println("Error creating zipfile " + FileUploadApplet.getStackTraceAsString(e));
            }
        }
        return targetFile;
    }

    private static String getStackTraceAsString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public void destroy() {
    }

    public void displayError() {
        this.m_outputMode = 5;
        this.m_action = this.m_certificateErrorTitle;
        this.m_message = this.m_certificateErrorMessage;
        JOptionPane.showMessageDialog(this, this.m_message, this.m_action, 0);
        try {
            this.getAppletContext().showDocument(new URL(this.m_redirectUrl), this.m_redirectTargetFrame);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.stop();
    }

    private HashMap extractColors(String colors) {
        HashMap<String, String> colorStorage = new HashMap<String, String>();
        if (colors != null) {
            StringTokenizer tok = new StringTokenizer(colors, ",");
            while (tok.hasMoreElements()) {
                String token = tok.nextToken();
                String colorName = token.substring(0, token.indexOf("="));
                String colorValue = token.substring(token.indexOf("=") + 1);
                colorStorage.put(colorName, colorValue);
            }
        }
        return colorStorage;
    }

    private Color getColor(String colorName) {
        Color col = Color.black;
        try {
            col = Color.decode((String)this.m_colors.get(colorName));
        }
        catch (Exception e) {
            System.err.println("Error reading " + colorName + ":" + e);
        }
        return col;
    }

    private void getFilesInTree(File file, List fileNames) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.getFilesInTree(children[i], fileNames);
            }
        } else {
            FileFilter filter = this.m_fileSelector.getFileFilter();
            if (filter.accept(file)) {
                fileNames.add(file);
            }
        }
    }

    private void getRelativeFilePaths(File file, List fileNames) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.getRelativeFilePaths(children[i], fileNames);
            }
        } else {
            FileFilter filter = this.m_fileSelector.getFileFilter();
            if (filter.accept(file)) {
                String rootDir = this.m_fileSelector.getCurrentDirectory().getAbsolutePath();
                int rootDirLength = rootDir.length();
                String filePath = file.getAbsolutePath();
                filePath = filePath.substring(rootDirLength);
                filePath = filePath.replace('\\', '/');
                fileNames.add(filePath);
            }
        }
    }

    public void init() {
        if (this.getParameter("overwriteDialogLocale") != null) {
            this.m_overwriteDialogLocale = this.getParameter("overwriteDialogLocale");
            Locale wpLocale = new Locale(this.m_overwriteDialogLocale);
            this.setLocale(wpLocale);
        }
        this.m_opencms = this.getParameter("opencms");
        this.m_targetUrl = this.getParameter("target");
        this.m_redirectUrl = this.getParameter("redirect");
        this.m_redirectTargetFrame = this.getParameter("targetframe");
        if (this.m_redirectTargetFrame == null || this.m_redirectTargetFrame.equals("")) {
            this.m_redirectTargetFrame = "explorer_files";
        }
        this.m_errorUrl = this.getParameter("error");
        this.m_uploadFolder = this.getParameter("filelist");
        this.m_fileFilterSelection = this.getParameter("filefilterselection");
        String tmpSize = this.getParameter("maxsize");
        if (tmpSize != null && tmpSize.length() > 0) {
            this.m_maxsize = Long.parseLong(tmpSize);
        }
        this.m_fileExtensions = this.getParameter("fileExtensions");
        this.m_colors = this.extractColors(this.getParameter("colors"));
        this.m_font = new Font(null, 1, 12);
        this.m_metrics = this.getFontMetrics(this.m_font);
        this.m_source = this.getImage(this.getCodeBase(), "org/opencms/applet/upload/applet_source.png");
        this.m_target = this.getImage(this.getCodeBase(), "org/opencms/applet/upload/applet_target.png");
        this.m_floater = this.getImage(this.getCodeBase(), "org/opencms/applet/upload/floater.gif");
        if (this.getParameter("actionOutputSelect") != null) {
            this.m_actionOutputSelect = this.getParameter("actionOutputSelect");
        }
        if (this.getParameter("actionOutputCount") != null) {
            this.m_actionOutputCount = this.getParameter("actionOutputCount");
        }
        if (this.getParameter("actionOutputCreate") != null) {
            this.m_actionOutputCreate = this.getParameter("actionOutputCreate");
        }
        if (this.getParameter("actionOverwriteCheck") != null) {
            this.m_actionOverwriteCheck = this.getParameter("actionOverwriteCheck");
        }
        if (this.getParameter("actionOutputUpload") != null) {
            this.m_actionOutputUpload = this.getParameter("actionOutputUpload");
        }
        if (this.getParameter("actionOutputError") != null) {
            this.m_actionOutputError = this.getParameter("actionOutputError");
        }
        if (this.getParameter("messageOutputUpload") != null) {
            this.m_messageOutputUpload = this.getParameter("messageOutputUpload");
        }
        if (this.getParameter("messageOutputAdding") != null) {
            this.m_messageOutputAdding = this.getParameter("messageOutputAdding");
        }
        if (this.getParameter("messageOutputErrorZip") != null) {
            this.m_messageOutputErrorZip = this.getParameter("messageOutputErrorZip");
        }
        if (this.getParameter("messageOutputErrorSize") != null) {
            this.m_messageOutputErrorSize = this.getParameter("messageOutputErrorSize");
        }
        if (this.getParameter("messageNoPreview") != null) {
            this.m_messageNoPreview = this.getParameter("messageNoPreview");
        }
        if (this.getParameter("errorLine1") != null) {
            this.m_errorLine1 = this.getParameter("errorLine1");
        }
        if (this.getParameter("certificateErrorTitle") != null) {
            this.m_certificateErrorTitle = this.getParameter("certificateErrorTitle");
        }
        if (this.getParameter("certificateErrorMessage") != null) {
            this.m_certificateErrorMessage = this.getParameter("certificateErrorMessage");
        }
        if (this.getParameter("overwriteDialogTitle") != null) {
            this.m_overwriteDialogTitle = this.getParameter("overwriteDialogTitle");
        }
        if (this.getParameter("overwriteDialogIntro") != null) {
            this.m_overwriteDialogIntro = this.getParameter("overwriteDialogIntro");
        }
        if (this.getParameter("overwriteDialogCancel") != null) {
            this.m_overwriteDialogCancel = this.getParameter("overwriteDialogCancel");
        }
        if (this.getParameter("overwriteDialogOk") != null) {
            this.m_overwriteDialogOk = this.getParameter("overwriteDialogOk");
        }
        if (this.getParameter("clientFolder") != null) {
            this.m_clientFolder = this.getParameter("clientFolder");
        }
        this.m_certificateAccepted = true;
        try {
            System.setProperty("org.apache.commons.logging.LogFactory", "org.apache.commons.logging.impl.LogFactoryImpl");
        }
        catch (SecurityException e) {
            this.m_certificateAccepted = false;
            e.printStackTrace();
        }
    }

    public void moveFloater() {
        this.m_floaterPos += 10;
        if (this.m_floaterPos > 430) {
            this.m_floaterPos = 50;
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        this.m_offscreen = this.createImage(this.getSize().width, this.getSize().height);
        this.m_offgraphics = this.m_offscreen.getGraphics();
        this.m_offgraphics.setColor(this.getColor("bgColor"));
        this.m_offgraphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.m_offgraphics.setColor(this.getColor("outerBorderRightBottom"));
        this.m_offgraphics.drawLine(0, this.getSize().height - 1, this.getSize().width - 1, this.getSize().height - 1);
        this.m_offgraphics.drawLine(this.getSize().width - 1, 0, this.getSize().width - 1, this.getSize().height - 1);
        this.m_offgraphics.setColor(this.getColor("outerBorderLeftTop"));
        this.m_offgraphics.drawLine(0, 0, this.getSize().width - 1, 0);
        this.m_offgraphics.drawLine(0, 0, 0, this.getSize().height - 1);
        this.m_offgraphics.setColor(this.getColor("innerBorderRightBottom"));
        this.m_offgraphics.drawLine(1, this.getSize().height - 2, this.getSize().width - 2, this.getSize().height - 2);
        this.m_offgraphics.drawLine(this.getSize().width - 2, 1, this.getSize().width - 2, this.getSize().height - 2);
        this.m_offgraphics.setColor(this.getColor("innerBorderLeftTop"));
        this.m_offgraphics.drawLine(1, 1, this.getSize().width - 2, 1);
        this.m_offgraphics.drawLine(1, 1, 1, this.getSize().height - 2);
        this.m_offgraphics.setColor(this.getColor("bgHeadline"));
        this.m_offgraphics.fillRect(4, 4, this.getSize().width - 5, 18);
        this.m_offgraphics.setColor(this.getColor("innerBorderRightBottom"));
        this.m_offgraphics.drawLine(10, this.getSize().height - 11, this.getSize().width - 11, this.getSize().height - 11);
        this.m_offgraphics.drawLine(this.getSize().width - 11, 25, this.getSize().width - 11, this.getSize().height - 11);
        this.m_offgraphics.setColor(this.getColor("innerBorderLeftTop"));
        this.m_offgraphics.drawLine(10, 25, this.getSize().width - 11, 25);
        this.m_offgraphics.drawLine(10, 25, 10, this.getSize().height - 11);
        int cx = 10;
        int cy = 17;
        this.m_offgraphics.setFont(this.m_font);
        this.m_offgraphics.setColor(this.getColor("colorHeadline"));
        this.m_offgraphics.drawString(this.m_action, cx, cy);
        this.m_offgraphics.setColor(this.getColor("colorText"));
        cx = this.m_outputMode >= 3 ? Math.max((this.getSize().width - this.m_metrics.stringWidth(this.m_message)) / 2, 0) : 25;
        cy = 41;
        this.m_offgraphics.drawString(this.m_message, cx, cy);
        if (this.m_outputMode == 2) {
            float bar = new Float(this.m_step).floatValue() / new Float(this.m_resources).floatValue();
            String barText = "(" + this.m_step + " / " + this.m_resources + ")";
            this.m_offgraphics.drawRect(25, 50, 450, 20);
            this.m_offgraphics.setColor(Color.white);
            this.m_offgraphics.fillRect(26, 51, 449, 19);
            this.m_offgraphics.setColor(this.getColor("progessBar"));
            this.m_offgraphics.fillRect(26, 51, new Float(bar * 449.0f).intValue(), 19);
            int progressWith = this.m_metrics.stringWidth(barText);
            cx = Math.max((this.getSize().width - progressWith) / 2, 0);
            cy = 64;
            this.m_offgraphics.setColor(Color.black);
            this.m_offgraphics.drawString(barText, cx, cy);
        }
        if (this.m_outputMode == 3) {
            this.m_offgraphics.drawImage(this.m_floater, this.m_floaterPos, 57, this);
            this.m_offgraphics.drawImage(this.m_source, 30, 47, this);
            this.m_offgraphics.drawImage(this.m_target, 440, 47, this);
        }
        g.drawImage(this.m_offscreen, 0, 0, null);
    }

    private List parseDuplicateFiles(String responseBodyAsString) {
        ArrayList<String> result = new ArrayList<String>();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(responseBodyAsString.getBytes())));
        try {
            String read = reader.readLine();
            while (read != null) {
                String trim = read.trim();
                if (!trim.equals("") && !trim.equals("\n")) {
                    result.add(read);
                }
                read = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void run() {
        try {
            boolean ok = true;
            while (ok) {
                File clientFolder;
                ok = true;
                this.m_message = "";
                this.m_resources = 0;
                this.m_step = 0;
                if (this.m_fileSelector == null) {
                    this.m_fileSelector = new UploadAppletFileChooser(this);
                }
                this.m_fileSelector.setFileSelectionMode(2);
                this.m_fileSelector.setDialogTitle(this.m_actionOutputSelect);
                ImageFilter imageFilter = new ImageFilter();
                OfficeFilter officeFilter = new OfficeFilter();
                WebFilter webFilter = new WebFilter();
                this.m_fileSelector.addChoosableFileFilter(imageFilter);
                this.m_fileSelector.addChoosableFileFilter(officeFilter);
                this.m_fileSelector.addChoosableFileFilter(webFilter);
                this.m_fileSelector.setAcceptAllFileFilterUsed(true);
                this.m_fileSelector.setMultiSelectionEnabled(true);
                this.m_fileSelector.setFileView(new ImageFileView(this.m_opencms, this.m_fileExtensions));
                this.m_fileSelector.setAccessory(new ImagePreview(this.m_fileSelector, this.m_messageNoPreview));
                if (this.m_clientFolder != null && !this.m_clientFolder.trim().equals("") && (clientFolder = new File(this.m_clientFolder)).exists() && clientFolder.isDirectory()) {
                    this.m_fileSelector.setCurrentDirectory(clientFolder);
                }
                this.m_action = this.m_actionOutputSelect;
                if (this.m_fileFilterSelection != null && !this.m_fileFilterSelection.trim().equals("")) {
                    if ("webfilter".equals(this.m_fileFilterSelection)) {
                        this.m_fileSelector.setFileFilter(webFilter);
                    } else if ("officefilter".equals(this.m_fileFilterSelection)) {
                        this.m_fileSelector.setFileFilter(officeFilter);
                    } else if ("imagefilter".equals(this.m_fileFilterSelection)) {
                        this.m_fileSelector.setFileFilter(imageFilter);
                    }
                }
                this.repaint();
                this.m_overwrites = new ArrayList();
                int returnVal = this.m_fileSelector.showDialog(this, "OK");
                if (returnVal == 0) {
                    int i;
                    this.m_outputMode = 1;
                    this.m_action = this.m_actionOutputCount;
                    this.repaint();
                    File[] files = this.m_fileSelector.getSelectedFiles();
                    ArrayList fileNames = new ArrayList();
                    for (i = 0; i < files.length; ++i) {
                        this.getRelativeFilePaths(files[i], fileNames);
                    }
                    if (this.m_overwrites.size() > 0) {
                        files = this.subtractDuplicates(fileNames, this.m_overwrites);
                        files = this.addOverwrites(files, ((FileSelectionPanel)this.m_overwriteDialog.getControlPanel().getComponent(1)).getSelectedFiles());
                    } else {
                        fileNames = new ArrayList();
                        for (i = 0; i < files.length; ++i) {
                            this.getFilesInTree(files[i], fileNames);
                        }
                        files = fileNames.toArray(new File[fileNames.size()]);
                    }
                    this.m_resources = this.countResources(files);
                    this.m_outputMode = 2;
                    if (files.length > 0) {
                        File targetFile = this.createZipFile(files);
                        if (targetFile == null || this.m_maxsize > 0L && targetFile.length() > this.m_maxsize) {
                            this.m_outputMode = 4;
                            this.m_message = targetFile == null ? this.m_messageOutputErrorZip : this.m_messageOutputErrorSize + " " + targetFile.length() + " > " + this.m_maxsize;
                            this.m_action = this.m_actionOutputError;
                            this.repaint();
                            JOptionPane.showMessageDialog(this, this.m_message, this.m_action, 0);
                            continue;
                        }
                        this.m_outputMode = 3;
                        this.m_message = this.m_messageOutputUpload + " (" + targetFile.length() / 1024L + " kb)";
                        this.repaint();
                        FileUploadThread uploadThreat = new FileUploadThread();
                        uploadThreat.init(this);
                        uploadThreat.start();
                        this.uploadZipFile(targetFile);
                        ok = false;
                        continue;
                    }
                    ok = false;
                    this.getAppletContext().showDocument(new URL(this.m_redirectUrl), this.m_redirectTargetFrame);
                    continue;
                }
                ok = false;
                this.getAppletContext().showDocument(new URL(this.m_redirectUrl), this.m_redirectTargetFrame);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int showDuplicationsDialog(List duplications) {
        int rtv = -1;
        try {
            JTextArea dialogIntroPanel = new JTextArea();
            dialogIntroPanel.setLineWrap(true);
            dialogIntroPanel.setWrapStyleWord(true);
            dialogIntroPanel.setText(this.m_overwriteDialogIntro);
            dialogIntroPanel.setEditable(false);
            dialogIntroPanel.setBackground(this.m_fileSelector.getBackground());
            dialogIntroPanel.setFont(this.m_font);
            FileSelectionPanel selectionPanel = new FileSelectionPanel(duplications, this.m_fileSelector.getCurrentDirectory().getAbsolutePath());
            JPanel stacker = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            stacker.add((Component)dialogIntroPanel, gbc);
            gbc.weighty = 1.0;
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 2, 0, 2);
            stacker.add((Component)selectionPanel, gbc);
            this.m_overwriteDialog = new ModalDialog(this.m_fileSelector, this.m_overwriteDialogTitle, this.m_overwriteDialogOk, this.m_overwriteDialogCancel, stacker);
            this.m_overwriteDialog.setSize(new Dimension(560, 280));
            this.m_overwriteDialog.showDialog();
            rtv = this.m_overwriteDialog.getReturnValue();
        }
        catch (Throwable f) {
            f.printStackTrace(System.err);
        }
        return rtv;
    }

    public void start() {
        if (this.m_certificateAccepted) {
            this.m_runner = new Thread(this);
            this.m_runner.start();
        } else {
            this.displayError();
        }
    }

    public void stop() {
        this.m_runner = null;
    }

    private File[] subtractDuplicates(List fileNames, List duplications) {
        String path;
        Iterator itDuplications = duplications.iterator();
        while (itDuplications.hasNext()) {
            path = (String)itDuplications.next();
            fileNames.remove(path);
        }
        ArrayList<File> result = new ArrayList<File>();
        File rootPath = this.m_fileSelector.getCurrentDirectory();
        Iterator it = fileNames.iterator();
        while (it.hasNext()) {
            path = (String)it.next();
            result.add(new File(rootPath, path));
        }
        return result.toArray(new File[result.size()]);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadZipFile(File uploadFile) {
        this.m_action = this.m_actionOutputUpload;
        this.repaint();
        PostMethod post = new PostMethod(this.m_targetUrl);
        try {
            Part[] parts = new Part[]{new FilePart(uploadFile.getName(), uploadFile), new StringPart("action", "submitform"), new StringPart("unzipfile", "true"), new StringPart("uploadfolder", this.m_uploadFolder), new StringPart("clientfolder", this.m_fileSelector.getCurrentDirectory().getAbsolutePath())};
            HttpMethodParams methodParams = post.getParams();
            methodParams.setCookiePolicy("compatibility");
            MultipartRequestEntity request = new MultipartRequestEntity(parts, methodParams);
            post.setRequestEntity(request);
            String sessionId = this.getParameter("sessionId");
            String query = ";" + C_JSESSIONID.toLowerCase() + "=" + sessionId;
            post.setQueryString(query);
            post.addRequestHeader(C_JSESSIONID, sessionId);
            HttpClient client = new HttpClient();
            HttpConnectionManagerParams connectionParams = client.getHttpConnectionManager().getParams();
            connectionParams.setConnectionTimeout(5000);
            client.getState();
            client.getHostConfiguration().getHost();
            HttpState initialState = new HttpState();
            URI uri = new URI(this.m_targetUrl, false);
            Cookie sessionCookie = new Cookie(uri.getHost(), C_JSESSIONID, sessionId, "/", null, false);
            initialState.addCookie(sessionCookie);
            client.setState(initialState);
            int status = client.executeMethod(post);
            if (status == 200) {
                this.getAppletContext().showDocument(new URL(this.m_redirectUrl), this.m_redirectTargetFrame);
            } else {
                String error = this.m_errorLine1 + "\n" + post.getStatusLine();
                this.getAppletContext().showDocument(new URL(this.m_errorUrl + "?action=showerror&uploaderror=" + error), "explorer_files");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            post.releaseConnection();
            uploadFile.delete();
        }
    }

    private void writeFileBytes(File file, OutputStream out) throws Exception {
        byte[] buffer = new byte[2048];
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
            int size = new Long(file.length()).intValue();
            int readCount = 0;
            for (int charsRead = 0; charsRead < size && readCount != -1; charsRead += readCount) {
                readCount = fileStream.read(buffer);
                out.write(buffer, 0, readCount);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

