/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.applet.upload;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileView;
import org.opencms.applet.upload.FileUploadUtils;

public class ImageFileView
extends FileView {
    private HashMap m_extensions;
    private String m_opencms;

    public ImageFileView() {
    }

    public ImageFileView(String opencms, String fileExtensions) {
        this.m_opencms = opencms;
        this.m_extensions = this.extractExtensions(fileExtensions);
    }

    public String getDescription(File f) {
        return null;
    }

    public Icon getIcon(File f) {
        String extension = FileUploadUtils.getExtension(f);
        Icon icon = null;
        icon = f.isDirectory() ? (Icon)this.m_extensions.get("FOLDER") : (Icon)this.m_extensions.get(extension);
        if (icon == null) {
            icon = (Icon)this.m_extensions.get("txt");
        }
        return icon;
    }

    public String getName(File f) {
        return null;
    }

    public Boolean isTraversable(File f) {
        return null;
    }

    private ImageIcon createImageIcon(String path) {
        try {
            URL imgURL = new URL(path);
            ImageIcon img = new ImageIcon(imgURL);
            return img;
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    private HashMap extractExtensions(String fileExtensions) {
        HashMap<String, ImageIcon> extensions = new HashMap<String, ImageIcon>();
        fileExtensions = fileExtensions + ",FOLDER=folder,";
        StringTokenizer tok = new StringTokenizer(fileExtensions, ",");
        while (tok.hasMoreElements()) {
            String token = tok.nextToken();
            String extension = token.substring(0, token.indexOf("="));
            String type = token.substring(token.indexOf("=") + 1);
            ImageIcon icon = this.createImageIcon(this.m_opencms + type + ".gif");
            extensions.put(extension, icon);
        }
        return extensions;
    }
}

