/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.applet.upload;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.opencms.applet.upload.FileUploadUtils;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private static final int C_MODE_EMPTY = 0;
    private static final int C_MODE_IMAGE = 1;
    private static final int C_MODE_TEXT = 2;
    private static final long serialVersionUID = 4851280416316056303L;
    private File m_file;
    private Font m_font;
    private String m_messageNoPreview;
    private int m_mode;
    private String[] m_text;
    private ImageIcon m_thumbnail;

    public ImagePreview(JFileChooser fc, String messageNoPreview) {
        this.setPreferredSize(new Dimension(200, 100));
        fc.addPropertyChangeListener(this);
        this.m_font = new Font(null, 0, 9);
        this.m_messageNoPreview = messageNoPreview;
        this.m_mode = 0;
    }

    public void loadImage() {
        if (this.m_file == null) {
            this.m_thumbnail = null;
            return;
        }
        ImageIcon tmpIcon = new ImageIcon(this.m_file.getPath());
        this.m_thumbnail = tmpIcon.getIconWidth() > 190 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(190, -1, 1)) : tmpIcon;
    }

    public void paintComponent(Graphics g) {
        if (this.m_mode == 1) {
            if (this.m_thumbnail == null) {
                this.loadImage();
            }
            if (this.m_thumbnail != null) {
                int x = this.getWidth() / 2 - this.m_thumbnail.getIconWidth() / 2;
                int y = this.getHeight() / 2 - this.m_thumbnail.getIconHeight() / 2;
                if (y < 0) {
                    y = 0;
                }
                if (x < 5) {
                    x = 5;
                }
                this.m_thumbnail.paintIcon(this, g, x, y);
            }
        } else if (this.m_mode == 2) {
            g.setColor(Color.white);
            g.fillRect(10, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(Color.black);
            g.drawRect(10, 0, this.getWidth() - 11, this.getHeight() - 1);
            g.setFont(this.m_font);
            for (int i = 0; i < 35; ++i) {
                if (this.m_text[i] == null) continue;
                g.drawString(this.m_text[i], 13, (i + 1) * 11);
            }
        } else {
            g.setColor(Color.black);
            g.setFont(this.m_font);
            g.drawString(this.m_messageNoPreview, 30, this.getHeight() / 2);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.m_file = null;
            this.m_text = null;
            update = true;
            this.m_mode = 0;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.m_file = (File)e.getNewValue();
            this.m_mode = this.getMode();
            update = true;
        }
        if (update) {
            this.m_thumbnail = null;
            if (this.isShowing()) {
                if (this.m_mode == 1) {
                    this.loadImage();
                    this.repaint();
                } else if (this.m_mode == 2) {
                    this.loadText();
                    this.repaint();
                } else {
                    this.repaint();
                }
            }
        }
    }

    private int getMode() {
        int mode = 0;
        String extension = FileUploadUtils.getExtension(this.m_file);
        if (FileUploadUtils.isImageExtension(extension)) {
            mode = 1;
        } else if (FileUploadUtils.isTextExtension(extension)) {
            mode = 2;
        }
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadText() {
        this.m_text = new String[35];
        BufferedReader fileStream = null;
        try {
            fileStream = new BufferedReader(new FileReader(this.m_file));
            for (int i = 0; i < 35; ++i) {
                this.m_text[i] = fileStream.readLine();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

