/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.ImageFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RenderSettings {
    protected static final RenderingHints HINTS_MEDIUM = RenderSettings.initHints(1);
    protected static final RenderingHints HINTS_QUALITY = RenderSettings.initHints(0);
    protected static final RenderingHints HINTS_SPEED = RenderSettings.initHints(2);
    private float m_compressionQuality;
    private RenderingHints m_hints;
    private List m_imageFilters;
    private boolean m_isUseBlur;
    private int m_maximumBlurSize;
    private int m_threadNicePriority;
    private int m_threadOldPriority;
    private Color m_transparentReplaceColor;

    public RenderSettings(int baseMode) {
        this(baseMode, null);
    }

    public RenderSettings(int baseMode, RenderingHints hints) {
        switch (baseMode) {
            case 2: {
                this.m_hints = HINTS_SPEED;
                this.m_compressionQuality = 0.35f;
                this.m_isUseBlur = false;
                break;
            }
            case 1: {
                this.m_hints = HINTS_MEDIUM;
                this.m_compressionQuality = 0.5f;
                this.m_isUseBlur = false;
                break;
            }
            default: {
                this.m_hints = HINTS_QUALITY;
                this.m_compressionQuality = 0.7f;
                this.m_isUseBlur = true;
            }
        }
        if (hints != null) {
            RenderingHints newHints = new RenderingHints(null);
            newHints.add(this.m_hints);
            newHints.add(hints);
            this.m_hints = newHints;
        }
        this.m_transparentReplaceColor = Color.WHITE;
        this.m_imageFilters = new ArrayList();
        this.m_maximumBlurSize = 6250000;
        this.m_threadNicePriority = 1;
    }

    private static RenderingHints initHints(int mode) {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        switch (mode) {
            case 2: {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DEFAULT);
                hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                break;
            }
            case 0: 
            case 1: {
                hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            }
        }
        return new RenderingHints(hints);
    }

    public void addImageFilter(ImageFilter filter) {
        this.m_imageFilters.add(filter);
    }

    public float getCompressionQuality() {
        return this.m_compressionQuality;
    }

    public List getImageFilters() {
        return new ArrayList(this.m_imageFilters);
    }

    public int getMaximumBlurSize() {
        return this.m_maximumBlurSize;
    }

    public Color getTransparentReplaceColor() {
        return this.m_transparentReplaceColor;
    }

    public boolean isUseBlur() {
        return this.m_isUseBlur;
    }

    public void setCompressionQuality(float compressionQuality) {
        if (compressionQuality < 0.0f || compressionQuality > 1.0f) {
            throw new IllegalArgumentException("compression quality must be between 0.0f and 1.0f");
        }
        this.m_compressionQuality = compressionQuality;
    }

    public void setMaximumBlurSize(int maximumBlurSize) {
        this.m_maximumBlurSize = maximumBlurSize;
    }

    public void setTransparentReplaceColor(Color transparentColor) {
        this.m_transparentReplaceColor = transparentColor;
    }

    protected RenderingHints getRenderingHints() {
        return this.m_hints;
    }

    protected int getThreadNicePriority() {
        return this.m_threadNicePriority;
    }

    protected int getThreadOldPriority() {
        if (this.m_threadOldPriority <= 0) {
            this.m_threadOldPriority = 5;
        }
        return this.m_threadOldPriority;
    }

    protected void setThreadNicePriority(int threadNicePriority) {
        this.m_threadNicePriority = threadNicePriority;
    }

    protected void setThreadOldPriority(int threadOldPriority) {
        this.m_threadOldPriority = threadOldPriority;
    }
}

