/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.Colormap;
import com.alkacon.simapi.filter.LinearColormap;
import com.alkacon.simapi.filter.WholeImageFilter;
import java.io.Serializable;
import java.util.Date;
import java.util.Random;

public class CraterFilter
extends WholeImageFilter
implements Serializable {
    static final long serialVersionUID = 6491871753122667752L;
    private Colormap colormap = new LinearColormap();
    private Random randomGenerator = new Random();
    private long seed = 567L;
    private int numCraters = 25000;
    private float depthPower = 1.0f;
    private float depthBias = 0.707107f;
    private float depthScaling = 1.0f;
    private boolean spherical = false;

    public void setNumCraters(int numCraters) {
        this.numCraters = numCraters;
    }

    public int getNumCraters() {
        return this.numCraters;
    }

    public void setDepthPower(float depthPower) {
        this.depthPower = depthPower;
    }

    public float getDepthPower() {
        return this.depthPower;
    }

    public void setDepthBias(float depthBias) {
        this.depthBias = depthBias;
    }

    public float getDepthBias() {
        return this.depthBias;
    }

    public void setDepthScaling(float depthScaling) {
        this.depthScaling = depthScaling;
    }

    public float getDepthScaling() {
        return this.depthScaling;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setSpherical(boolean spherical) {
        this.spherical = spherical;
    }

    public boolean isSpherical() {
        return this.spherical;
    }

    public void randomize() {
        this.seed = new Date().getTime();
    }

    private float random(float low, float high) {
        return low + (high - low) * this.randomGenerator.nextFloat();
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        try {
            int x;
            int width = this.originalSpace.width;
            int height = this.originalSpace.height;
            int[] outPixels = new int[width * height];
            this.randomGenerator.setSeed(this.seed);
            int i = 0;
            int y = 0;
            while (y < height) {
                x = 0;
                while (x < width) {
                    outPixels[i++] = Short.MAX_VALUE;
                    ++x;
                }
                ++y;
            }
            i = 0;
            while (i < this.numCraters) {
                int axelev;
                int a;
                int sx;
                int cx = (int)this.random(0.0f, width - 1);
                int cy = (int)this.random(0.0f, height - 1);
                int amptot = 0;
                int npatch = 0;
                float g = (float)Math.sqrt(1.0f / ((float)Math.PI * (1.0f - this.random(0.0f, 0.9999f))));
                if (g < 3.0f) {
                    y = Math.max(0, cy - 1);
                    while (y <= Math.min(height - 1, cy + 1)) {
                        sx = Math.max(0, cx - 1);
                        a = y * width + sx;
                        x = sx;
                        while (x <= Math.min(width - 1, cx + 1)) {
                            amptot += outPixels[a++];
                            ++npatch;
                            ++x;
                        }
                        ++y;
                    }
                    axelev = amptot / npatch;
                    x = g >= 1.0f ? (this.randomGenerator.nextInt() >> 8 & 3) - 1 : 0;
                    x = (int)((float)x * this.depthScaling);
                    outPixels[width * cy + cx] = axelev + x;
                } else {
                    int gx = (int)Math.max(2.0f, g / 3.0f);
                    int gy = (int)Math.max(2.0f, g / 3.0f);
                    y = Math.max(0, cy - gy);
                    while (y <= Math.min(height - 1, cy + gy)) {
                        sx = Math.max(0, cx - gx);
                        a = y * width + sx;
                        x = sx;
                        while (x <= Math.min(width - 1, cx + gx)) {
                            amptot += outPixels[a++];
                            ++npatch;
                            ++x;
                        }
                        ++y;
                    }
                    axelev = amptot / npatch;
                    gy = (int)Math.max(2.0f, g);
                    g = gy;
                    gx = (int)Math.max(2.0f, g);
                    y = Math.max(0, cy - gy);
                    while (y <= Math.min(height - 1, cy + gy)) {
                        sx = Math.max(0, cx - gx);
                        int ax = y * width + sx;
                        float dy = (float)(cy - y) / (float)gy;
                        float dysq = dy * dy;
                        x = sx;
                        while (x <= Math.min(width - 1, cx + gx)) {
                            float dx = (float)(cx - x) / (float)gx;
                            float cd = dx * dx + dysq;
                            float cd2 = cd * 2.25f;
                            float tcz = this.depthBias - (float)Math.sqrt(Math.abs(1.0f - cd2));
                            float cz = Math.max(cd2 > 1.0f ? 0.0f : -10.0f, tcz);
                            if (dy == 0.0f && dx == 0.0f && (int)(cz *= (float)Math.pow(g, this.depthPower)) == 0) {
                                cz = cz < 0.0f ? -1 : 1;
                            }
                            float rollmin = 0.9f;
                            float roll = (1.0f / (1.0f - Math.min(rollmin, cd)) / (1.0f / (1.0f - rollmin)) - (1.0f - rollmin)) / rollmin;
                            float iroll = 1.0f - roll;
                            int av = (int)(((float)axelev + (cz *= this.depthScaling)) * iroll + ((float)outPixels[ax] + cz) * roll);
                            av = Math.max(1000, Math.min(64000, av));
                            outPixels[ax++] = av;
                            ++x;
                        }
                        ++y;
                    }
                }
                ++i;
            }
            float ImageGamma = 0.5f;
            float dgamma = 1.0f;
            int slopemin = -52;
            int slopemax = 52;
            i = Math.max(slopemax - slopemin + 1, 1);
            float[] slopemap = new float[i];
            i = slopemin;
            while (i <= slopemax) {
                slopemap[i - slopemin] = i > 0 ? 0.5f + 0.5f * (float)Math.pow(Math.sin(1.5707964f * (float)i / (float)slopemax), dgamma * ImageGamma) : 0.5f - 127.0f * (float)Math.pow(Math.sin(1.5707964f * (float)i / (float)slopemin), dgamma * ImageGamma);
                ++i;
            }
            if (this.colormap != null) {
                int index = 0;
                y = 0;
                while (y < height) {
                    int last = outPixels[index];
                    x = 0;
                    while (x < width) {
                        int t = outPixels[index];
                        int j = t - last;
                        j = Math.min(Math.max(slopemin, j), slopemax);
                        outPixels[index] = this.colormap.getColor(slopemap[j - slopemin]);
                        last = t;
                        ++index;
                        ++x;
                    }
                    ++y;
                }
            }
            this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
            this.consumer.imageComplete(status);
            this.inPixels = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Texture/Crater...";
    }
}

