/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.Colormap;
import com.alkacon.simapi.filter.PixelUtils;
import com.alkacon.simapi.filter.WholeImageFilter;

public class DistanceFilter
extends WholeImageFilter {
    private float factor = 1.0f;
    protected Colormap colormap;
    private boolean useAlpha = true;
    private static final int one = 41;
    private static final int sqrt2 = 58;
    private static final int sqrt5 = 92;

    public void setFactor(float factor) {
        this.factor = factor;
    }

    public float getFactor() {
        return this.factor;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setUseAlpha(boolean useAlpha) {
        this.useAlpha = useAlpha;
    }

    public boolean getUseAlpha() {
        return this.useAlpha;
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        try {
            int width = this.originalSpace.width;
            int height = this.originalSpace.height;
            int[] outPixels = new int[width * height];
            this.convertToIntegers(this.inPixels, outPixels, width, height);
            int max = this.distanceMap(outPixels, width, height);
            this.convertToPixels(outPixels, width, height, max);
            this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
            this.consumer.imageComplete(status);
            this.inPixels = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int distanceMap(int[] pixels, int width, int height) {
        int v;
        int offset;
        int x;
        int xmax = width - 3;
        int ymax = height - 3;
        int max = 0;
        int y = 0;
        while (y < height) {
            x = 0;
            while (x < width) {
                offset = x + y * width;
                if (pixels[offset] > 0 && (v = x < 2 || x > xmax || y < 2 || y > ymax ? this.setEdgeValue(x, y, pixels, width, offset, xmax, ymax) : this.setValue(pixels, width, offset)) > max) {
                    max = v;
                }
                ++x;
            }
            ++y;
        }
        y = height - 1;
        while (y >= 0) {
            x = width - 1;
            while (x >= 0) {
                offset = x + y * width;
                if (pixels[offset] > 0 && (v = x < 2 || x > xmax || y < 2 || y > ymax ? this.setEdgeValue(x, y, pixels, width, offset, xmax, ymax) : this.setValue(pixels, width, offset)) > max) {
                    max = v;
                }
                --x;
            }
            --y;
        }
        return max;
    }

    private void convertToIntegers(int[] inPixels, int[] outPixels, int width, int height) {
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int offset = x + y * width;
                int b = this.useAlpha ? inPixels[offset] >> 24 & 0xFF : (PixelUtils.brightness(inPixels[offset]) > 127 ? 255 : 0);
                outPixels[offset] = b * 41;
                ++x;
            }
            ++y;
        }
    }

    private void convertToPixels(int[] pixels, int width, int height, int max) {
        int round = 20;
        if (max == 0) {
            max = 1;
        }
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int offset = x + y * width;
                if (this.colormap == null) {
                    int v = (int)(this.factor * (float)(pixels[offset] + round) / 41.0f);
                    if (v > 255) {
                        v = 255;
                    }
                    pixels[offset] = 0xFF000000 | v << 16 | v << 8 | v;
                } else {
                    float v = this.factor * (float)(pixels[offset] + round) / 41.0f / 255.0f;
                    pixels[offset] = this.colormap.getColor(v);
                }
                ++x;
            }
            ++y;
        }
    }

    private int setEdgeValue(int x, int y, int[] pixels, int width, int offset, int xmax, int ymax) {
        int min;
        int r1 = offset - width - width - 2;
        int r2 = r1 + width;
        int r3 = r2 + width;
        int r4 = r3 + width;
        int r5 = r4 + width;
        int offimage = pixels[r3 + 2];
        int v = y < 2 ? offimage + 41 : pixels[r2 + 2] + 41;
        v = x < 2 ? offimage + 41 : pixels[r3 + 1] + 41;
        if (v < (min = v)) {
            min = v;
        }
        if ((v = x > xmax ? offimage + 41 : pixels[r3 + 3] + 41) < min) {
            min = v;
        }
        if ((v = y > ymax ? offimage + 41 : pixels[r4 + 2] + 41) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + 58 : pixels[r2 + 1] + 58) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + 58 : pixels[r2 + 3] + 58) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + 58 : pixels[r4 + 1] + 58) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + 58 : pixels[r4 + 3] + 58) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + 92 : pixels[r1 + 1] + 92) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + 92 : pixels[r1 + 3] + 92) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + 92 : pixels[r2 + 4] + 92) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + 92 : pixels[r4 + 4] + 92) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + 92 : pixels[r5 + 3] + 92) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + 92 : pixels[r5 + 1] + 92) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + 92 : pixels[r4] + 92) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + 92 : pixels[r2] + 92) < min) {
            min = v;
        }
        pixels[offset] = min;
        return pixels[offset];
    }

    private int setValue(int[] pixels, int width, int offset) {
        int r1 = offset - width - width - 2;
        int r2 = r1 + width;
        int r3 = r2 + width;
        int r4 = r3 + width;
        int r5 = r4 + width;
        int v = pixels[r3 + 1] + 41;
        v = pixels[r2 + 2] + 41;
        int min = v;
        if (v < min) {
            min = v;
        }
        if ((v = pixels[r3 + 3] + 41) < min) {
            min = v;
        }
        if ((v = pixels[r4 + 2] + 41) < min) {
            min = v;
        }
        if ((v = pixels[r2 + 1] + 58) < min) {
            min = v;
        }
        if ((v = pixels[r2 + 3] + 58) < min) {
            min = v;
        }
        if ((v = pixels[r4 + 1] + 58) < min) {
            min = v;
        }
        if ((v = pixels[r4 + 3] + 58) < min) {
            min = v;
        }
        if ((v = pixels[r1 + 1] + 92) < min) {
            min = v;
        }
        if ((v = pixels[r1 + 3] + 92) < min) {
            min = v;
        }
        if ((v = pixels[r2 + 4] + 92) < min) {
            min = v;
        }
        if ((v = pixels[r4 + 4] + 92) < min) {
            min = v;
        }
        if ((v = pixels[r5 + 3] + 92) < min) {
            min = v;
        }
        if ((v = pixels[r5 + 1] + 92) < min) {
            min = v;
        }
        if ((v = pixels[r4] + 92) < min) {
            min = v;
        }
        if ((v = pixels[r2] + 92) < min) {
            min = v;
        }
        pixels[offset] = min;
        return pixels[offset];
    }

    public String toString() {
        return "Binary/Distance Map";
    }
}

