/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.BinaryFilter;

public class ErodeFilter
extends BinaryFilter {
    static final long serialVersionUID = 1791577333635724103L;
    protected int threshold = 2;

    public ErodeFilter() {
        this.newColor = -1;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        try {
            int width = this.originalSpace.width;
            int height = this.originalSpace.height;
            int[] outPixels = new int[width * height];
            int i = 0;
            while (i < this.iterations) {
                int index = 0;
                if (i > 0) {
                    int[] t = this.inPixels;
                    this.inPixels = outPixels;
                    outPixels = t;
                }
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        int pixel = this.inPixels[y * width + x];
                        if (this.blackFunction.isBlack(pixel)) {
                            int neighbours = 0;
                            int dy = -1;
                            while (dy <= 1) {
                                int iy = y + dy;
                                if (iy >= 0 && iy < height) {
                                    int ioffset = iy * width;
                                    int dx = -1;
                                    while (dx <= 1) {
                                        int rgb;
                                        int ix = x + dx;
                                        if (!(dy == 0 && dx == 0 || ix < 0 || ix >= width || this.blackFunction.isBlack(rgb = this.inPixels[ioffset + ix]))) {
                                            ++neighbours;
                                        }
                                        ++dx;
                                    }
                                }
                                ++dy;
                            }
                            if (neighbours >= this.threshold) {
                                pixel = this.colormap != null ? this.colormap.getColor((float)i / (float)this.iterations) : this.newColor;
                            }
                        }
                        outPixels[index++] = pixel;
                        ++x;
                    }
                    ++y;
                }
                ++i;
            }
            this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
            this.consumer.imageComplete(status);
            this.inPixels = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Binary/Erode...";
    }
}

