/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class FlipFilter
extends ImageFilter {
    public static final int FLIP_H = 1;
    public static final int FLIP_V = 2;
    public static final int FLIP_HV = 3;
    public static final int FLIP_90CW = 4;
    public static final int FLIP_90CCW = 5;
    public static final int FLIP_180 = 6;
    private int operation;
    private int width;
    private int height;
    private int newWidth;
    private int newHeight;

    public FlipFilter() {
        this(3);
    }

    public FlipFilter(int operation) {
        this.operation = operation;
    }

    public void setHints(int hintflags) {
        this.consumer.setHints(hintflags &= 0xFFFFFFFD);
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        switch (this.operation) {
            case 1: 
            case 2: 
            case 6: {
                this.newWidth = width;
                this.newHeight = height;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.newWidth = height;
                this.newHeight = width;
            }
        }
        this.consumer.setDimensions(this.newWidth, this.newHeight);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int newX = x;
        int newY = y;
        int newW = w;
        int newH = h;
        switch (this.operation) {
            case 1: {
                newX = this.width - (x + w);
                break;
            }
            case 2: {
                newY = this.height - (y + h);
                break;
            }
            case 3: {
                newW = h;
                newH = w;
                newX = y;
                newY = x;
                break;
            }
            case 4: {
                newW = h;
                newH = w;
                newX = this.height - (y + h);
                newY = x;
                break;
            }
            case 5: {
                newW = h;
                newH = w;
                newX = y;
                newY = this.width - (x + w);
                break;
            }
            case 6: {
                newX = this.width - (x + w);
                newY = this.height - (y + h);
            }
        }
        byte[] newPixels = new byte[newW * newH];
        int row = 0;
        while (row < h) {
            int col = 0;
            while (col < w) {
                int index = row * scansize + off + col;
                int newRow = row;
                int newCol = col;
                switch (this.operation) {
                    case 1: {
                        newCol = w - col - 1;
                        break;
                    }
                    case 2: {
                        newRow = h - row - 1;
                        break;
                    }
                    case 3: {
                        newRow = col;
                        newCol = row;
                        break;
                    }
                    case 4: {
                        newRow = col;
                        newCol = h - row - 1;
                        break;
                    }
                    case 5: {
                        newRow = w - col - 1;
                        newCol = row;
                        break;
                    }
                    case 6: {
                        newRow = h - row - 1;
                        newCol = w - col - 1;
                    }
                }
                int newIndex = newRow * newW + newCol;
                newPixels[newIndex] = pixels[index];
                ++col;
            }
            ++row;
        }
        this.consumer.setPixels(newX, newY, newW, newH, model, newPixels, 0, newW);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int newX = x;
        int newY = y;
        int newW = w;
        int newH = h;
        switch (this.operation) {
            case 1: {
                newX = this.width - (x + w);
                break;
            }
            case 2: {
                newY = this.height - (y + h);
                break;
            }
            case 3: {
                newW = h;
                newH = w;
                newX = y;
                newY = x;
                break;
            }
            case 4: {
                newW = h;
                newH = w;
                newX = this.height - (y + h);
                newY = x;
                break;
            }
            case 5: {
                newW = h;
                newH = w;
                newX = y;
                newY = this.width - (x + w);
                break;
            }
            case 6: {
                newX = this.width - (x + w);
                newY = this.height - (y + h);
            }
        }
        int[] newPixels = new int[newW * newH];
        int row = 0;
        while (row < h) {
            int col = 0;
            while (col < w) {
                int index = row * scansize + off + col;
                int newRow = row;
                int newCol = col;
                switch (this.operation) {
                    case 1: {
                        newCol = w - col - 1;
                        break;
                    }
                    case 2: {
                        newRow = h - row - 1;
                        break;
                    }
                    case 3: {
                        newRow = col;
                        newCol = row;
                        break;
                    }
                    case 4: {
                        newRow = col;
                        newCol = h - row - 1;
                        break;
                    }
                    case 5: {
                        newRow = w - col - 1;
                        newCol = row;
                        break;
                    }
                    case 6: {
                        newRow = h - row - 1;
                        newCol = w - col - 1;
                    }
                }
                int newIndex = newRow * newW + newCol;
                newPixels[newIndex] = pixels[index];
                ++col;
            }
            ++row;
        }
        this.consumer.setPixels(newX, newY, newW, newH, model, newPixels, 0, newW);
    }

    public String toString() {
        switch (this.operation) {
            case 1: {
                return "Flip Horizontal";
            }
            case 2: {
                return "Flip Vertical";
            }
            case 3: {
                return "Flip Diagonal";
            }
            case 4: {
                return "Rotate 90";
            }
            case 5: {
                return "Rotate -90";
            }
            case 6: {
                return "Rotate 180";
            }
        }
        return "Flip";
    }
}

