/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.ConvolveFilter;
import com.alkacon.simapi.filter.Kernel;

public class GaussianFilter
extends ConvolveFilter {
    static final long serialVersionUID = 5377089073023183684L;
    protected int radius;
    private Kernel[] kernels;

    public GaussianFilter() {
        this(2);
    }

    public GaussianFilter(int radius) {
        this.setRadius(radius);
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.kernels = GaussianFilter.separatedKernels(radius);
    }

    public int getRadius() {
        return this.radius;
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int[] outPixels = new int[width * height];
        GaussianFilter.convolveH(this.kernels[0], this.inPixels, outPixels, width, height, this.alpha);
        GaussianFilter.convolveV(this.kernels[1], outPixels, this.inPixels, width, height, this.alpha);
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, this.inPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public static Kernel makeKernel(int radius) {
        int rows;
        int cols = rows = radius * 2 + 1;
        float[] matrix = new float[rows * cols];
        float sigma = (float)radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)Math.PI * 2 * sigma;
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        int row = -radius;
        while (row <= radius) {
            int col = -radius;
            while (col <= radius) {
                float distance = row * row + col * col;
                matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sigmaPi2;
                total += matrix[index];
                ++index;
                ++col;
            }
            ++row;
        }
        int i = 0;
        while (i < rows * cols) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        Kernel kernel = new Kernel(rows, cols, matrix);
        return kernel;
    }

    public static Kernel[] separatedKernels(int radius) {
        int rows = radius * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = (float)radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)Math.PI * 2 * sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        int row = -radius;
        while (row <= radius) {
            float distance = row * row;
            matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            total += matrix[index];
            ++index;
            ++row;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        return new Kernel[]{new Kernel(1, rows, matrix), new Kernel(rows, 1, matrix)};
    }

    public String toString() {
        return "Blur/Gaussian Blur...";
    }
}

