/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.BinaryFilter;

public class LifeFilter
extends BinaryFilter {
    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int index = 0;
        int[] outPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                boolean r = false;
                boolean g = false;
                boolean b = false;
                int pixel = this.inPixels[y * width + x];
                int a = pixel & 0xFF000000;
                int neighbours = 0;
                int row = -1;
                while (row <= 1) {
                    int iy = y + row;
                    if (iy >= 0 && iy < height) {
                        int ioffset = iy * width;
                        int col = -1;
                        while (col <= 1) {
                            int rgb;
                            int ix = x + col;
                            if ((row != 0 || col != 0) && ix >= 0 && ix < width && this.blackFunction.isBlack(rgb = this.inPixels[ioffset + ix])) {
                                ++neighbours;
                            }
                            ++col;
                        }
                    }
                    ++row;
                }
                if (this.blackFunction.isBlack(pixel)) {
                    outPixels[index++] = neighbours == 2 || neighbours == 3 ? pixel : -1;
                } else {
                    outPixels[index++] = neighbours == 3 ? -16777216 : pixel;
                }
                ++x;
            }
            ++y;
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public String toString() {
        return "Binary/Life";
    }
}

