/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.Colormap;
import com.alkacon.simapi.filter.Gradient;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;

public class LookupFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 4823747720743333615L;
    private Colormap colormap = new Gradient();

    public LookupFilter() {
        this.canFilterIndexColorModel = true;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public int filterRGB(int x, int y, int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        rgb = (r + g + b) / 3;
        return this.colormap.getColor((float)rgb / 255.0f);
    }

    public String toString() {
        return "Colors/Lookup...";
    }
}

