/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.PixelUtils;
import com.alkacon.simapi.filter.WholeImageFilter;

public class MaximumFilter
extends WholeImageFilter {
    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int index = 0;
        int[] outPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int pixel = -16777216;
                int dy = -1;
                while (dy <= 1) {
                    int iy = y + dy;
                    if (iy >= 0 && iy < height) {
                        int ioffset = iy * width;
                        int dx = -1;
                        while (dx <= 1) {
                            int ix = x + dx;
                            if (ix >= 0 && ix < width) {
                                pixel = PixelUtils.combinePixels(pixel, this.inPixels[ioffset + ix], 3);
                            }
                            ++dx;
                        }
                    }
                    ++dy;
                }
                outPixels[index++] = pixel;
                ++x;
            }
            ++y;
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public String toString() {
        return "Blur/Maximum";
    }
}

