/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.WholeImageFilter;

public class OilFilter
extends WholeImageFilter {
    static final long serialVersionUID = 1722613531684653826L;
    public int range = 3;

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int index = 0;
        int[] rHistogram = new int[256];
        int[] gHistogram = new int[256];
        int[] bHistogram = new int[256];
        int[] outPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int i = 0;
                while (i < 256) {
                    bHistogram[i] = 0;
                    gHistogram[i] = 0;
                    rHistogram[i] = 0;
                    ++i;
                }
                int row = -this.range;
                while (row <= this.range) {
                    int iy = y + row;
                    if (iy >= 0 && iy < height) {
                        int ioffset = iy * width;
                        int col = -this.range;
                        while (col <= this.range) {
                            int ix = x + col;
                            if (ix >= 0 && ix < width) {
                                int rgb = this.inPixels[ioffset + ix];
                                int n = rgb >> 16 & 0xFF;
                                rHistogram[n] = rHistogram[n] + 1;
                                int n2 = rgb >> 8 & 0xFF;
                                gHistogram[n2] = gHistogram[n2] + 1;
                                int n3 = rgb & 0xFF;
                                bHistogram[n3] = bHistogram[n3] + 1;
                            }
                            ++col;
                        }
                    }
                    ++row;
                }
                int r = 0;
                int g = 0;
                int b = 0;
                int i2 = 1;
                while (i2 < 256) {
                    if (rHistogram[i2] > rHistogram[r]) {
                        r = i2;
                    }
                    if (gHistogram[i2] > gHistogram[g]) {
                        g = i2;
                    }
                    if (bHistogram[i2] > bHistogram[b]) {
                        b = i2;
                    }
                    ++i2;
                }
                outPixels[index++] = 0xFF000000 | r << 16 | g << 8 | b;
                ++x;
            }
            ++y;
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public String toString() {
        return "Stylize/Oil...";
    }
}

