/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.BinaryFilter;

public class OutlineFilter
extends BinaryFilter {
    public OutlineFilter() {
        this.newColor = -1;
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int index = 0;
        int[] outPixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int pixel = this.inPixels[y * width + x];
                if (this.blackFunction.isBlack(pixel)) {
                    int neighbours = 0;
                    int dy = -1;
                    while (dy <= 1) {
                        int iy = y + dy;
                        if (iy >= 0 && iy < height) {
                            int ioffset = iy * width;
                            int dx = -1;
                            while (dx <= 1) {
                                int ix = x + dx;
                                if ((dy != 0 || dx != 0) && ix >= 0 && ix < width) {
                                    int rgb = this.inPixels[ioffset + ix];
                                    if (this.blackFunction.isBlack(rgb)) {
                                        ++neighbours;
                                    }
                                } else {
                                    ++neighbours;
                                }
                                ++dx;
                            }
                        }
                        ++dy;
                    }
                    if (neighbours == 9) {
                        pixel = this.newColor;
                    }
                }
                outPixels[index++] = pixel;
                ++x;
            }
            ++y;
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public String toString() {
        return "Binary/Outline...";
    }
}

