/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.GaussianFilter;
import com.alkacon.simapi.filter.Kernel;
import com.alkacon.simapi.filter.PixelUtils;
import com.alkacon.simapi.filter.WholeImageFilter;
import java.awt.Rectangle;

public class ShadowFilter
extends WholeImageFilter {
    static final long serialVersionUID = 6310370419462785691L;
    private int radius = 5;
    private int xOffset = 5;
    private int yOffset = 5;
    private int opacity = 255;
    private int shadowColor = -16777216;
    private int backgroundColor = 0;

    public ShadowFilter() {
    }

    public ShadowFilter(int radius, int xOffset, int yOffset, int opacity) {
        this.radius = radius;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.opacity = opacity;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setShadowColor(int shadowColor) {
        this.shadowColor = shadowColor;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    protected void transformSpace(Rectangle r) {
        r.width += Math.abs(this.xOffset) + 2 * this.radius;
        r.height += Math.abs(this.yOffset) + 2 * this.radius;
    }

    public void imageComplete(int status) {
        try {
            if (status == 1 || status == 4) {
                this.consumer.imageComplete(status);
                return;
            }
            int width = this.originalSpace.width;
            int height = this.originalSpace.height;
            int outWidth = this.transformedSpace.width;
            int outHeight = this.transformedSpace.height;
            int[] outPixels = new int[outWidth * outHeight];
            int iIn = 0;
            int iOut = 0;
            int shadow = this.opacity << 24 & 0xFF000000;
            shadow |= this.shadowColor & 0xFFFFFF;
            int radius2 = this.radius / 2;
            int topShadow = Math.max(this.yOffset, radius2) + radius2;
            int leftShadow = Math.max(this.xOffset, radius2) + radius2;
            iIn = 0;
            int y = 0;
            while (y < height) {
                iOut = (topShadow + y) * outWidth + leftShadow;
                int x = 0;
                while (x < width) {
                    int v = this.inPixels[iIn++] >> 24 & 0xFF;
                    outPixels[iOut++] = v != 0 ? shadow : shadow & 0xFFFFFF;
                    ++x;
                }
                ++y;
            }
            if (this.radius > 0) {
                float f;
                Kernel[] kernels = GaussianFilter.separatedKernels(this.radius);
                int rows = kernels[1].rows;
                int cols = kernels[0].cols;
                int rows2 = rows / 2;
                int cols2 = cols / 2;
                byte[] shadowPixels = new byte[outWidth * outHeight];
                float[] matrix = kernels[1].matrix;
                int index = 0;
                int y2 = 0;
                while (y2 < outHeight) {
                    int ioffset = y2 * outWidth;
                    int x = 0;
                    while (x < outWidth) {
                        float a = 0.0f;
                        int col = -cols2;
                        while (col <= cols2) {
                            int ix = x + col;
                            if (ix < 0 || ix >= outWidth) {
                                ix = x;
                            }
                            int rgb = outPixels[ioffset + ix];
                            f = matrix[cols2 + col];
                            if (f != 0.0f) {
                                a += f * (float)(rgb >> 24 & 0xFF);
                            }
                            ++col;
                        }
                        if (a > 255.0f) {
                            a = 255.0f;
                        }
                        shadowPixels[index] = (byte)a;
                        ++index;
                        ++x;
                    }
                    ++y2;
                }
                matrix = kernels[1].matrix;
                index = 0;
                y2 = 0;
                while (y2 < outHeight) {
                    int x = 0;
                    while (x < outWidth) {
                        float a = 0.0f;
                        int row = -rows2;
                        while (row <= rows2) {
                            int iy = y2 + row;
                            int ioffset = iy >= 0 && iy < outHeight ? iy * outWidth : y2 * outWidth;
                            int s = shadowPixels[ioffset + x] & 0xFF;
                            f = matrix[row + rows2];
                            if (f != 0.0f) {
                                a += f * (float)s;
                            }
                            ++row;
                        }
                        if (a > 255.0f) {
                            a = 255.0f;
                        }
                        outPixels[index] = this.backgroundColor != 0 ? PixelUtils.combinePixels(this.shadowColor, this.backgroundColor, 1, (int)a) : (int)a << 24 | this.shadowColor & 0xFFFFFF;
                        ++index;
                        ++x;
                    }
                    ++y2;
                }
            }
            iIn = 0;
            y = 0;
            while (y < height) {
                iOut = (topShadow + y - this.yOffset) * outWidth + leftShadow - this.xOffset;
                int x = 0;
                while (x < width) {
                    outPixels[iOut] = PixelUtils.combinePixels(this.inPixels[iIn], outPixels[iOut], 1);
                    ++iIn;
                    ++iOut;
                    ++x;
                }
                ++y;
            }
            this.consumer.setPixels(0, 0, outWidth, outHeight, this.defaultRGBModel, outPixels, 0, outWidth);
            this.consumer.imageComplete(status);
            this.inPixels = null;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Stylize/Drop Shadow...";
    }
}

