/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.Colormap;
import com.alkacon.simapi.filter.ImageMath;
import com.alkacon.simapi.filter.LinearColormap;
import com.alkacon.simapi.filter.PixelUtils;
import com.alkacon.simapi.filter.WholeImageFilter;

public class ShapeFilter
extends WholeImageFilter {
    public static final int LINEAR = 0;
    public static final int CIRCLE_UP = 1;
    public static final int CIRCLE_DOWN = 2;
    public static final int SMOOTH = 3;
    private float factor = 1.0f;
    protected Colormap colormap = new LinearColormap();
    private boolean useAlpha = true;
    private boolean invert = false;
    private boolean merge = false;
    private int type;
    private static final int one = 41;
    private static final int sqrt2 = (int)(41.0 * Math.sqrt(2.0));
    private static final int sqrt5 = (int)(41.0 * Math.sqrt(5.0));

    public void setFactor(float factor) {
        this.factor = factor;
    }

    public float getFactor() {
        return this.factor;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setUseAlpha(boolean useAlpha) {
        this.useAlpha = useAlpha;
    }

    public boolean getUseAlpha() {
        return this.useAlpha;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean getInvert() {
        return this.invert;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public boolean getMerge() {
        return this.merge;
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int[] map = new int[width * height];
        this.makeMap(this.inPixels, map, width, height);
        int max = this.distanceMap(map, width, height);
        this.applyMap(map, this.inPixels, width, height, max);
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, this.inPixels, 0, width);
        this.consumer.imageComplete(status);
    }

    public int distanceMap(int[] map, int width, int height) {
        int v;
        int offset;
        int x;
        int xmax = width - 3;
        int ymax = height - 3;
        int max = 0;
        int y = 0;
        while (y < height) {
            x = 0;
            while (x < width) {
                offset = x + y * width;
                if (map[offset] > 0 && (v = x < 2 || x > xmax || y < 2 || y > ymax ? this.setEdgeValue(x, y, map, width, offset, xmax, ymax) : this.setValue(map, width, offset)) > max) {
                    max = v;
                }
                ++x;
            }
            ++y;
        }
        y = height - 1;
        while (y >= 0) {
            x = width - 1;
            while (x >= 0) {
                offset = x + y * width;
                if (map[offset] > 0 && (v = x < 2 || x > xmax || y < 2 || y > ymax ? this.setEdgeValue(x, y, map, width, offset, xmax, ymax) : this.setValue(map, width, offset)) > max) {
                    max = v;
                }
                --x;
            }
            --y;
        }
        return max;
    }

    private void makeMap(int[] pixels, int[] map, int width, int height) {
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int offset = x + y * width;
                int b = this.useAlpha ? pixels[offset] >> 24 & 0xFF : PixelUtils.brightness(pixels[offset]);
                map[offset] = b * 41;
                ++x;
            }
            ++y;
        }
    }

    private void applyMap(int[] map, int[] pixels, int width, int height, int max) {
        if (max == 0) {
            max = 1;
        }
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int offset = x + y * width;
                int m = map[offset];
                float v = 0.0f;
                int sa = 0;
                int sr = 0;
                int sg = 0;
                int sb = 0;
                if (m == 0) {
                    sb = 0;
                    sg = 0;
                    sr = 0;
                    sa = 0;
                } else {
                    v = ImageMath.clamp(this.factor * (float)m / (float)max, 0.0f, 1.0f);
                    switch (this.type) {
                        case 1: {
                            v = ImageMath.circleUp(v);
                            break;
                        }
                        case 2: {
                            v = ImageMath.circleDown(v);
                            break;
                        }
                        case 3: {
                            v = ImageMath.smoothStep(0.0f, 1.0f, v);
                        }
                    }
                    if (this.colormap == null) {
                        sg = sb = (int)(v * 255.0f);
                        sr = sb;
                    } else {
                        int c = this.colormap.getColor(v);
                        sr = c >> 16 & 0xFF;
                        sg = c >> 8 & 0xFF;
                        sb = c & 0xFF;
                    }
                    int n = sa = this.useAlpha ? pixels[offset] >> 24 & 0xFF : PixelUtils.brightness(pixels[offset]);
                    if (this.invert) {
                        sr = 255 - sr;
                        sg = 255 - sg;
                        sb = 255 - sb;
                    }
                }
                if (this.merge) {
                    int transp = 255;
                    int col = pixels[offset];
                    int a = (col & 0xFF000000) >> 24;
                    int r = (col & 0xFF0000) >> 16;
                    int g = (col & 0xFF00) >> 8;
                    int b = col & 0xFF;
                    r = sr * r / transp;
                    g = sg * g / transp;
                    b = sb * b / transp;
                    if (r < 0) {
                        r = 0;
                    }
                    if (r > 255) {
                        r = 255;
                    }
                    if (g < 0) {
                        g = 0;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                    if (b < 0) {
                        b = 0;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    pixels[offset] = a << 24 | r << 16 | g << 8 | b;
                } else {
                    pixels[offset] = sa << 24 | sr << 16 | sg << 8 | sb;
                }
                ++x;
            }
            ++y;
        }
    }

    private int setEdgeValue(int x, int y, int[] map, int width, int offset, int xmax, int ymax) {
        int r1 = offset - width - width - 2;
        int r2 = r1 + width;
        int r3 = r2 + width;
        int r4 = r3 + width;
        int r5 = r4 + width;
        if (y == 0 || x == 0 || y == ymax + 2 || x == xmax + 2) {
            map[offset] = 41;
            return 41;
        }
        int v = map[r3 + 1] + 41;
        v = map[r2 + 2] + 41;
        int min = v;
        if (v < min) {
            min = v;
        }
        if ((v = map[r3 + 3] + 41) < min) {
            min = v;
        }
        if ((v = map[r4 + 2] + 41) < min) {
            min = v;
        }
        if ((v = map[r2 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = map[r2 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = map[r4 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = map[r4 + 3] + sqrt2) < min) {
            min = v;
        }
        if (y == 1 || x == 1 || y == ymax + 1 || x == xmax + 1) {
            map[offset] = min;
            return map[offset];
        }
        v = map[r1 + 1] + sqrt5;
        if (v < min) {
            min = v;
        }
        if ((v = map[r1 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r2 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r4 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r5 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r5 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r4] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r2] + sqrt5) < min) {
            min = v;
        }
        map[offset] = min;
        return map[offset];
    }

    private int setValue(int[] map, int width, int offset) {
        int r1 = offset - width - width - 2;
        int r2 = r1 + width;
        int r3 = r2 + width;
        int r4 = r3 + width;
        int r5 = r4 + width;
        int v = map[r3 + 1] + 41;
        v = map[r2 + 2] + 41;
        int min = v;
        if (v < min) {
            min = v;
        }
        if ((v = map[r3 + 3] + 41) < min) {
            min = v;
        }
        if ((v = map[r4 + 2] + 41) < min) {
            min = v;
        }
        if ((v = map[r2 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = map[r2 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = map[r4 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = map[r4 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = map[r1 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r1 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r2 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r4 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r5 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r5 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r4] + sqrt5) < min) {
            min = v;
        }
        if ((v = map[r2] + sqrt5) < min) {
            min = v;
        }
        map[offset] = min;
        return map[offset];
    }

    public float gddistanceMap(int[] pixels, float[] map, int width, int height) {
        float max_iterations = 0.0f;
        int length = width + 1;
        float[] distp_prev = new float[length];
        int i = 0;
        while (i < length) {
            distp_prev[i] = 0.0f;
            ++i;
        }
        float[] distp_cur = new float[length];
        i = 0;
        while (i < length) {
            distp_cur[i] = 0.0f;
            ++i;
        }
        i = 0;
        while (i < height) {
            int m = 0;
            while (m < length) {
                distp_cur[m] = 0.0f;
                ++m;
            }
            int j = 0;
            while (j < width) {
                float min_prev = Math.min(distp_cur[j], distp_prev[j + 1]);
                int min_left = Math.min(width - j - 1, height - i - 1);
                int minimum = (int)Math.min((float)min_left, min_prev);
                int fraction = 255;
                int src = 0;
                int k = 0;
                while (k <= minimum) {
                    int x = j;
                    int y = i + k;
                    int end = y - k;
                    block6: while (y >= end) {
                        int offset = y * width + x;
                        int boundary = Math.min(width, height);
                        boundary = Math.min(boundary, y - end) + 1;
                        int inc = 1 - width;
                        while (boundary-- != 0) {
                            int n = src = this.useAlpha ? pixels[offset] >> 24 & 0xFF : PixelUtils.brightness(pixels[offset]);
                            if (src == 0) {
                                minimum = k;
                                y = -1;
                                continue block6;
                            }
                            if (src < fraction) {
                                fraction = src;
                            }
                            ++x;
                            --y;
                            offset += inc;
                        }
                    }
                    ++k;
                }
                if (src != 0) {
                    if (min_left != minimum) {
                        int prev_frac = (int)(255.0f * (min_prev - (float)minimum));
                        if (prev_frac == 255) {
                            prev_frac = 0;
                        }
                        fraction = Math.min(fraction, prev_frac);
                    }
                    ++minimum;
                }
                float f = distp_cur[j + 1] = (float)minimum + (float)fraction / 256.0f;
                float float_tmp = f;
                if (float_tmp > max_iterations) {
                    max_iterations = float_tmp;
                }
                ++j;
            }
            int index = i * width;
            int m2 = 1;
            while (m2 <= width) {
                map[index++] = distp_cur[m2];
                ++m2;
            }
            float[] tmp = distp_prev;
            distp_prev = distp_cur;
            distp_cur = tmp;
            ++i;
        }
        return max_iterations;
    }

    public float ddistanceMap(int[] pixels, float[] map, int width, int height) {
        float max = 0.0f;
        int y = 0;
        while (y < height) {
            float d = 0.0f;
            int offset = y * width;
            int x = 0;
            while (x < width) {
                int v;
                int n = v = this.useAlpha ? pixels[offset] >> 24 & 0xFF : PixelUtils.brightness(pixels[offset]);
                if (v != 0) {
                    map[offset] = Math.min(d + 255.0f, (float)(v * 255));
                    d += 255.0f;
                } else {
                    d = 0.0f;
                }
                max = Math.max(max, map[offset]);
                ++offset;
                ++x;
            }
            ++y;
        }
        return max;
    }

    private void applyMap(float[] map, int[] pixels, int width, int height, float max) {
        if (max == 0.0f) {
            max = 1.0f;
        }
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int offset = x + y * width;
                int m = (int)map[offset];
                float v = 0.0f;
                int sa = 0;
                int sr = 0;
                int sg = 0;
                int sb = 0;
                if (m == 0) {
                    sb = 0;
                    sg = 0;
                    sr = 0;
                    sa = 0;
                } else {
                    v = ImageMath.clamp(this.factor * (float)m / max, 0.0f, 1.0f);
                    switch (this.type) {
                        case 1: {
                            v = ImageMath.circleUp(v);
                            break;
                        }
                        case 2: {
                            v = ImageMath.circleDown(v);
                            break;
                        }
                        case 3: {
                            v = ImageMath.smoothStep(0.0f, 1.0f, v);
                        }
                    }
                    if (this.colormap == null) {
                        sg = sb = (int)(v * 255.0f);
                        sr = sb;
                    } else {
                        int c = this.colormap.getColor(v);
                        sr = c >> 16 & 0xFF;
                        sg = c >> 8 & 0xFF;
                        sb = c & 0xFF;
                    }
                    int n = sa = this.useAlpha ? pixels[offset] >> 24 & 0xFF : PixelUtils.brightness(pixels[offset]);
                    if (this.invert) {
                        sr = 255 - sr;
                        sg = 255 - sg;
                        sb = 255 - sb;
                    }
                }
                if (this.merge) {
                    int transp = 255;
                    int col = pixels[offset];
                    int a = (col & 0xFF000000) >> 24;
                    int r = (col & 0xFF0000) >> 16;
                    int g = (col & 0xFF00) >> 8;
                    int b = col & 0xFF;
                    r = sr * r / transp;
                    g = sg * g / transp;
                    b = sb * b / transp;
                    if (r < 0) {
                        r = 0;
                    }
                    if (r > 255) {
                        r = 255;
                    }
                    if (g < 0) {
                        g = 0;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                    if (b < 0) {
                        b = 0;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    pixels[offset] = a << 24 | r << 16 | g << 8 | b;
                } else {
                    pixels[offset] = sa << 24 | sr << 16 | sg << 8 | sb;
                }
                ++x;
            }
            ++y;
        }
    }

    public String toString() {
        return "Stylize/Shapeburst...";
    }
}

