/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.ImageMath;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.io.Serializable;

public class TileImageFilter
extends ImageFilter
implements Serializable {
    static final long serialVersionUID = 4926390225069192478L;
    public static final int FLIP_NONE = 0;
    public static final int FLIP_H = 1;
    public static final int FLIP_V = 2;
    public static final int FLIP_HV = 3;
    public static final int FLIP_180 = 4;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private int edge = 0;
    private int cols;
    private int rows;
    private int[][] symmetryMatrix = null;
    private int symmetryRows = 2;
    private int symmetryCols = 2;

    public TileImageFilter() {
        this(32, 32);
    }

    public TileImageFilter(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setDimensions(int width, int height) {
        this.consumer.setDimensions(this.width, this.height);
        this.tileWidth = width - this.edge;
        this.tileHeight = height - this.edge;
        this.cols = (this.width + this.tileWidth - 1) / this.tileWidth;
        this.rows = (this.height + this.tileHeight - 1) / this.tileHeight;
    }

    public void setHints(int hints) {
        hints &= 0xFFFFFFFD;
        hints &= 0xFFFFFFFB;
        this.consumer.setHints(hints |= 1);
    }

    public void setPixels(int sx, int sy, int w, int h, ColorModel model, byte[] pixels, int offset, int scan) {
        int y = 0;
        while (y < this.rows) {
            int clippedHeight = Math.min(h, this.height - sy);
            if (clippedHeight > 0) {
                int tx = sx;
                int x = 0;
                while (x < this.cols) {
                    int clippedWidth = Math.min(w, this.width - sx);
                    if (clippedWidth > 0) {
                        this.consumer.setPixels(tx, sy, clippedWidth, clippedHeight, model, pixels, offset, scan);
                    }
                    tx += this.tileWidth;
                    ++x;
                }
            }
            sy += this.tileHeight;
            ++y;
        }
    }

    public void setPixels(int sx, int sy, int w, int h, ColorModel model, int[] pixels, int offset, int scan) {
        if (this.edge > 0) {
            pixels = this.blendPixels(sx, sy, w, h, pixels, offset, scan);
        }
        int y = 0;
        while (y < this.rows) {
            int clippedHeight = Math.min(h, this.height - sy);
            if (clippedHeight > 0) {
                int tx = sx;
                int x = 0;
                while (x < this.cols) {
                    int clippedWidth = Math.min(w, this.width - sx);
                    if (clippedWidth > 0) {
                        if (this.symmetryMatrix != null) {
                            this.consumer.setPixels(tx, sy, clippedWidth, clippedHeight, model, this.flipPixels(sx, sy, w, h, pixels, offset, scan, this.symmetryMatrix[x % this.symmetryCols][y % this.symmetryRows]), offset, scan);
                        } else {
                            this.consumer.setPixels(tx, sy, clippedWidth, clippedHeight, model, pixels, offset, scan);
                        }
                    }
                    tx += this.tileWidth;
                    ++x;
                }
            }
            sy += this.tileHeight;
            ++y;
        }
    }

    public int[] blendPixels(int x, int y, int w, int h, int[] pixels, int off, int stride) {
        int[] newPixels = new int[w * h];
        int edge = 8;
        int i = 0;
        int row = 0;
        while (row < h) {
            int col = 0;
            while (col < w) {
                if (row < edge || col < edge) {
                    int col2;
                    int row2 = row < edge ? h - edge - 1 + row : row;
                    int n = col2 = col < edge ? w - edge - 1 + col : col;
                    if (row < edge && col < edge) {
                        float frow = (float)row / (float)edge;
                        float fcol = (float)col / (float)edge;
                        int i2 = row2 * w + col2;
                        int i3 = row * w + col2;
                        int i4 = row2 * w + col;
                        int left = ImageMath.mixColors(frow, pixels[i4], pixels[i]);
                        int right = ImageMath.mixColors(frow, pixels[i2], pixels[i3]);
                        newPixels[i] = ImageMath.mixColors(fcol, right, left);
                    } else {
                        float f = (float)Math.min(row, col) / (float)edge;
                        int i2 = row2 * w + col2;
                        newPixels[i] = ImageMath.mixColors(f, pixels[i2], pixels[i]);
                    }
                } else {
                    newPixels[i] = pixels[i];
                }
                ++i;
                ++col;
            }
            ++row;
        }
        return newPixels;
    }

    public void setSymmetryMatrix(int[][] symmetryMatrix) {
        this.symmetryMatrix = symmetryMatrix;
        this.symmetryRows = symmetryMatrix.length;
        this.symmetryCols = symmetryMatrix[0].length;
    }

    public int[][] getSymmetryMatrix() {
        return this.symmetryMatrix;
    }

    public int[] flipPixels(int x, int y, int w, int h, int[] pixels, int off, int scansize, int operation) {
        int newX = x;
        int newY = y;
        int newW = w;
        int newH = h;
        switch (operation) {
            case 1: {
                newX = this.width - (x + w);
                break;
            }
            case 2: {
                newY = this.height - (y + h);
                break;
            }
            case 3: {
                newW = h;
                newH = w;
                newX = y;
                newY = x;
                break;
            }
            case 4: {
                newX = this.width - (x + w);
                newY = this.height - (y + h);
            }
        }
        int[] newPixels = new int[newW * newH];
        int row = 0;
        while (row < h) {
            int col = 0;
            while (col < w) {
                int index = row * scansize + off + col;
                int newRow = row;
                int newCol = col;
                switch (operation) {
                    case 1: {
                        newCol = w - col - 1;
                        break;
                    }
                    case 2: {
                        newRow = h - row - 1;
                        break;
                    }
                    case 3: {
                        newRow = col;
                        newCol = row;
                        break;
                    }
                    case 4: {
                        newRow = h - row - 1;
                        newCol = w - col - 1;
                    }
                }
                int newIndex = newRow * newW + newCol;
                newPixels[newIndex] = pixels[index];
                ++col;
            }
            ++row;
        }
        return newPixels;
    }

    public String toString() {
        return "Tile";
    }
}

