/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import com.alkacon.simapi.filter.ImageMath;
import com.alkacon.simapi.filter.WholeImageFilter;

public class WaterFilter
extends WholeImageFilter {
    static final long serialVersionUID = 8789236343162990941L;
    private float wavelength = 16.0f;
    private float amplitude = 10.0f;
    private float phase = 0.0f;
    private boolean antialias = true;

    public void setWavelength(float wavelength) {
        this.wavelength = wavelength;
    }

    public float getWavelength() {
        return this.wavelength;
    }

    public void setAmplitude(float amplitude) {
        this.amplitude = amplitude;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public void setPhase(float phase) {
        this.phase = phase;
    }

    public float getPhase() {
        return this.phase;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public boolean getAntialias() {
        return this.antialias;
    }

    private boolean inside(int v, int a, int b) {
        return a <= v && v <= b;
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int width = this.originalSpace.width;
        int height = this.originalSpace.height;
        int index = 0;
        int centreX = width / 2;
        int centreY = height / 2;
        int[] outPixels = new int[width * height];
        int[] a = new int[4];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int rgb;
                int ny;
                int nx;
                float dx = x - centreX;
                float dy = y - centreY;
                float distance = (float)Math.sqrt(dx * dx + dy * dy);
                float amount = this.amplitude * (float)Math.sin(distance / this.wavelength * ((float)Math.PI * 2) + this.phase);
                float tx = (float)centreX + dx + amount;
                float ty = (float)centreY + dy + amount;
                tx = ImageMath.clamp(tx, 0.0f, (float)(width - 1));
                ty = ImageMath.clamp(ty, 0.0f, (float)(height - 1));
                if (this.antialias) {
                    nx = (int)tx;
                    ny = (int)ty;
                    boolean xl = this.inside(nx, 0, width - 1);
                    boolean yt = this.inside(ny, 0, height - 1);
                    boolean xr = this.inside(nx, 0, width - 2);
                    boolean yb = this.inside(ny, 0, height - 2);
                    int i = ny * width + nx;
                    a[0] = xl && yt ? this.inPixels[i] : -16777216;
                    a[1] = xr && yt ? this.inPixels[i + 1] : -16777216;
                    a[2] = xl && yb ? this.inPixels[i + width] : -16777216;
                    a[3] = xr && yb ? this.inPixels[i + width + 1] : -16777216;
                    tx = ImageMath.mod(tx, 1.0f);
                    ty = ImageMath.mod(ty, 1.0f);
                    rgb = ImageMath.bilinearInterpolate(tx, ty, a);
                } else {
                    nx = ImageMath.clamp((int)(tx + 0.5f), 0, width - 1);
                    ny = ImageMath.clamp((int)(ty + 0.5f), 0, height - 1);
                    rgb = this.inPixels[ny * width + nx];
                }
                outPixels[index++] = rgb;
                ++x;
            }
            ++y;
        }
        this.consumer.setPixels(0, 0, width, height, this.defaultRGBModel, outPixels, 0, width);
        this.consumer.imageComplete(status);
        this.inPixels = null;
    }

    public String toString() {
        return "Distort/Water Ripples...";
    }
}

