/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.filter;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import java.io.Serializable;

public abstract class WholeImageFilter
extends ImageFilter
implements Serializable {
    protected Rectangle transformedSpace;
    protected Rectangle originalSpace;
    protected ColorModel defaultRGBModel = ColorModel.getRGBdefault();
    protected int[] inPixels;
    protected byte[] inBytePixels;
    protected boolean canFilterIndexColorModel = false;

    protected void transformSpace(Rectangle rect) {
    }

    public void setDimensions(int width, int height) {
        this.originalSpace = new Rectangle(0, 0, width, height);
        this.transformedSpace = new Rectangle(0, 0, width, height);
        this.transformSpace(this.transformedSpace);
        this.consumer.setDimensions(this.transformedSpace.width, this.transformedSpace.height);
    }

    public Rectangle getTransformedSpace(Rectangle base) {
        Rectangle space = new Rectangle(base.width, base.height);
        this.transformSpace(space);
        space = new Rectangle(base.width + (base.width - space.width), base.height + (base.height - space.height));
        return space;
    }

    public void setColorModel(ColorModel model) {
        if (this.canFilterIndexColorModel && model instanceof IndexColorModel) {
            this.consumer.setColorModel(model);
        } else {
            this.consumer.setColorModel(this.defaultRGBModel);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int index = y * this.originalSpace.width + x;
        int srcindex = off;
        int srcinc = scansize - w;
        int indexinc = this.originalSpace.width - w;
        if (this.canFilterIndexColorModel) {
            if (this.inBytePixels == null) {
                this.inBytePixels = new byte[this.originalSpace.width * this.originalSpace.height];
            }
            int dy = 0;
            while (dy < h) {
                int dx = 0;
                while (dx < w) {
                    this.inBytePixels[index++] = pixels[srcindex++];
                    ++dx;
                }
                srcindex += srcinc;
                index += indexinc;
                ++dy;
            }
        } else {
            if (this.inPixels == null) {
                this.inPixels = new int[this.originalSpace.width * this.originalSpace.height];
            }
            int dy = 0;
            while (dy < h) {
                int dx = 0;
                while (dx < w) {
                    this.inPixels[index++] = model.getRGB(pixels[srcindex++] & 0xFF);
                    ++dx;
                }
                srcindex += srcinc;
                index += indexinc;
                ++dy;
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int index = y * this.originalSpace.width + x;
        int srcindex = off;
        int srcinc = scansize - w;
        int indexinc = this.originalSpace.width - w;
        if (this.inPixels == null) {
            this.inPixels = new int[this.originalSpace.width * this.originalSpace.height];
        }
        int dy = 0;
        while (dy < h) {
            int dx = 0;
            while (dx < w) {
                this.inPixels[index++] = model.getRGB(pixels[srcindex++]);
                ++dx;
            }
            srcindex += srcinc;
            index += indexinc;
            ++dy;
        }
    }
}

