/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.util;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.DataOutput;
import java.io.IOException;

public class GifAcmeEncoder {
    private static final int BITS = 12;
    private static final int EOF = -1;
    private static final int HSIZE = 5003;
    private int a_count;
    private byte[] accum = new byte[256];
    private boolean clear_flg = false;
    private int ClearCode;
    private int[] codetab = new int[5003];
    private int cur_accum = 0;
    private int cur_bits = 0;
    private int EOFCode;
    private int free_ent = 0;
    private int g_init_bits;
    private int hsize = 5003;
    private int[] htab = new int[5003];
    private boolean interlace = false;
    private int[] masks;
    private int maxbits;
    private int maxcode;
    private int maxmaxcode;
    private int n_bits;
    private int numPixels;
    private int pixelIndex;
    private int[] pixels;
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private int transparentPixel;
    private int width;
    private int height;

    public GifAcmeEncoder(BufferedImage img) {
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        this.masks = nArray;
        this.maxbits = 12;
        this.maxmaxcode = 4096;
        this.transparentPixel = -1;
        this.width = img.getWidth(null);
        this.height = img.getHeight(null);
        if (!(img.getColorModel() instanceof IndexColorModel)) {
            throw new IllegalArgumentException("GIF Encoder: Image must be 8-bit");
        }
        this.pixels = img.getRaster().getPixels(0, 0, this.width, this.height, (int[])null);
        IndexColorModel icm = (IndexColorModel)img.getColorModel();
        this.transparentPixel = icm.getTransparentPixel();
        int mapSize = icm.getMapSize();
        this.r = new byte[mapSize];
        this.g = new byte[mapSize];
        this.b = new byte[mapSize];
        icm.getReds(this.r);
        icm.getGreens(this.g);
        icm.getBlues(this.b);
        this.interlace = false;
        this.pixelIndex = 0;
        this.numPixels = this.width * this.height;
    }

    private static void writeString(DataOutput out, String str) throws IOException {
        out.write(str.getBytes());
    }

    public void write(DataOutput out) throws IOException {
        int numColors = this.r.length;
        int BitsPerPixel = numColors <= 2 ? 1 : (numColors <= 4 ? 2 : (numColors <= 16 ? 4 : 8));
        int ColorMapSize = 1 << BitsPerPixel;
        byte[] reds = new byte[ColorMapSize];
        byte[] grns = new byte[ColorMapSize];
        byte[] blus = new byte[ColorMapSize];
        int i = 0;
        while (i < numColors) {
            reds[i] = this.r[i];
            grns[i] = this.g[i];
            blus[i] = this.b[i];
            ++i;
        }
        this.GIFEncode(out, this.width, this.height, this.interlace, (byte)0, this.transparentPixel, BitsPerPixel, reds, grns, blus);
    }

    private void char_init() {
        this.a_count = 0;
    }

    private void char_out(byte c, DataOutput outs) throws IOException {
        this.accum[this.a_count++] = c;
        if (this.a_count >= 254) {
            this.flush_char(outs);
        }
    }

    private void cl_block(DataOutput outs) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outs);
    }

    private void cl_hash(int hxsize) {
        int i = 0;
        while (i < hxsize) {
            this.htab[i] = -1;
            ++i;
        }
    }

    private void compress(int init_bits, DataOutput outs) throws IOException {
        int c;
        this.g_init_bits = init_bits;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << init_bits - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int ent = this.GIFNextPixel();
        int hshift = 0;
        int fcode = this.hsize;
        while (fcode < 65536) {
            ++hshift;
            fcode *= 2;
        }
        hshift = 8 - hshift;
        int hsize_reg = this.hsize;
        this.cl_hash(hsize_reg);
        this.output(this.ClearCode, outs);
        block1: while ((c = this.GIFNextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsize_reg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsize_reg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent, outs);
            ent = c;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[i] = fcode;
                continue;
            }
            this.cl_block(outs);
        }
        this.output(ent, outs);
        this.output(this.EOFCode, outs);
    }

    private void flush_char(DataOutput outs) throws IOException {
        if (this.a_count > 0) {
            outs.write(this.a_count);
            outs.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    private void GIFEncode(DataOutput outs, int Width, int Height, boolean Interlace, byte Background, int Transparent, int BitsPerPixel, byte[] Red, byte[] Green, byte[] Blue) throws IOException {
        int ColorMapSize = 1 << BitsPerPixel;
        int TopOfs = 0;
        int LeftOfs = 0;
        int InitCodeSize = BitsPerPixel <= 1 ? 2 : BitsPerPixel;
        GifAcmeEncoder.writeString(outs, "GIF89a");
        this.Putword(Width, outs);
        this.Putword(Height, outs);
        byte B = -128;
        B = (byte)(B | 0x70);
        B = (byte)(B | (byte)(BitsPerPixel - 1));
        this.Putbyte(B, outs);
        this.Putbyte(Background, outs);
        this.Putbyte((byte)0, outs);
        int i = 0;
        while (i < ColorMapSize) {
            this.Putbyte(Red[i], outs);
            this.Putbyte(Green[i], outs);
            this.Putbyte(Blue[i], outs);
            ++i;
        }
        if (Transparent != -1) {
            this.Putbyte((byte)33, outs);
            this.Putbyte((byte)-7, outs);
            this.Putbyte((byte)4, outs);
            this.Putbyte((byte)1, outs);
            this.Putbyte((byte)0, outs);
            this.Putbyte((byte)0, outs);
            this.Putbyte((byte)Transparent, outs);
            this.Putbyte((byte)0, outs);
        }
        this.Putbyte((byte)44, outs);
        this.Putword(LeftOfs, outs);
        this.Putword(TopOfs, outs);
        this.Putword(Width, outs);
        this.Putword(Height, outs);
        if (Interlace) {
            this.Putbyte((byte)64, outs);
        } else {
            this.Putbyte((byte)0, outs);
        }
        this.Putbyte((byte)InitCodeSize, outs);
        this.compress(InitCodeSize + 1, outs);
        this.Putbyte((byte)0, outs);
        this.Putbyte((byte)59, outs);
    }

    private int GIFNextPixel() {
        if (this.pixelIndex == this.numPixels) {
            return -1;
        }
        return this.pixels[this.pixelIndex++];
    }

    private final int MAXCODE(int nx_bits) {
        return (1 << nx_bits) - 1;
    }

    private void output(int code, DataOutput outs) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outs);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (code == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outs);
        }
    }

    private void Putbyte(byte bo, DataOutput outs) throws IOException {
        outs.write(bo);
    }

    private void Putword(int w, DataOutput outs) throws IOException {
        this.Putbyte((byte)(w & 0xFF), outs);
        this.Putbyte((byte)(w >> 8 & 0xFF), outs);
    }
}

