/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.simapi.util;

import com.alkacon.simapi.util.GifAcmeEncoder;
import com.alkacon.simapi.util.GifImageWriterSpi;
import com.alkacon.simapi.util.Quantize;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class GifImageWriter
extends ImageWriter {
    public GifImageWriter(GifImageWriterSpi provider) {
        super(provider);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (image.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write rasters");
        }
        this.output = this.getOutput();
        if (this.output == null) {
            throw new IllegalStateException("output was not set");
        }
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        ImageOutputStream ios = (ImageOutputStream)this.output;
        RenderedImage ri = image.getRenderedImage();
        if (!(ri instanceof BufferedImage)) {
            throw new IOException("Image not of type BufferedImage");
        }
        BufferedImage bi = (BufferedImage)ri;
        BufferedImage indexed = !(bi.getColorModel() instanceof IndexColorModel) ? Quantize.process(bi, 256, true) : bi;
        GifAcmeEncoder encoder = new GifAcmeEncoder(indexed);
        encoder.write(ios);
    }
}

