/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util.ant;

import java.io.File;
import org.apache.commons.digester.Digester;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class CmsAntTaskReadXMLProperty
extends Task {
    private String m_attribute;
    private String m_element;
    private String m_property;
    private String m_value = ",";
    private String m_xmlFile;

    public void execute() throws BuildException {
        boolean isAttr = this.m_attribute != null && this.m_attribute.trim().length() > 0;
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setEntityResolver(null);
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) {
                CmsAntTaskReadXMLProperty.this.log(exception.getMessage(), exception.getLineNumber());
            }

            public void fatalError(SAXParseException exception) {
                CmsAntTaskReadXMLProperty.this.log(exception.getMessage(), exception.getLineNumber());
            }

            public void warning(SAXParseException exception) {
                CmsAntTaskReadXMLProperty.this.log(exception.getMessage(), exception.getLineNumber());
            }
        });
        digester.push((Object)this);
        if (!isAttr) {
            digester.addCallMethod(this.m_element, "setValue", 0);
        } else {
            digester.addCallMethod(this.m_element, "setValue", 1);
            digester.addCallParam(this.m_element, 0, this.m_attribute);
        }
        try {
            digester.parse(new File(this.getXmlFile()));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        this.getProject().setProperty(this.m_property, this.m_value.substring(1));
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public String getElement() {
        return this.m_element;
    }

    public String getProperty() {
        return this.m_property;
    }

    public String getValue() {
        return this.m_value;
    }

    public String getXmlFile() {
        return this.m_xmlFile;
    }

    public void setAttribute(String attribute) {
        this.m_attribute = attribute;
    }

    public void setElement(String element) {
        this.m_element = element;
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    public void setValue(String value) {
        if (this.m_value.length() > 1) {
            this.m_value = String.valueOf(this.m_value) + ",";
        }
        this.m_value = String.valueOf(this.m_value) + value;
    }

    public void setXmlFile(String xmlFile) {
        this.m_xmlFile = xmlFile;
    }
}

