/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util.ant;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.opencms.util.ant.CmsAntTaskSelectionPrompt;

public class CmsAntTaskSelectionDialog
extends JDialog
implements ActionListener {
    private static final int C_BORDER_SIZE = 10;
    private static final long serialVersionUID = -8439685952987222098L;
    protected boolean m_aborted = true;
    private String[] m_allList = null;
    private final Border m_border = BorderFactory.createEmptyBorder(10, 10, 0, 10);
    private final JPanel m_buttons = new JPanel();
    private final JButton m_cancel = new JButton("Cancel");
    private final JPanel m_content = new JPanel();
    private String[] m_defList = null;
    private JLabel m_label = null;
    private final JButton m_ok = new JButton("Ok");
    private final CmsAntTaskSelectionPrompt m_promptTask;
    private final JButton m_selAll = new JButton("All");
    private JToggleButton[] m_selections = null;
    private final JButton m_selNone = new JButton("None");
    private final JScrollPane m_view = new JScrollPane(this.m_content);

    public CmsAntTaskSelectionDialog(CmsAntTaskSelectionPrompt promptTask) {
        super((Frame)null, promptTask.getTitle(), true);
        this.m_promptTask = promptTask;
        this.m_allList = this.m_promptTask.getAllValues().split(",");
        this.m_defList = this.getDefaultList();
        this.m_label = new JLabel(this.m_promptTask.getPrompt());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                CmsAntTaskSelectionDialog.this.m_aborted = true;
                CmsAntTaskSelectionDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(this.m_ok);
        this.m_label.setBorder(this.m_border);
        if (!this.m_promptTask.isSingleSelection()) {
            JPanel p1 = new JPanel();
            p1.add(new JLabel("Select: "));
            this.m_selAll.addActionListener(this);
            p1.add(this.m_selAll);
            this.m_selNone.addActionListener(this);
            p1.add(this.m_selNone);
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)this.m_label, "North");
            p.add((Component)p1, "South");
            this.getContentPane().add((Component)p, "North");
        } else {
            this.getContentPane().add((Component)this.m_label, "North");
        }
        this.m_view.setBorder(this.m_border);
        this.m_selections = new JToggleButton[this.m_promptTask.getAllValues().split(",").length];
        int elements = this.m_selections.length;
        GridLayout layout = new GridLayout(elements / this.m_promptTask.getColumns() + 1, this.m_promptTask.getColumns());
        layout.setHgap(20);
        this.m_content.setLayout(layout);
        int i = 0;
        while (i < this.m_selections.length) {
            this.m_selections[i] = this.m_promptTask.isSingleSelection() ? new JRadioButton(this.m_allList[i].trim(), this.firstPositionOfItemInArray(this.m_defList, this.m_allList[i]) != -1) : new JCheckBox(this.m_allList[i].trim(), this.firstPositionOfItemInArray(this.m_defList, this.m_allList[i]) != -1);
            this.m_content.add(this.m_selections[i]);
            ++i;
        }
        if (this.m_promptTask.isSingleSelection()) {
            ButtonGroup group = new ButtonGroup();
            int i2 = 0;
            while (i2 < this.m_selections.length) {
                group.add(this.m_selections[i2]);
                ++i2;
            }
        }
        this.getContentPane().add((Component)this.m_view, "Center");
        this.m_buttons.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.m_ok.addActionListener(this);
        this.m_buttons.add(this.m_ok);
        this.m_cancel.addActionListener(this);
        this.m_buttons.add(this.m_cancel);
        this.getContentPane().add((Component)this.m_buttons, "South");
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        block3: {
            block4: {
                block2: {
                    if (!e.getActionCommand().equals(this.m_ok.getText()) && !e.getActionCommand().equals(this.m_cancel.getText())) break block2;
                    this.m_aborted = !e.getActionCommand().equals(this.m_ok.getText());
                    this.setVisible(false);
                    break block3;
                }
                if (!e.getActionCommand().equals(this.m_selAll.getText())) break block4;
                int i = 0;
                while (i < this.m_selections.length) {
                    this.m_selections[i].setSelected(true);
                    ++i;
                }
                break block3;
            }
            if (!e.getActionCommand().equals(this.m_selNone.getText())) break block3;
            int i = 0;
            while (i < this.m_selections.length) {
                this.m_selections[i].setSelected(false);
                ++i;
            }
        }
    }

    public String getSelection() {
        this.center();
        this.setVisible(true);
        String ret = "";
        int i = 0;
        while (i < this.m_selections.length) {
            if (this.m_selections[i].isSelected()) {
                ret = String.valueOf(ret) + this.m_selections[i].getText() + ",";
            }
            ++i;
        }
        if (this.m_aborted || ret.trim().length() < ",".length()) {
            this.dispose();
            return null;
        }
        this.dispose();
        return ret.substring(0, ret.length() - ",".length());
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int height = window.height;
        int width = window.width;
        if (window.height > screen.height) {
            window.height = screen.height;
            height = screen.height - 50;
            width += 50;
        }
        if (window.width > screen.width) {
            window.width = screen.width;
        }
        int xCoord = screen.width / 2 - window.width / 2;
        int yCoord = screen.height / 2 - window.height / 2;
        this.setLocation(xCoord, yCoord);
        this.setSize(width, height);
    }

    private int firstPositionOfItemInArray(String[] array, String item) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == null ? item == null : item != null && array[i].trim().equals(item.trim())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String[] getDefaultList() {
        if (this.m_promptTask.getDefaultValue() == null || this.m_promptTask.getDefaultValue().trim().equals("")) {
            return this.m_allList;
        }
        return this.m_promptTask.getDefaultValue().split(",");
    }
}

