/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util.ant;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opencms.util.ant.CmsAntTaskSelectionTreePrompt;
import org.opencms.util.ant.SelectionTree;

public class CmsAntTaskSelectionTreeDialog
extends JDialog
implements ActionListener {
    private static final int C_BORDER_SIZE = 10;
    private static final long serialVersionUID = -8439685952987222098L;
    protected boolean m_aborted = false;
    private List m_allModuleList;
    private final Border m_border = BorderFactory.createEmptyBorder(10, 10, 0, 10);
    private final JPanel m_buttons = new JPanel();
    private final JButton m_cancel = new JButton("Cancel");
    private final JPanel m_content = new JPanel();
    private JLabel m_label = null;
    private final JButton m_ok = new JButton("Ok");
    private final CmsAntTaskSelectionTreePrompt m_promptTask;
    private final JButton m_selAll = new JButton("All");
    private final JButton m_selNone = new JButton("None");
    private JTree m_tree;

    public CmsAntTaskSelectionTreeDialog(CmsAntTaskSelectionTreePrompt promptTask) {
        super((Frame)null, promptTask.getTitle(), true);
        this.m_promptTask = promptTask;
        this.m_label = new JLabel(this.m_promptTask.getPrompt());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                CmsAntTaskSelectionTreeDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(this.m_ok);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.m_label.setBorder(this.m_border);
        if (!this.m_promptTask.isSingleSelection()) {
            JPanel p1 = new JPanel();
            p1.add(new JLabel("Select: "));
            this.m_selAll.addActionListener(this);
            p1.add(this.m_selAll);
            this.m_selNone.addActionListener(this);
            p1.add(this.m_selNone);
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)this.m_label, "North");
            p.add((Component)p1, "South");
            contentPane.add(p);
        } else {
            this.getContentPane().add(this.m_label);
        }
        JScrollPane scrollpane = new JScrollPane(this.m_content);
        scrollpane.setBorder(this.m_border);
        scrollpane.setPreferredSize(new Dimension(300, 800));
        this.parseModuleList();
        TreeModel treeModel = this.createTree();
        this.m_tree = new SelectionTree();
        this.m_tree.setModel(treeModel);
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.expandTree(new TreePath(treeModel.getRoot()));
        this.selectDefaultNodes((DefaultMutableTreeNode)treeModel.getRoot(), "", new TreePath(treeModel.getRoot()));
        this.m_content.setLayout(new GridLayout(1, 1));
        this.m_content.add(this.m_tree);
        this.m_content.setBorder(BorderFactory.createLoweredBevelBorder());
        contentPane.add(scrollpane);
        this.m_buttons.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.m_ok.addActionListener(this);
        this.m_buttons.add(this.m_ok);
        this.m_cancel.addActionListener(this);
        this.m_buttons.add(this.m_cancel);
        this.getContentPane().add((Component)this.m_buttons, "South");
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_ok) {
            this.m_aborted = false;
            this.setVisible(false);
        } else if (source == this.m_cancel) {
            this.m_aborted = true;
            this.setVisible(false);
        } else if (source == this.m_selAll) {
            this.m_tree.setSelectionPath(new TreePath(this.m_tree.getModel().getRoot()));
        } else if (source == this.m_selNone) {
            this.m_tree.clearSelection();
        }
        this.m_tree.invalidate();
        this.m_tree.repaint();
    }

    public String getSelection() {
        this.center();
        this.setVisible(true);
        StringBuffer ret = new StringBuffer();
        TreePath[] pathArr = this.m_tree.getSelectionPaths();
        if (pathArr == null) {
            pathArr = new TreePath[]{};
        }
        int i = 0;
        while (i < pathArr.length) {
            StringBuffer pathString = new StringBuffer();
            TreePath path = pathArr[i];
            Object[] entries = path.getPath();
            int j = 1;
            while (j < entries.length) {
                pathString.append(entries[j]);
                if (j < entries.length - 1) {
                    pathString.append(".");
                }
                ++j;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.isLeaf()) {
                ret.append(pathString.toString());
                ret.append(",");
            } else {
                if (this.m_allModuleList.contains(pathString.toString())) {
                    ret.append(pathString.toString());
                    ret.append(",");
                }
                ret.append(this.getSubpaths(node, pathString.toString()));
            }
            ++i;
        }
        this.dispose();
        if (this.m_aborted || ret.toString().trim().length() < ",".length()) {
            return null;
        }
        return ret.toString();
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int height = window.height;
        int width = window.width;
        if (window.height > screen.height) {
            window.height = screen.height;
            height = screen.height - 50;
            width += 50;
        }
        if (window.width > screen.width) {
            window.width = screen.width;
        }
        int xCoord = screen.width / 2 - window.width / 2;
        int yCoord = screen.height / 2 - window.height / 2;
        this.setLocation(xCoord, yCoord);
        this.setSize(width, height);
    }

    private TreeModel createTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultTreeModel tm = new DefaultTreeModel(root);
        Iterator itModules = this.m_allModuleList.iterator();
        boolean found = false;
        while (itModules.hasNext()) {
            StringTokenizer itPath = new StringTokenizer((String)itModules.next(), ".");
            DefaultMutableTreeNode node = root;
            while (itPath.hasMoreTokens()) {
                DefaultMutableTreeNode child;
                String pathElement = itPath.nextToken();
                Enumeration<TreeNode> childEnum = node.children();
                found = false;
                while (childEnum.hasMoreElements()) {
                    child = (DefaultMutableTreeNode)childEnum.nextElement();
                    if (!pathElement.equals(child.getUserObject())) continue;
                    node = child;
                    found = true;
                    break;
                }
                if (found) continue;
                child = new DefaultMutableTreeNode();
                child.setUserObject(pathElement);
                node.add(child);
                node = child;
            }
        }
        return tm;
    }

    private void expandTree(TreePath treePath) {
        if (treePath.getPathCount() == this.m_promptTask.getExpansionLevels()) {
            this.m_tree.expandPath(treePath);
        } else {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Enumeration<TreeNode> children = treeNode.children();
            while (children.hasMoreElements()) {
                this.expandTree(treePath.pathByAddingChild(children.nextElement()));
            }
        }
    }

    private String getSubpaths(TreeNode node, String parentPath) {
        Enumeration<? extends TreeNode> children = node.children();
        String path = parentPath;
        StringBuffer ret = new StringBuffer();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            path = parentPath.length() == 0 ? child.toString() : String.valueOf(parentPath) + "." + child.toString();
            if (child.isLeaf()) {
                ret.append(path);
                ret.append(",");
                continue;
            }
            ret.append(this.getSubpaths(child, path));
        }
        return ret.toString();
    }

    private void parseModuleList() {
        this.m_allModuleList = new LinkedList();
        StringTokenizer itPaths = new StringTokenizer(this.m_promptTask.getAllValues(), ",");
        while (itPaths.hasMoreElements()) {
            String token = itPaths.nextToken().trim();
            this.m_allModuleList.add(token);
        }
    }

    private void selectDefaultNodes(DefaultMutableTreeNode node, String path, TreePath treePath) {
        String defaultString = this.m_promptTask.getDefaultValue();
        if ("root".equalsIgnoreCase(defaultString.trim())) {
            if (node == this.m_tree.getModel().getRoot()) {
                this.m_tree.setSelectionPath(treePath);
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(defaultString, ",");
            while (tokenizer.hasMoreTokens()) {
                String defaultEntry = tokenizer.nextToken();
                if (node.getLevel() == 0) {
                    System.out.println("Preselection: " + defaultEntry);
                }
                if (!defaultEntry.equals(path)) continue;
                this.m_tree.addSelectionPath(treePath);
                return;
            }
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                String subPath = path;
                if (subPath.length() != 0) {
                    subPath = String.valueOf(subPath) + ".";
                }
                DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)children.nextElement();
                subPath = String.valueOf(subPath) + subNode.toString();
                this.selectDefaultNodes(subNode, subPath, treePath.pathByAddingChild(subNode));
            }
        }
    }
}

