/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util.ant;

import javax.swing.UIManager;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.opencms.util.ant.CmsAntTaskSelectionTreeDialog;

public class CmsAntTaskSelectionTreePrompt
extends Task {
    public static final String LIST_SEPARATOR = ",";
    private String m_allValues;
    private String m_defaultValue = "";
    private int m_expansionLevels = 0;
    private String m_prompt = "Please make your choice:";
    private String m_property;
    private boolean m_singleSelection = false;
    private String m_title = "Selection Dialog";

    public static void main(String[] args) {
        CmsAntTaskSelectionTreePrompt prompt = new CmsAntTaskSelectionTreePrompt();
        prompt.setAllValues("org.opencms.test,org.opencms.test.subtest,org.opencms.code,org.opencms.blabla,com.lgt.module,com.lgt.code,com.lgt.dummy");
        prompt.setTitle("title");
        prompt.execute();
    }

    public void execute() throws BuildException {
        this.log("Prompting user for " + this.m_property);
        String value = new CmsAntTaskSelectionTreeDialog(this).getSelection();
        if (value == null) {
            value = "__ABORT__";
        } else {
            this.log("user selection: " + value);
        }
        this.getProject().setProperty(this.m_property, value);
    }

    public String getAllValues() {
        return this.m_allValues;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public int getExpansionLevels() {
        return this.m_expansionLevels - 1;
    }

    public String getPrompt() {
        return this.m_prompt;
    }

    public String getProperty() {
        return this.m_property;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void init() {
        super.init();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSingleSelection() {
        return this.m_singleSelection;
    }

    public void log(String arg0) {
        try {
            super.log(arg0);
        }
        catch (Exception ex) {
            System.err.println(arg0);
        }
    }

    public void log(String arg0, int arg1) {
        try {
            super.log(arg0, arg1);
        }
        catch (Exception ex) {
            System.err.println(arg0);
        }
    }

    public void setAllValues(String allValues) {
        this.m_allValues = allValues;
    }

    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    public void setExpansionLevels(int expansionLevels) {
        this.m_expansionLevels = expansionLevels + 1;
    }

    public void setPrompt(String prompt) {
        this.m_prompt = prompt;
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    public void setSingleSelection(boolean singleSelection) {
        this.m_singleSelection = singleSelection;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }
}

