/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util.ant;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class SelectionTree
extends JTree {
    private static final long serialVersionUID = -3627379509871776708L;

    public SelectionTree() {
        super.setCellRenderer(new CheckBoxCellRenderer());
        this.selectionModel.setSelectionMode(4);
        this.selectionModel.addTreeSelectionListener(new SubsequentSelection());
    }

    public static void main(String[] args) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode a = new DefaultMutableTreeNode("a");
        DefaultMutableTreeNode b = new DefaultMutableTreeNode("b");
        DefaultMutableTreeNode c = new DefaultMutableTreeNode("c");
        DefaultMutableTreeNode a1 = new DefaultMutableTreeNode("1");
        DefaultMutableTreeNode a2 = new DefaultMutableTreeNode("2");
        DefaultMutableTreeNode a3 = new DefaultMutableTreeNode("3");
        DefaultMutableTreeNode b1 = new DefaultMutableTreeNode("1");
        DefaultMutableTreeNode b2 = new DefaultMutableTreeNode("2");
        DefaultMutableTreeNode b3 = new DefaultMutableTreeNode("3");
        DefaultMutableTreeNode c1 = new DefaultMutableTreeNode("1");
        DefaultMutableTreeNode c2 = new DefaultMutableTreeNode("2");
        DefaultMutableTreeNode c3 = new DefaultMutableTreeNode("3");
        node.add(a);
        node.add(b);
        node.add(c);
        a.add(a1);
        a.add(a2);
        a.add(a3);
        b.add(b1);
        b.add(b2);
        b.add(b3);
        c.add(c1);
        c.add(c2);
        c.add(c3);
        JFrame frame = new JFrame("SelectionTree");
        SelectionTree tree = new SelectionTree();
        tree.setModel(new DefaultTreeModel(node));
        frame.getContentPane().add(tree);
        frame.setSize(new Dimension(200, 800));
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }

    public void clearToggledPaths() {
        super.clearToggledPaths();
    }

    public void removeSelectionPath(TreePath path) {
        super.removeSelectionPath(path);
    }

    public void setCellRenderer(TreeCellRenderer x) {
    }

    public void setSelectionPath(TreePath path) {
        super.setSelectionPath(path);
        this.clearToggledPaths();
    }

    class CheckBoxCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -4329469376335457482L;

        CheckBoxCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, focus);
            return new TreeCellUI((DefaultMutableTreeNode)value, this.selected);
        }
    }

    class SubsequentSelection
    implements TreeSelectionListener {
        SubsequentSelection() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            SelectionTree.this.clearToggledPaths();
        }
    }

    class TreeCellUI
    extends JComponent {
        private static final long serialVersionUID = -1315044645298979088L;
        private JCheckBox m_checkBox;

        public TreeCellUI(DefaultMutableTreeNode node, boolean selected) {
            JLabel label = new JLabel();
            label.setText(node.getUserObject().toString());
            this.m_checkBox = new JCheckBox();
            this.m_checkBox.setSelected(selected || this.searchSelected(node));
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.m_checkBox);
            this.add(label);
            this.m_checkBox.setBackground(UIManager.getLookAndFeel().getDefaults().getColor("window"));
        }

        private boolean searchSelected(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)SelectionTree.this.getLastSelectedPathComponent();
            if (selectedNode == null) {
                return false;
            }
            return selectedNode.isNodeDescendant(node);
        }
    }
}

