<%@ page session="false" buffer="none" import="org.opencms.loader.*, org.opencms.util.*, org.opencms.frontend.templateone.modules.*" %><%--
--%><%@ taglib prefix="cms" uri="http://www.opencms.org/taglib/cms" %><%--
--%><%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %><%--
--%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %><%

CmsTemplateModules cms = new CmsTemplateModules(pageContext, request, response);

// get currently active locale to initialize message bundle
String locale = cms.getRequestContext().getLocale().toString();
pageContext.setAttribute("locale", locale);

boolean showNumber = Integer.parseInt(request.getParameter("elementcount")) == Integer.MAX_VALUE;
pageContext.setAttribute("shownumber", "" + showNumber);

String folder = cms.getCategoryFolder();
pageContext.setAttribute("catfolder", folder);

int count = cms.getResourceCount(folder, "linklist");
pageContext.setAttribute("rescount", "" + count);

%><fmt:setLocale value="${locale}" /><%--
--%><fmt:bundle basename="org/opencms/frontend/templateone/modules/workplace"><%

// get first the navigation HTML which sets additionally some flags in the bean
String categoryNav = cms.buildHtmlNavList("linklist", "style=\"margin-top: 4px;\"");

if (cms.showNavBreadCrumb()) {
%>
<hr noshade="noshade" size="1">
<b><fmt:message key="navbar.center.path" />:</b> <%= cms.buildHtmlNavBreadcrumb(" | ") %>
<hr noshade="noshade" size="1">
<%
}

if (cms.hasCategoryFolders()) {
%>
<p style="margin: 0px;">
<b><fmt:message key="navbar.center.categories" />:</b></p>
<%= categoryNav %>
<hr noshade="noshade" size="1">
<%
}
%>
<c:choose>
<c:when test="${(rescount != '0') && (rescount != '-1')}">

<cms:contentload collector="%(param.collector)" param="%(pageContext.catfolder)link_%(number).html|linklist|%(param.elementcount)" editable="true" pageSize="%(param.count)" pageIndex="%(param.pageIndex)" pageNavLength="10"><%--
--%><cms:contentinfo var="contentInfo" scope="request" /><%--

--%><c:if test="${(contentInfo.resultIndex % contentInfo.pageSize) == 1}"><%--

	result size: <cms:contentinfo value="${contentInfo.resultSize}" />
	page size: <cms:contentinfo value="${contentInfo.pageSize}" />
	page count: <cms:contentinfo value="${contentInfo.pageCount}" />
	page index: <cms:contentinfo value="${contentInfo.pageIndex}" />

--%><c:if test="${shownumber == 'true' && contentInfo.pageCount > 1}"><p><fmt:message key="navbar.center.resultsize" />: <cms:contentinfo value="${contentInfo.resultSize}" /></c:if><%--
--%><c:if test="${contentInfo.resultSize > contentInfo.pageSize}">
&nbsp;|&nbsp;
<fmt:message key="navbar.center.pagelinks" />:&nbsp;
<c:forEach var="i" begin="${contentInfo.pageNavStartIndex}" end="${contentInfo.pageNavEndIndex}">
<c:choose>
<c:when test="${(i == param.pageIndex) || (i == 1 && param.pageIndex == null)}">
[<c:out value="${i}" />]&nbsp;
</c:when>
<c:otherwise>
[<a href="<cms:link><%= cms.getRequestContext().getUri() %>?pageIndex=<c:out value="${i}" />&categoryfolder=<c:out value="${catfolder}" /></cms:link>"><c:out value="${i}" /></a>]&nbsp;
</c:otherwise>
</c:choose>
</c:forEach>
</c:if>
<c:if test="${shownumber == 'true'}"></p></c:if>
</c:if>

<c:set var="href"><cms:contentshow element="Url" /></c:set><%
String href = (String)pageContext.getAttribute("href");
if (!href.startsWith("http") && !href.startsWith("ftp:") && !href.startsWith("mailto:")) {
	href = cms.link(href);
}

%><p style="margin-top: 8px; padding-top: 0px;">
<%-- begin image --%>
<cms:contentcheck ifexists="Image"><cms:contentloop element="Image">
<img src="<cms:link><cms:contentshow element="Image" />?<%= CmsImageScaler.PARAM_SCALE %>=w:48,h:48,t:2</cms:link>" border="0" alt="<cms:contentshow element="Description" />" align="right" hspace="5">
</cms:contentloop></cms:contentcheck>
<%-- end image --%>
<span style="font-size: 1.05em;"><a href="<%= href %>" target="<cms:contentshow element="Target" />" title="<cms:contentshow element="Title" />"><b><cms:contentshow element="Title" /></b></a></span><br>
<cms:contentcheck ifexists="Description"><cms:contentshow element="Description" /><br></cms:contentcheck>
<a href="<%= href %>" target="<cms:contentshow element="Target" />" title="<cms:contentshow element="Title" />"><%= href %></a>
</p>
</cms:contentload><%--
--%></c:when><%--

--%><c:otherwise>
<p><b><fmt:message key="item.noentries" /></b></p>
</c:otherwise></c:choose></fmt:bundle>