/*
 * File   : $Source$
 * Date   : $Date$
 * Version: $Revision$
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.demos.list;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @version $Revision$ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_1_HELP_0 = "GUI_LISTDEMO_1_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_1_NAME_0 = "GUI_LISTDEMO_1_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_10_HELP_0 = "GUI_LISTDEMO_10_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_10_NAME_0 = "GUI_LISTDEMO_10_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_11_HELP_0 = "GUI_LISTDEMO_11_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_11_NAME_0 = "GUI_LISTDEMO_11_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_12_HELP_0 = "GUI_LISTDEMO_12_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_12_NAME_0 = "GUI_LISTDEMO_12_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_13_HELP_0 = "GUI_LISTDEMO_13_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_13_NAME_0 = "GUI_LISTDEMO_13_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_14_HELP_0 = "GUI_LISTDEMO_14_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_14_NAME_0 = "GUI_LISTDEMO_14_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_15_HELP_0 = "GUI_LISTDEMO_15_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_15_NAME_0 = "GUI_LISTDEMO_15_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_16_HELP_0 = "GUI_LISTDEMO_16_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_16_NAME_0 = "GUI_LISTDEMO_16_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_2_HELP_0 = "GUI_LISTDEMO_2_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_2_NAME_0 = "GUI_LISTDEMO_2_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_3_HELP_0 = "GUI_LISTDEMO_3_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_3_NAME_0 = "GUI_LISTDEMO_3_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_4_HELP_0 = "GUI_LISTDEMO_4_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_4_NAME_0 = "GUI_LISTDEMO_4_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_5_HELP_0 = "GUI_LISTDEMO_5_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_5_NAME_0 = "GUI_LISTDEMO_5_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_6_HELP_0 = "GUI_LISTDEMO_6_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_6_NAME_0 = "GUI_LISTDEMO_6_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_7_HELP_0 = "GUI_LISTDEMO_7_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_7_NAME_0 = "GUI_LISTDEMO_7_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_8_HELP_0 = "GUI_LISTDEMO_8_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_8_NAME_0 = "GUI_LISTDEMO_8_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_9_HELP_0 = "GUI_LISTDEMO_9_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_9_NAME_0 = "GUI_LISTDEMO_9_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_9A_HELP_0 = "GUI_LISTDEMO_9A_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_9A_NAME_0 = "GUI_LISTDEMO_9A_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_ACTIONS_GROUP_0 = "GUI_LISTDEMO_ACTIONS_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_ADVANCED_ACTIONS_GROUP_0 = "GUI_LISTDEMO_ADVANCED_ACTIONS_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_BASIC_GROUP_0 = "GUI_LISTDEMO_BASIC_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_COMBINATIONS_GROUP_0 = "GUI_LISTDEMO_COMBINATIONS_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_TOOL_GROUP_0 = "GUI_LISTDEMO_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_TOOL_HELP_0 = "GUI_LISTDEMO_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LISTDEMO_TOOL_NAME_0 = "GUI_LISTDEMO_TOOL_NAME_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.demos.list.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}