/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/accounts/Messages.java,v $
 * Date   : $Date: 2008-07-01 07:21:16 $
 * Version: $Revision: 1.17 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.accounts;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Michael Moossen 
 * 
 * @version $Revision: 1.17 $ 
 * @version $Revision: 1.17 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTIVATE_GROUP_1 = "ERR_ACTIVATE_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTIVATE_ROLE_2 = "ERR_ACTIVATE_ROLE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTIVATE_SELECTED_GROUPS_0 = "ERR_ACTIVATE_SELECTED_GROUPS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTIVATE_SELECTED_USERS_0 = "ERR_ACTIVATE_SELECTED_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTIVATE_USER_1 = "ERR_ACTIVATE_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ADD_SELECTED_GROUP_0 = "ERR_ADD_SELECTED_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ADD_SELECTED_GROUPS_0 = "ERR_ADD_SELECTED_GROUPS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ADD_SELECTED_ORGUNITUSER_0 = "ERR_ADD_SELECTED_ORGUNITUSER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ADD_SELECTED_USER_0 = "ERR_ADD_SELECTED_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ADD_SELECTED_USERS_0 = "ERR_ADD_SELECTED_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ADD_USER_TO_GROUP_0 = "ERR_ADD_USER_TO_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ADD_USER_TO_ROLE_0 = "ERR_ADD_USER_TO_ROLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DEACTIVATE_GROUP_1 = "ERR_DEACTIVATE_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DEACTIVATE_INDIRECT_ROLE_2 = "ERR_DEACTIVATE_INDIRECT_ROLE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DEACTIVATE_ROLE_2 = "ERR_DEACTIVATE_ROLE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DEACTIVATE_SELECTED_GROUPS_0 = "ERR_DEACTIVATE_SELECTED_GROUPS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DEACTIVATE_SELECTED_USERS_0 = "ERR_DEACTIVATE_SELECTED_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DEACTIVATE_USER_1 = "ERR_DEACTIVATE_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_GROUP_1 = "ERR_DELETE_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_ORGUNIT_1 = "ERR_DELETE_ORGUNIT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_SELECTED_GROUPS_0 = "ERR_DELETE_SELECTED_GROUPS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_SELECTED_USERS_0 = "ERR_DELETE_SELECTED_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_USER_1 = "ERR_DELETE_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DIGEST_PASSWORD_0 = "ERR_DIGEST_PASSWORD_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EDIT_GROUP_0 = "ERR_EDIT_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EDIT_GROUPS_0 = "ERR_EDIT_GROUPS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EDIT_USER_0 = "ERR_EDIT_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EDIT_USERS_0 = "ERR_EDIT_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_FORWARDING_TO_PARENT_TOOL_0 = "ERR_FORWARDING_TO_PARENT_TOOL_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_GET_EXPORT_USERS_0 = "ERR_GET_EXPORT_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ILLEGAL_ACCESS_0 = "ERR_ILLEGAL_ACCESS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORT_USER_0 = "ERR_IMPORT_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVOCATION_TARGET_0 = "ERR_INVOCATION_TARGET_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REMOVE_SELECTED_GROUP_0 = "ERR_REMOVE_SELECTED_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REMOVE_SELECTED_GROUPS_0 = "ERR_REMOVE_SELECTED_GROUPS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REMOVE_SELECTED_ORGUNITUSER_0 = "ERR_REMOVE_SELECTED_ORGUNITUSER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_TRANSFER_GROUP_1 = "ERR_TRANSFER_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_TRANSFER_USER_1 = "ERR_TRANSFER_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_USERDATA_IMPORT_CSV_MISSING_NAME_0 = "ERR_USERDATA_IMPORT_CSV_MISSING_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_USERDATA_IMPORT_CSV_MISSING_PASSWORD_0 = "ERR_USERDATA_IMPORT_CSV_MISSING_PASSWORD_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_USERDATA_IMPORT_NO_CONTENT_0 = "ERR_USERDATA_IMPORT_NO_CONTENT_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_USERGROUPS_DIRECT_GROUP_1 = "ERR_USERGROUPS_DIRECT_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_WRITE_TO_EXPORT_FILE_0 = "ERR_WRITE_TO_EXPORT_FILE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ACCOUNTS_ADMIN_TOOL_GROUP_0 = "GUI_ACCOUNTS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ACCOUNTS_ADMIN_TOOL_HELP_0 = "GUI_ACCOUNTS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ACCOUNTS_ADMIN_TOOL_NAME_0 = "GUI_ACCOUNTS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ADMINORGUNITS_LIST_NAME_0 = "GUI_ADMINORGUNITS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ALLGROUPS_ADMIN_TOOL_GROUP_0 = "GUI_ALLGROUPS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ALLGROUPS_ADMIN_TOOL_HELP_0 = "GUI_ALLGROUPS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ALLGROUPS_ADMIN_TOOL_NAME_0 = "GUI_ALLGROUPS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ALLUSERS_ADMIN_TOOL_GROUP_0 = "GUI_ALLUSERS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ALLUSERS_ADMIN_TOOL_HELP_0 = "GUI_ALLUSERS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ALLUSERS_ADMIN_TOOL_NAME_0 = "GUI_ALLUSERS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ASSIGNUSER_ADMIN_TOOL_GROUP_0 = "GUI_ASSIGNUSER_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ASSIGNUSER_ADMIN_TOOL_HELP_0 = "GUI_ASSIGNUSER_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ASSIGNUSER_ADMIN_TOOL_NAME_0 = "GUI_ASSIGNUSER_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETEORGUNIT_ADMIN_TOOL_GROUP_0 = "GUI_DELETEORGUNIT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETEORGUNIT_ADMIN_TOOL_HELP_0 = "GUI_DELETEORGUNIT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETEORGUNIT_ADMIN_TOOL_NAME_0 = "GUI_DELETEORGUNIT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_BUTTON_DELETE_0 = "GUI_DEPENDENCIES_BUTTON_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_BUTTON_TRANSFER_0 = "GUI_DEPENDENCIES_BUTTON_TRANSFER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_ADMIN_TOOL_GROUP_0 = "GUI_EDITGROUP_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_ADMIN_TOOL_HELP_0 = "GUI_EDITGROUP_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_ADMIN_TOOL_NAME_0 = "GUI_EDITGROUP_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITGROUP_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_DELETE_ADMIN_TOOL_GROUP_0 = "GUI_EDITGROUP_DELETE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_DELETE_ADMIN_TOOL_HELP_0 = "GUI_EDITGROUP_DELETE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_DELETE_ADMIN_TOOL_NAME_0 = "GUI_EDITGROUP_DELETE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_DELETE_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITGROUP_DELETE_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_OVERVIEW_ADMIN_TOOL_GROUP_0 = "GUI_EDITGROUP_OVERVIEW_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_OVERVIEW_ADMIN_TOOL_HELP_0 = "GUI_EDITGROUP_OVERVIEW_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_OVERVIEW_ADMIN_TOOL_NAME_0 = "GUI_EDITGROUP_OVERVIEW_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_OVERVIEW_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITGROUP_OVERVIEW_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_USERS_ADMIN_TOOL_GROUP_0 = "GUI_EDITGROUP_USERS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_USERS_ADMIN_TOOL_HELP_0 = "GUI_EDITGROUP_USERS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_USERS_ADMIN_TOOL_NAME_0 = "GUI_EDITGROUP_USERS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITGROUP_USERS_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITGROUP_USERS_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITORGUNIT_ADMIN_TOOL_GROUP_0 = "GUI_EDITORGUNIT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITORGUNIT_ADMIN_TOOL_HELP_0 = "GUI_EDITORGUNIT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITORGUNIT_ADMIN_TOOL_NAME_0 = "GUI_EDITORGUNIT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_ADMIN_TOOL_GROUP_0 = "GUI_EDITUSER_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_ADMIN_TOOL_HELP_0 = "GUI_EDITUSER_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_ADMIN_TOOL_NAME_0 = "GUI_EDITUSER_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITUSER_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_DELETE_ADMIN_TOOL_GROUP_0 = "GUI_EDITUSER_DELETE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_DELETE_ADMIN_TOOL_HELP_0 = "GUI_EDITUSER_DELETE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_DELETE_ADMIN_TOOL_NAME_0 = "GUI_EDITUSER_DELETE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_DELETE_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITUSER_DELETE_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_GROUPS_ADMIN_TOOL_GROUP_0 = "GUI_EDITUSER_GROUPS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_GROUPS_ADMIN_TOOL_HELP_0 = "GUI_EDITUSER_GROUPS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_GROUPS_ADMIN_TOOL_NAME_0 = "GUI_EDITUSER_GROUPS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_GROUPS_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITUSER_GROUPS_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_OVERVIEW_ADMIN_TOOL_GROUP_0 = "GUI_EDITUSER_OVERVIEW_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_OVERVIEW_ADMIN_TOOL_HELP_0 = "GUI_EDITUSER_OVERVIEW_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_OVERVIEW_ADMIN_TOOL_NAME_0 = "GUI_EDITUSER_OVERVIEW_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_OVERVIEW_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITUSER_OVERVIEW_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_SWITCH_ADMIN_TOOL_GROUP_0 = "GUI_EDITUSER_SWITCH_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_SWITCH_ADMIN_TOOL_HELP_0 = "GUI_EDITUSER_SWITCH_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_SWITCH_ADMIN_TOOL_NAME_0 = "GUI_EDITUSER_SWITCH_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITUSER_SWITCH_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITUSER_SWITCH_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTCSV_ADMIN_TOOL_GROUP_0 = "GUI_EXPORTCSV_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTCSV_ADMIN_TOOL_HELP_0 = "GUI_EXPORTCSV_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTCSV_ADMIN_TOOL_NAME_0 = "GUI_EXPORTCSV_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_DELETE_0 = "GUI_GROUP_DEPENDENCIES_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_ACTION_GRP_HELP_0 = "GUI_GROUP_DEPENDENCIES_LIST_ACTION_GRP_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_ACTION_GRP_NAME_0 = "GUI_GROUP_DEPENDENCIES_LIST_ACTION_GRP_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_ACTION_RES_HELP_0 = "GUI_GROUP_DEPENDENCIES_LIST_ACTION_RES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_ACTION_RES_NAME_0 = "GUI_GROUP_DEPENDENCIES_LIST_ACTION_RES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_ACTION_USR_HELP_0 = "GUI_GROUP_DEPENDENCIES_LIST_ACTION_USR_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_ACTION_USR_NAME_0 = "GUI_GROUP_DEPENDENCIES_LIST_ACTION_USR_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_COLS_ICON_0 = "GUI_GROUP_DEPENDENCIES_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_COLS_ICON_HELP_0 = "GUI_GROUP_DEPENDENCIES_LIST_COLS_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_COLS_NAME_0 = "GUI_GROUP_DEPENDENCIES_LIST_COLS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_COLS_PERMISSIONS_0 = "GUI_GROUP_DEPENDENCIES_LIST_COLS_PERMISSIONS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_LIST_NAME_0 = "GUI_GROUP_DEPENDENCIES_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_NOTICE_0 = "GUI_GROUP_DEPENDENCIES_NOTICE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_NOTICE_TEXT_0 = "GUI_GROUP_DEPENDENCIES_NOTICE_TEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_DEPENDENCIES_SELECTED_GROUPS_0 = "GUI_GROUP_DEPENDENCIES_SELECTED_GROUPS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_EDITOR_LABEL_FLAGS_BLOCK_0 = "GUI_GROUP_EDITOR_LABEL_FLAGS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUP_EDITOR_LABEL_IDENTIFICATION_BLOCK_0 = "GUI_GROUP_EDITOR_LABEL_IDENTIFICATION_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_ADMIN_TOOL_GROUP_0 = "GUI_GROUPS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_ADMIN_TOOL_HELP_0 = "GUI_GROUPS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_ADMIN_TOOL_NAME_0 = "GUI_GROUPS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_ADMIN_TOOL_NAVBARNAME_0 = "GUI_GROUPS_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DELETE_ADMIN_TOOL_GROUP_0 = "GUI_GROUPS_DELETE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DELETE_ADMIN_TOOL_HELP_0 = "GUI_GROUPS_DELETE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DELETE_ADMIN_TOOL_NAME_0 = "GUI_GROUPS_DELETE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_CHILDREN_NAME_0 = "GUI_GROUPS_DETAIL_CHILDREN_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_CHILDREN_HELP_0 = "GUI_GROUPS_DETAIL_HIDE_CHILDREN_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_CHILDREN_NAME_0 = "GUI_GROUPS_DETAIL_HIDE_CHILDREN_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_ORGUNIT_HELP_0 = "GUI_GROUPS_DETAIL_HIDE_ORGUNIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_ORGUNIT_NAME_0 = "GUI_GROUPS_DETAIL_HIDE_ORGUNIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_OTHEROU_HELP_0 = "GUI_GROUPS_DETAIL_HIDE_OTHEROU_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_OTHEROU_NAME_0 = "GUI_GROUPS_DETAIL_HIDE_OTHEROU_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_PARENT_HELP_0 = "GUI_GROUPS_DETAIL_HIDE_PARENT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_PARENT_NAME_0 = "GUI_GROUPS_DETAIL_HIDE_PARENT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_SET_PERM_HELP_0 = "GUI_GROUPS_DETAIL_HIDE_SET_PERM_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_SET_PERM_NAME_0 = "GUI_GROUPS_DETAIL_HIDE_SET_PERM_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_USERS_HELP_0 = "GUI_GROUPS_DETAIL_HIDE_USERS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_HIDE_USERS_NAME_0 = "GUI_GROUPS_DETAIL_HIDE_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_ORGUNIT_NAME_0 = "GUI_GROUPS_DETAIL_ORGUNIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_OTHEROU_NAME_0 = "GUI_GROUPS_DETAIL_OTHEROU_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_PARENT_NAME_0 = "GUI_GROUPS_DETAIL_PARENT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SET_PERM_NAME_0 = "GUI_GROUPS_DETAIL_SET_PERM_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_CHILDREN_HELP_0 = "GUI_GROUPS_DETAIL_SHOW_CHILDREN_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_CHILDREN_NAME_0 = "GUI_GROUPS_DETAIL_SHOW_CHILDREN_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_ORGUNIT_HELP_0 = "GUI_GROUPS_DETAIL_SHOW_ORGUNIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_ORGUNIT_NAME_0 = "GUI_GROUPS_DETAIL_SHOW_ORGUNIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_OTHEROU_HELP_0 = "GUI_GROUPS_DETAIL_SHOW_OTHEROU_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_OTHEROU_NAME_0 = "GUI_GROUPS_DETAIL_SHOW_OTHEROU_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_PARENT_HELP_0 = "GUI_GROUPS_DETAIL_SHOW_PARENT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_PARENT_NAME_0 = "GUI_GROUPS_DETAIL_SHOW_PARENT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_SET_PERM_HELP_0 = "GUI_GROUPS_DETAIL_SHOW_SET_PERM_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_SET_PERM_NAME_0 = "GUI_GROUPS_DETAIL_SHOW_SET_PERM_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_USERS_HELP_0 = "GUI_GROUPS_DETAIL_SHOW_USERS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_SHOW_USERS_NAME_0 = "GUI_GROUPS_DETAIL_SHOW_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_DETAIL_USERS_NAME_0 = "GUI_GROUPS_DETAIL_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_ACTIVATE_CONF_0 = "GUI_GROUPS_LIST_ACTION_ACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_ACTIVATE_HELP_0 = "GUI_GROUPS_LIST_ACTION_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_ACTIVATE_NAME_0 = "GUI_GROUPS_LIST_ACTION_ACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_DEACTIVATE_CONF_0 = "GUI_GROUPS_LIST_ACTION_DEACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_DEACTIVATE_HELP_0 = "GUI_GROUPS_LIST_ACTION_DEACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_DEACTIVATE_NAME_0 = "GUI_GROUPS_LIST_ACTION_DEACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_DELETE_HELP_0 = "GUI_GROUPS_LIST_ACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_DELETE_NAME_0 = "GUI_GROUPS_LIST_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_EDIT_HELP_0 = "GUI_GROUPS_LIST_ACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_EDIT_NAME_0 = "GUI_GROUPS_LIST_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_USERS_HELP_0 = "GUI_GROUPS_LIST_ACTION_USERS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_ACTION_USERS_NAME_0 = "GUI_GROUPS_LIST_ACTION_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_AVAILABLE_HELP_0 = "GUI_GROUPS_LIST_AVAILABLE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_AVAILABLE_NAME_0 = "GUI_GROUPS_LIST_AVAILABLE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_ACTIVATE_0 = "GUI_GROUPS_LIST_COLS_ACTIVATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_ACTIVATE_HELP_0 = "GUI_GROUPS_LIST_COLS_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_DELETE_0 = "GUI_GROUPS_LIST_COLS_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_DELETE_HELP_0 = "GUI_GROUPS_LIST_COLS_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_DESCRIPTION_0 = "GUI_GROUPS_LIST_COLS_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_EDIT_0 = "GUI_GROUPS_LIST_COLS_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_EDIT_HELP_0 = "GUI_GROUPS_LIST_COLS_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_ICON_0 = "GUI_GROUPS_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_ICON_HELP_0 = "GUI_GROUPS_LIST_COLS_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_NAME_0 = "GUI_GROUPS_LIST_COLS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_ORGUNIT_0 = "GUI_GROUPS_LIST_COLS_ORGUNIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_PARENT_0 = "GUI_GROUPS_LIST_COLS_PARENT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_STATE_0 = "GUI_GROUPS_LIST_COLS_STATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_STATE_HELP_0 = "GUI_GROUPS_LIST_COLS_STATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_USERS_0 = "GUI_GROUPS_LIST_COLS_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_COLS_USERS_HELP_0 = "GUI_GROUPS_LIST_COLS_USERS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_DEFACTION_ADD_HELP_0 = "GUI_GROUPS_LIST_DEFACTION_ADD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_DEFACTION_ADD_NAME_0 = "GUI_GROUPS_LIST_DEFACTION_ADD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_DEFACTION_EDIT_HELP_0 = "GUI_GROUPS_LIST_DEFACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_DEFACTION_EDIT_NAME_0 = "GUI_GROUPS_LIST_DEFACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_DEFACTION_REMOVE_HELP_0 = "GUI_GROUPS_LIST_DEFACTION_REMOVE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_DEFACTION_REMOVE_NAME_0 = "GUI_GROUPS_LIST_DEFACTION_REMOVE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_DIRECT_HELP_0 = "GUI_GROUPS_LIST_DIRECT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_DIRECT_NAME_0 = "GUI_GROUPS_LIST_DIRECT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_INDIRECT_HELP_0 = "GUI_GROUPS_LIST_INDIRECT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_INDIRECT_NAME_0 = "GUI_GROUPS_LIST_INDIRECT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_ACTIVATE_CONF_0 = "GUI_GROUPS_LIST_MACTION_ACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_ACTIVATE_HELP_0 = "GUI_GROUPS_LIST_MACTION_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_ACTIVATE_NAME_0 = "GUI_GROUPS_LIST_MACTION_ACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_ADD_CONF_0 = "GUI_GROUPS_LIST_MACTION_ADD_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_ADD_HELP_0 = "GUI_GROUPS_LIST_MACTION_ADD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_ADD_NAME_0 = "GUI_GROUPS_LIST_MACTION_ADD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_DEACTIVATE_CONF_0 = "GUI_GROUPS_LIST_MACTION_DEACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_DEACTIVATE_HELP_0 = "GUI_GROUPS_LIST_MACTION_DEACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_DEACTIVATE_NAME_0 = "GUI_GROUPS_LIST_MACTION_DEACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_DELETE_CONF_0 = "GUI_GROUPS_LIST_MACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_DELETE_HELP_0 = "GUI_GROUPS_LIST_MACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_DELETE_NAME_0 = "GUI_GROUPS_LIST_MACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_REMOVE_CONF_0 = "GUI_GROUPS_LIST_MACTION_REMOVE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_REMOVE_HELP_0 = "GUI_GROUPS_LIST_MACTION_REMOVE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_MACTION_REMOVE_NAME_0 = "GUI_GROUPS_LIST_MACTION_REMOVE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_LIST_NAME_0 = "GUI_GROUPS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_TRANSFER_LIST_ACTION_TRANSFER_HELP_0 = "GUI_GROUPS_TRANSFER_LIST_ACTION_TRANSFER_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_TRANSFER_LIST_ACTION_TRANSFER_NAME_0 = "GUI_GROUPS_TRANSFER_LIST_ACTION_TRANSFER_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_TRANSFER_LIST_COLS_TRANSFER_0 = "GUI_GROUPS_TRANSFER_LIST_COLS_TRANSFER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_TRANSFER_LIST_COLS_TRANSFER_HELP_0 = "GUI_GROUPS_TRANSFER_LIST_COLS_TRANSFER_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_TRANSFER_LIST_DEFACTION_TRANSFER_HELP_0 = "GUI_GROUPS_TRANSFER_LIST_DEFACTION_TRANSFER_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_TRANSFER_LIST_DEFACTION_TRANSFER_NAME_0 = "GUI_GROUPS_TRANSFER_LIST_DEFACTION_TRANSFER_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_TRANSFER_LIST_NAME_0 = "GUI_GROUPS_TRANSFER_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_TRANSFER_NOTICE_0 = "GUI_GROUPS_TRANSFER_NOTICE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_TRANSFER_NOTICE_TEXT_0 = "GUI_GROUPS_TRANSFER_NOTICE_TEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPUSERS_LIST_NAME_0 = "GUI_GROUPUSERS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMEXPORT_ADMIN_TOOL_GROUP_0 = "GUI_IMEXPORT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMEXPORT_ADMIN_TOOL_HELP_0 = "GUI_IMEXPORT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMEXPORT_ADMIN_TOOL_NAME_0 = "GUI_IMEXPORT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTCSV_ADMIN_TOOL_GROUP_0 = "GUI_IMPORTCSV_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTCSV_ADMIN_TOOL_HELP_0 = "GUI_IMPORTCSV_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTCSV_ADMIN_TOOL_NAME_0 = "GUI_IMPORTCSV_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_ADMIN_TOOL_NAME_0 = "GUI_IMPORTLISTCSV_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_ALREADY_EXISTS_0 = "GUI_IMPORTLISTCSV_ALREADY_EXISTS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_DETAIL_HIDE_REASON_HELP_0 = "GUI_IMPORTLISTCSV_DETAIL_HIDE_REASON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_DETAIL_HIDE_REASON_NAME_0 = "GUI_IMPORTLISTCSV_DETAIL_HIDE_REASON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_DETAIL_REASON_NAME_0 = "GUI_IMPORTLISTCSV_DETAIL_REASON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_DETAIL_SHOW_REASON_HELP_0 = "GUI_IMPORTLISTCSV_DETAIL_SHOW_REASON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_DETAIL_SHOW_REASON_NAME_0 = "GUI_IMPORTLISTCSV_DETAIL_SHOW_REASON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_IMPORT_LABEL_HINT_TEXT_0 = "GUI_IMPORTLISTCSV_IMPORT_LABEL_HINT_TEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_LIST_COLS_PASSWORD_0 = "GUI_IMPORTLISTCSV_LIST_COLS_PASSWORD_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_LIST_COLS_VAIDATION_0 = "GUI_IMPORTLISTCSV_LIST_COLS_VAIDATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_LIST_MACTION_SELECT_HELP_0 = "GUI_IMPORTLISTCSV_LIST_MACTION_SELECT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_LIST_MACTION_SELECT_NAME_0 = "GUI_IMPORTLISTCSV_LIST_MACTION_SELECT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_LIST_NAME_0 = "GUI_IMPORTLISTCSV_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTLISTCSV_VALID_USER_0 = "GUI_IMPORTLISTCSV_VALID_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWGROUP_ADMIN_TOOL_GROUP_0 = "GUI_NEWGROUP_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWGROUP_ADMIN_TOOL_HELP_0 = "GUI_NEWGROUP_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWGROUP_ADMIN_TOOL_NAME_0 = "GUI_NEWGROUP_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWORGUNIT_ADMIN_TOOL_GROUP_0 = "GUI_NEWORGUNIT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWORGUNIT_ADMIN_TOOL_HELP_0 = "GUI_NEWORGUNIT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWORGUNIT_ADMIN_TOOL_NAME_0 = "GUI_NEWORGUNIT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWUSER_ADMIN_TOOL_GROUP_0 = "GUI_NEWUSER_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWUSER_ADMIN_TOOL_HELP_0 = "GUI_NEWUSER_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWUSER_ADMIN_TOOL_NAME_0 = "GUI_NEWUSER_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NOTGROUPUSERS_LIST_NAME_0 = "GUI_NOTGROUPUSERS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NOTORGUNITUSERS_LIST_NAME_0 = "GUI_NOTORGUNITUSERS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NOTROLEUSERS_LIST_NAME_0 = "GUI_NOTROLEUSERS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NOTUSERGROUPS_LIST_NAME_0 = "GUI_NOTUSERGROUPS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_ACTION_DELETE_CONF_1 = "GUI_ORGUNIT_ACTION_DELETE_CONF_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_ACTION_DELETE_NAME_0 = "GUI_ORGUNIT_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_ADMIN_TOOL_DISABLED_DELETE_HELP_0 = "GUI_ORGUNIT_ADMIN_TOOL_DISABLED_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_ADMIN_TOOL_DISABLED_EDIT_HELP_0 = "GUI_ORGUNIT_ADMIN_TOOL_DISABLED_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_ADMIN_TOOL_NAME_0 = "GUI_ORGUNIT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_EDITOR_LABEL_CONTENT_BLOCK_0 = "GUI_ORGUNIT_EDITOR_LABEL_CONTENT_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_EDITOR_LABEL_FLAGS_BLOCK_0 = "GUI_ORGUNIT_EDITOR_LABEL_FLAGS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_EDITOR_LABEL_IDENTIFICATION_BLOCK_0 = "GUI_ORGUNIT_EDITOR_LABEL_IDENTIFICATION_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_MGMT_ADMIN_TOOL_GROUP_0 = "GUI_ORGUNIT_MGMT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_MGMT_ADMIN_TOOL_HELP_0 = "GUI_ORGUNIT_MGMT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_MGMT_ADMIN_TOOL_NAME_0 = "GUI_ORGUNIT_MGMT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_RESOURCES_LIST_NAME_0 = "GUI_ORGUNIT_RESOURCES_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_GROUPS_NAME_0 = "GUI_ORGUNITS_DETAIL_GROUPS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_HIDE_GROUPS_HELP_0 = "GUI_ORGUNITS_DETAIL_HIDE_GROUPS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_HIDE_GROUPS_NAME_0 = "GUI_ORGUNITS_DETAIL_HIDE_GROUPS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_HIDE_RESOURCES_HELP_0 = "GUI_ORGUNITS_DETAIL_HIDE_RESOURCES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_HIDE_RESOURCES_NAME_0 = "GUI_ORGUNITS_DETAIL_HIDE_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_HIDE_USERS_HELP_0 = "GUI_ORGUNITS_DETAIL_HIDE_USERS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_HIDE_USERS_NAME_0 = "GUI_ORGUNITS_DETAIL_HIDE_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_RESOURCES_NAME_0 = "GUI_ORGUNITS_DETAIL_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_SHOW_GROUPS_HELP_0 = "GUI_ORGUNITS_DETAIL_SHOW_GROUPS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_SHOW_GROUPS_NAME_0 = "GUI_ORGUNITS_DETAIL_SHOW_GROUPS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_SHOW_RESOURCES_HELP_0 = "GUI_ORGUNITS_DETAIL_SHOW_RESOURCES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_SHOW_RESOURCES_NAME_0 = "GUI_ORGUNITS_DETAIL_SHOW_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_SHOW_USERS_HELP_0 = "GUI_ORGUNITS_DETAIL_SHOW_USERS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_SHOW_USERS_NAME_0 = "GUI_ORGUNITS_DETAIL_SHOW_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_DETAIL_USERS_NAME_0 = "GUI_ORGUNITS_DETAIL_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_ACTION_DELETE_NAME_0 = "GUI_ORGUNITS_LIST_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_ACTION_EDIT_NAME_0 = "GUI_ORGUNITS_LIST_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_ACTION_GROUP_NAME_0 = "GUI_ORGUNITS_LIST_ACTION_GROUP_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_ACTION_OVERVIEW_NAME_0 = "GUI_ORGUNITS_LIST_ACTION_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_ACTION_USER_NAME_0 = "GUI_ORGUNITS_LIST_ACTION_USER_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_DELETE_0 = "GUI_ORGUNITS_LIST_COLS_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_DELETE_HELP_0 = "GUI_ORGUNITS_LIST_COLS_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_DESCRIPTION_0 = "GUI_ORGUNITS_LIST_COLS_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_EDIT_0 = "GUI_ORGUNITS_LIST_COLS_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_EDIT_HELP_0 = "GUI_ORGUNITS_LIST_COLS_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_GROUP_0 = "GUI_ORGUNITS_LIST_COLS_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_GROUP_HELP_0 = "GUI_ORGUNITS_LIST_COLS_GROUP_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_NAME_0 = "GUI_ORGUNITS_LIST_COLS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_OVERVIEW_0 = "GUI_ORGUNITS_LIST_COLS_OVERVIEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_OVERVIEW_HELP_0 = "GUI_ORGUNITS_LIST_COLS_OVERVIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_USER_0 = "GUI_ORGUNITS_LIST_COLS_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_COLS_USER_HELP_0 = "GUI_ORGUNITS_LIST_COLS_USER_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_DEFACTION_OVERVIEW_HELP_0 = "GUI_ORGUNITS_LIST_DEFACTION_OVERVIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_DEFACTION_OVERVIEW_NAME_0 = "GUI_ORGUNITS_LIST_DEFACTION_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_MACTION_DELETE_CONF_0 = "GUI_ORGUNITS_LIST_MACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_MACTION_DELETE_HELP_0 = "GUI_ORGUNITS_LIST_MACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITS_LIST_MACTION_DELETE_NAME_0 = "GUI_ORGUNITS_LIST_MACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_BUTTON_CANCEL_0 = "GUI_ORGUNITUSERS_BUTTON_CANCEL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_BUTTON_CONFIRM_0 = "GUI_ORGUNITUSERS_BUTTON_CONFIRM_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_AVAILABLE_HELP_0 = "GUI_ORGUNITUSERS_LIST_AVAILABLE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_AVAILABLE_NAME_0 = "GUI_ORGUNITUSERS_LIST_AVAILABLE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_COLS_STATE_0 = "GUI_ORGUNITUSERS_LIST_COLS_STATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_COLS_STATE_HELP_0 = "GUI_ORGUNITUSERS_LIST_COLS_STATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_DEFACTION_ADD_HELP_0 = "GUI_ORGUNITUSERS_LIST_DEFACTION_ADD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_DEFACTION_ADD_NAME_0 = "GUI_ORGUNITUSERS_LIST_DEFACTION_ADD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_DEFACTION_REMOVE_HELP_0 = "GUI_ORGUNITUSERS_LIST_DEFACTION_REMOVE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_DEFACTION_REMOVE_NAME_0 = "GUI_ORGUNITUSERS_LIST_DEFACTION_REMOVE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_DISABLED_DELETE_HELP_0 = "GUI_ORGUNITUSERS_LIST_DISABLED_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_INORGUNIT_HELP_0 = "GUI_ORGUNITUSERS_LIST_INORGUNIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_INORGUNIT_NAME_0 = "GUI_ORGUNITUSERS_LIST_INORGUNIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_MACTION_ADD_HELP_0 = "GUI_ORGUNITUSERS_LIST_MACTION_ADD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_MACTION_ADD_NAME_0 = "GUI_ORGUNITUSERS_LIST_MACTION_ADD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_MACTION_REMOVE_HELP_0 = "GUI_ORGUNITUSERS_LIST_MACTION_REMOVE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_MACTION_REMOVE_NAME_0 = "GUI_ORGUNITUSERS_LIST_MACTION_REMOVE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNITUSERS_LIST_NAME_0 = "GUI_ORGUNITUSERS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OVERVIEWACCMAN_ADMIN_TOOL_HELP_0 = "GUI_OVERVIEWACCMAN_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OVERVIEWACCMAN_ADMIN_TOOL_NAME_0 = "GUI_OVERVIEWACCMAN_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OVERVIEWACCMAN_ADMIN_TOOL_NAVBARNAME_0 = "GUI_OVERVIEWACCMAN_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OVERVIEWORGUNIT_ADMIN_TOOL_GROUP_0 = "GUI_OVERVIEWORGUNIT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OVERVIEWORGUNIT_ADMIN_TOOL_HELP_0 = "GUI_OVERVIEWORGUNIT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OVERVIEWORGUNIT_ADMIN_TOOL_NAME_0 = "GUI_OVERVIEWORGUNIT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OVERVIEWROLE_ADMIN_TOOL_HELP_0 = "GUI_OVERVIEWROLE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OVERVIEWROLE_ADMIN_TOOL_NAME_0 = "GUI_OVERVIEWROLE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OVERVIEWROLE_ADMIN_TOOL_NAVBARNAME_0 = "GUI_OVERVIEWROLE_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PARENTORGUNIT_ADMIN_TOOL_GROUP_0 = "GUI_PARENTORGUNIT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PARENTORGUNIT_ADMIN_TOOL_HELP_0 = "GUI_PARENTORGUNIT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PARENTORGUNIT_ADMIN_TOOL_NAME_0 = "GUI_PARENTORGUNIT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_OVERVIEW_LABEL_IDENTIFICATION_BLOCK_0 = "GUI_ROLE_OVERVIEW_LABEL_IDENTIFICATION_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_DETAIL_DESCRIPTION_NAME_0 = "GUI_ROLEEDIT_DETAIL_DESCRIPTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_DETAIL_HIDE_DESCRIPTION_HELP_0 = "GUI_ROLEEDIT_DETAIL_HIDE_DESCRIPTION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_DETAIL_HIDE_DESCRIPTION_NAME_0 = "GUI_ROLEEDIT_DETAIL_HIDE_DESCRIPTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_DETAIL_SHOW_DESCRIPTION_HELP_0 = "GUI_ROLEEDIT_DETAIL_SHOW_DESCRIPTION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_DETAIL_SHOW_DESCRIPTION_NAME_0 = "GUI_ROLEEDIT_DETAIL_SHOW_DESCRIPTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_ACTION_ACTIVATE_HELP_0 = "GUI_ROLEEDIT_LIST_ACTION_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_ACTION_ACTIVATE_NAME_0 = "GUI_ROLEEDIT_LIST_ACTION_ACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_ACTION_DEACTIVATE_HELP_0 = "GUI_ROLEEDIT_LIST_ACTION_DEACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_ACTION_DEACTIVATE_NAME_0 = "GUI_ROLEEDIT_LIST_ACTION_DEACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_ACTION_EDIT_NAME_0 = "GUI_ROLEEDIT_LIST_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_COLS_ACTIVATE_0 = "GUI_ROLEEDIT_LIST_COLS_ACTIVATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_COLS_ACTIVATE_HELP_0 = "GUI_ROLEEDIT_LIST_COLS_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_COLS_DEPENDENCY_0 = "GUI_ROLEEDIT_LIST_COLS_DEPENDENCY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_COLS_EDIT_0 = "GUI_ROLEEDIT_LIST_COLS_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_COLS_EDIT_HELP_0 = "GUI_ROLEEDIT_LIST_COLS_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_COLS_ICON_0 = "GUI_ROLEEDIT_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_COLS_ICON_HELP_0 = "GUI_ROLEEDIT_LIST_COLS_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_COLS_NAME_0 = "GUI_ROLEEDIT_LIST_COLS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_DEFACTION_OVERVIEW_HELP_0 = "GUI_ROLEEDIT_LIST_DEFACTION_OVERVIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_DEFACTION_OVERVIEW_NAME_0 = "GUI_ROLEEDIT_LIST_DEFACTION_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_ICON_HELP_0 = "GUI_ROLEEDIT_LIST_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_ICON_NAME_0 = "GUI_ROLEEDIT_LIST_ICON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_MACTION_ACTIVATE_HELP_0 = "GUI_ROLEEDIT_LIST_MACTION_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_MACTION_ACTIVATE_NAME_0 = "GUI_ROLEEDIT_LIST_MACTION_ACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_MACTION_DEACTIVATE_HELP_0 = "GUI_ROLEEDIT_LIST_MACTION_DEACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_MACTION_DEACTIVATE_NAME_0 = "GUI_ROLEEDIT_LIST_MACTION_DEACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEEDIT_LIST_NAME_0 = "GUI_ROLEEDIT_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_ADMIN_TOOL_GROUP_0 = "GUI_ROLES_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_ADMIN_TOOL_HELP_0 = "GUI_ROLES_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_ADMIN_TOOL_NAME_0 = "GUI_ROLES_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_ADMIN_TOOL_NAVBARNAME_0 = "GUI_ROLES_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_DESCRIPTION_NAME_0 = "GUI_ROLES_DETAIL_DESCRIPTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_HIDE_DESCRIPTION_HELP_0 = "GUI_ROLES_DETAIL_HIDE_DESCRIPTION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_HIDE_DESCRIPTION_NAME_0 = "GUI_ROLES_DETAIL_HIDE_DESCRIPTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_HIDE_PATH_HELP_0 = "GUI_ROLES_DETAIL_HIDE_PATH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_HIDE_PATH_NAME_0 = "GUI_ROLES_DETAIL_HIDE_PATH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_HIDE_USERS_HELP_0 = "GUI_ROLES_DETAIL_HIDE_USERS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_HIDE_USERS_NAME_0 = "GUI_ROLES_DETAIL_HIDE_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_PATH_NAME_0 = "GUI_ROLES_DETAIL_PATH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_SHOW_DESCRIPTION_HELP_0 = "GUI_ROLES_DETAIL_SHOW_DESCRIPTION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_SHOW_DESCRIPTION_NAME_0 = "GUI_ROLES_DETAIL_SHOW_DESCRIPTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_SHOW_PATH_HELP_0 = "GUI_ROLES_DETAIL_SHOW_PATH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_SHOW_PATH_NAME_0 = "GUI_ROLES_DETAIL_SHOW_PATH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_SHOW_USERS_HELP_0 = "GUI_ROLES_DETAIL_SHOW_USERS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_SHOW_USERS_NAME_0 = "GUI_ROLES_DETAIL_SHOW_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_DETAIL_USERS_NAME_0 = "GUI_ROLES_DETAIL_USERS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_LIST_COLS_DESCRIPTION_0 = "GUI_ROLES_LIST_COLS_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_LIST_COLS_ICON_0 = "GUI_ROLES_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_LIST_COLS_ICON_HELP_0 = "GUI_ROLES_LIST_COLS_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLES_LIST_COLS_NAME_0 = "GUI_ROLES_LIST_COLS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSER_ADMIN_TOOL_GROUP_0 = "GUI_ROLEUSER_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSER_ADMIN_TOOL_HELP_0 = "GUI_ROLEUSER_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSER_ADMIN_TOOL_NAME_0 = "GUI_ROLEUSER_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSER_ADMIN_TOOL_NAVBARNAME_0 = "GUI_ROLEUSER_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSERS_ADMIN_TOOL_GROUP_0 = "GUI_ROLEUSERS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSERS_ADMIN_TOOL_HELP_0 = "GUI_ROLEUSERS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSERS_ADMIN_TOOL_NAME_0 = "GUI_ROLEUSERS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSERS_ADMIN_TOOL_NAVBARNAME_0 = "GUI_ROLEUSERS_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSERS_EDIT_DISABLED_HELP_0 = "GUI_ROLEUSERS_EDIT_DISABLED_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSERS_LIST_DEFACTION_REMOVE_HELP_0 = "GUI_ROLEUSERS_LIST_DEFACTION_REMOVE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSERS_LIST_DISABLED_ACTION_HELP_0 = "GUI_ROLEUSERS_LIST_DISABLED_ACTION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLEUSERS_LIST_NAME_0 = "GUI_ROLEUSERS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SUBORGUNITS_LIST_NAME_0 = "GUI_SUBORGUNITS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_ADDINFO_ADMIN_TOOL_GROUP_0 = "GUI_USER_ADDINFO_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_ADDINFO_ADMIN_TOOL_HELP_0 = "GUI_USER_ADDINFO_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_ADDINFO_ADMIN_TOOL_NAME_0 = "GUI_USER_ADDINFO_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_ALLINFO_ADMIN_TOOL_GROUP_0 = "GUI_USER_ALLINFO_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_ALLINFO_ADMIN_TOOL_HELP_0 = "GUI_USER_ALLINFO_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_ALLINFO_ADMIN_TOOL_NAME_0 = "GUI_USER_ALLINFO_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_DELETE_0 = "GUI_USER_DEPENDENCIES_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_LIST_ACTION_ICON_HELP_0 = "GUI_USER_DEPENDENCIES_LIST_ACTION_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_LIST_ACTION_ICON_NAME_0 = "GUI_USER_DEPENDENCIES_LIST_ACTION_ICON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_LIST_COLS_CREATED_0 = "GUI_USER_DEPENDENCIES_LIST_COLS_CREATED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_LIST_COLS_ICON_0 = "GUI_USER_DEPENDENCIES_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_LIST_COLS_LASTMODIFIED_0 = "GUI_USER_DEPENDENCIES_LIST_COLS_LASTMODIFIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_LIST_COLS_NAME_0 = "GUI_USER_DEPENDENCIES_LIST_COLS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_LIST_COLS_PERMISSIONS_0 = "GUI_USER_DEPENDENCIES_LIST_COLS_PERMISSIONS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_LIST_NAME_0 = "GUI_USER_DEPENDENCIES_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_NOTICE_0 = "GUI_USER_DEPENDENCIES_NOTICE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_NOTICE_TEXT_0 = "GUI_USER_DEPENDENCIES_NOTICE_TEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_DEPENDENCIES_SELECTED_USERS_0 = "GUI_USER_DEPENDENCIES_SELECTED_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_EDITOR_LABEL_ADDITIONALINFO_BLOCK_0 = "GUI_USER_EDITOR_LABEL_ADDITIONALINFO_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_EDITOR_LABEL_ADDRESS_BLOCK_0 = "GUI_USER_EDITOR_LABEL_ADDRESS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_EDITOR_LABEL_AUTHENTIFICATION_BLOCK_0 = "GUI_USER_EDITOR_LABEL_AUTHENTIFICATION_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_EDITOR_LABEL_IDENTIFICATION_BLOCK_0 = "GUI_USER_EDITOR_LABEL_IDENTIFICATION_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_EDITOR_LABEL_READONLY_BLOCK_0 = "GUI_USER_EDITOR_LABEL_READONLY_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_EDITOR_LABEL_SELECTEDINFO_BLOCK_0 = "GUI_USER_EDITOR_LABEL_SELECTEDINFO_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_EDITOR_LABEL_SETTINGS_BLOCK_0 = "GUI_USER_EDITOR_LABEL_SETTINGS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_EDITOR_LABEL_STARTUPSETTINGS_BLOCK_0 = "GUI_USER_EDITOR_LABEL_STARTUPSETTINGS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_SENDEMAIL_ADMIN_TOOL_GROUP_0 = "GUI_USER_SENDEMAIL_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_SENDEMAIL_ADMIN_TOOL_HELP_0 = "GUI_USER_SENDEMAIL_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USER_SENDEMAIL_ADMIN_TOOL_NAME_0 = "GUI_USER_SENDEMAIL_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERDATA_DOWNLOAD_LABEL_HINT_CLICK_0 = "GUI_USERDATA_DOWNLOAD_LABEL_HINT_CLICK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERDATA_DOWNLOAD_LABEL_HINT_TEXT_0 = "GUI_USERDATA_DOWNLOAD_LABEL_HINT_TEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERDATA_EXPORT_LABEL_GROUPS_BLOCK_0 = "GUI_USERDATA_EXPORT_LABEL_GROUPS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERDATA_EXPORT_LABEL_HINT_BLOCK_0 = "GUI_USERDATA_EXPORT_LABEL_HINT_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERDATA_EXPORT_LABEL_HINT_TEXT_0 = "GUI_USERDATA_EXPORT_LABEL_HINT_TEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERDATA_EXPORT_LABEL_ROLES_BLOCK_0 = "GUI_USERDATA_EXPORT_LABEL_ROLES_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERDATA_IMPORT_LABEL_DATA_BLOCK_0 = "GUI_USERDATA_IMPORT_LABEL_DATA_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERDATA_IMPORT_LABEL_HINT_BLOCK_0 = "GUI_USERDATA_IMPORT_LABEL_HINT_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERDATA_IMPORT_LABEL_HINT_TEXT_0 = "GUI_USERDATA_IMPORT_LABEL_HINT_TEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERGROUPS_LIST_ACTION_STATE_DISABLED_HELP_0 = "GUI_USERGROUPS_LIST_ACTION_STATE_DISABLED_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERGROUPS_LIST_ACTION_STATE_DISABLED_NAME_0 = "GUI_USERGROUPS_LIST_ACTION_STATE_DISABLED_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERGROUPS_LIST_NAME_0 = "GUI_USERGROUPS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERROLES_LIST_NAME_0 = "GUI_USERROLES_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_ADMIN_TOOL_GROUP_0 = "GUI_USERS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_ADMIN_TOOL_HELP_0 = "GUI_USERS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_ADMIN_TOOL_NAME_0 = "GUI_USERS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_ADMIN_TOOL_NAVBARNAME_0 = "GUI_USERS_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DELETE_ADMIN_TOOL_GROUP_0 = "GUI_USERS_DELETE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DELETE_ADMIN_TOOL_HELP_0 = "GUI_USERS_DELETE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DELETE_ADMIN_TOOL_NAME_0 = "GUI_USERS_DELETE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_ADDRESS_NAME_0 = "GUI_USERS_DETAIL_ADDRESS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_GROUPS_NAME_0 = "GUI_USERS_DETAIL_GROUPS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_ADDRESS_HELP_0 = "GUI_USERS_DETAIL_HIDE_ADDRESS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_ADDRESS_NAME_0 = "GUI_USERS_DETAIL_HIDE_ADDRESS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_GROUPS_HELP_0 = "GUI_USERS_DETAIL_HIDE_GROUPS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_GROUPS_NAME_0 = "GUI_USERS_DETAIL_HIDE_GROUPS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_ORGUNIT_DESC_HELP_0 = "GUI_USERS_DETAIL_HIDE_ORGUNIT_DESC_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_ORGUNIT_DESC_NAME_0 = "GUI_USERS_DETAIL_HIDE_ORGUNIT_DESC_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_ORGUNIT_HELP_0 = "GUI_USERS_DETAIL_HIDE_ORGUNIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_ORGUNIT_NAME_0 = "GUI_USERS_DETAIL_HIDE_ORGUNIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_OTHEROU_HELP_0 = "GUI_USERS_DETAIL_HIDE_OTHEROU_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_OTHEROU_NAME_0 = "GUI_USERS_DETAIL_HIDE_OTHEROU_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_ROLES_HELP_0 = "GUI_USERS_DETAIL_HIDE_ROLES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_HIDE_ROLES_NAME_0 = "GUI_USERS_DETAIL_HIDE_ROLES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_ORGUNIT_DESC_NAME_0 = "GUI_USERS_DETAIL_ORGUNIT_DESC_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_ORGUNIT_NAME_0 = "GUI_USERS_DETAIL_ORGUNIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_OTHEROU_NAME_0 = "GUI_USERS_DETAIL_OTHEROU_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_ROLES_NAME_0 = "GUI_USERS_DETAIL_ROLES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_ADDRESS_HELP_0 = "GUI_USERS_DETAIL_SHOW_ADDRESS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_ADDRESS_NAME_0 = "GUI_USERS_DETAIL_SHOW_ADDRESS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_GROUPS_HELP_0 = "GUI_USERS_DETAIL_SHOW_GROUPS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_GROUPS_NAME_0 = "GUI_USERS_DETAIL_SHOW_GROUPS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_ORGUNIT_DESC_HELP_0 = "GUI_USERS_DETAIL_SHOW_ORGUNIT_DESC_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_ORGUNIT_DESC_NAME_0 = "GUI_USERS_DETAIL_SHOW_ORGUNIT_DESC_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_ORGUNIT_HELP_0 = "GUI_USERS_DETAIL_SHOW_ORGUNIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_ORGUNIT_NAME_0 = "GUI_USERS_DETAIL_SHOW_ORGUNIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_OTHEROU_HELP_0 = "GUI_USERS_DETAIL_SHOW_OTHEROU_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_OTHEROU_NAME_0 = "GUI_USERS_DETAIL_SHOW_OTHEROU_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_ROLES_HELP_0 = "GUI_USERS_DETAIL_SHOW_ROLES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_DETAIL_SHOW_ROLES_NAME_0 = "GUI_USERS_DETAIL_SHOW_ROLES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_ACTIVATE_CONF_0 = "GUI_USERS_LIST_ACTION_ACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_ACTIVATE_HELP_0 = "GUI_USERS_LIST_ACTION_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_ACTIVATE_NAME_0 = "GUI_USERS_LIST_ACTION_ACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_DEACTIVATE_CONF_0 = "GUI_USERS_LIST_ACTION_DEACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_DEACTIVATE_HELP_0 = "GUI_USERS_LIST_ACTION_DEACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_DEACTIVATE_NAME_0 = "GUI_USERS_LIST_ACTION_DEACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_DELETE_HELP_0 = "GUI_USERS_LIST_ACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_DELETE_NAME_0 = "GUI_USERS_LIST_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_EDIT_HELP_0 = "GUI_USERS_LIST_ACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_EDIT_NAME_0 = "GUI_USERS_LIST_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_GROUPS_HELP_0 = "GUI_USERS_LIST_ACTION_GROUPS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_GROUPS_NAME_0 = "GUI_USERS_LIST_ACTION_GROUPS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_ROLE_HELP_0 = "GUI_USERS_LIST_ACTION_ROLE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_ROLE_NAME_0 = "GUI_USERS_LIST_ACTION_ROLE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_SWITCH_CONF_0 = "GUI_USERS_LIST_ACTION_SWITCH_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_SWITCH_HELP_0 = "GUI_USERS_LIST_ACTION_SWITCH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_ACTION_SWITCH_NAME_0 = "GUI_USERS_LIST_ACTION_SWITCH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_AVAILABLE_HELP_0 = "GUI_USERS_LIST_AVAILABLE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_AVAILABLE_NAME_0 = "GUI_USERS_LIST_AVAILABLE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_ACTIVATE_0 = "GUI_USERS_LIST_COLS_ACTIVATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_ACTIVATE_HELP_0 = "GUI_USERS_LIST_COLS_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_DELETE_0 = "GUI_USERS_LIST_COLS_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_DELETE_HELP_0 = "GUI_USERS_LIST_COLS_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_EDIT_0 = "GUI_USERS_LIST_COLS_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_EDIT_HELP_0 = "GUI_USERS_LIST_COLS_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_EMAIL_0 = "GUI_USERS_LIST_COLS_EMAIL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_FULLNAME_0 = "GUI_USERS_LIST_COLS_FULLNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_GROUPS_0 = "GUI_USERS_LIST_COLS_GROUPS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_GROUPS_HELP_0 = "GUI_USERS_LIST_COLS_GROUPS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_ICON_0 = "GUI_USERS_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_ICON_HELP_0 = "GUI_USERS_LIST_COLS_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_LASTLOGIN_0 = "GUI_USERS_LIST_COLS_LASTLOGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_LOGIN_0 = "GUI_USERS_LIST_COLS_LOGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_ORGUNIT_0 = "GUI_USERS_LIST_COLS_ORGUNIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_ROLE_0 = "GUI_USERS_LIST_COLS_ROLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_ROLE_HELP_0 = "GUI_USERS_LIST_COLS_ROLE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_STATE_0 = "GUI_USERS_LIST_COLS_STATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_STATE_HELP_0 = "GUI_USERS_LIST_COLS_STATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_SWITCH_0 = "GUI_USERS_LIST_COLS_SWITCH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_SWITCH_HELP_0 = "GUI_USERS_LIST_COLS_SWITCH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_COLS_USERNAME_0 = "GUI_USERS_LIST_COLS_USERNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_DEFACTION_ADD_HELP_0 = "GUI_USERS_LIST_DEFACTION_ADD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_DEFACTION_ADD_NAME_0 = "GUI_USERS_LIST_DEFACTION_ADD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_DEFACTION_EDIT_HELP_0 = "GUI_USERS_LIST_DEFACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_DEFACTION_EDIT_NAME_0 = "GUI_USERS_LIST_DEFACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_DEFACTION_REMOVE_HELP_0 = "GUI_USERS_LIST_DEFACTION_REMOVE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_DEFACTION_REMOVE_NAME_0 = "GUI_USERS_LIST_DEFACTION_REMOVE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_INGROUP_HELP_0 = "GUI_USERS_LIST_INGROUP_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_INGROUP_NAME_0 = "GUI_USERS_LIST_INGROUP_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_INROLE_HELP_0 = "GUI_USERS_LIST_INROLE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_INROLE_INDIRECT_HELP_0 = "GUI_USERS_LIST_INROLE_INDIRECT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_INROLE_INDIRECT_NAME_0 = "GUI_USERS_LIST_INROLE_INDIRECT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_INROLE_NAME_0 = "GUI_USERS_LIST_INROLE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_INROLE_OTHEROU_HELP_0 = "GUI_USERS_LIST_INROLE_OTHEROU_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_INROLE_OTHEROU_NAME_0 = "GUI_USERS_LIST_INROLE_OTHEROU_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_ACTIVATE_CONF_0 = "GUI_USERS_LIST_MACTION_ACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_ACTIVATE_HELP_0 = "GUI_USERS_LIST_MACTION_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_ACTIVATE_NAME_0 = "GUI_USERS_LIST_MACTION_ACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_ADD_CONF_0 = "GUI_USERS_LIST_MACTION_ADD_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_ADD_HELP_0 = "GUI_USERS_LIST_MACTION_ADD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_ADD_NAME_0 = "GUI_USERS_LIST_MACTION_ADD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_DEACTIVATE_CONF_0 = "GUI_USERS_LIST_MACTION_DEACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_DEACTIVATE_HELP_0 = "GUI_USERS_LIST_MACTION_DEACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_DEACTIVATE_NAME_0 = "GUI_USERS_LIST_MACTION_DEACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_DELETE_CONF_0 = "GUI_USERS_LIST_MACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_DELETE_HELP_0 = "GUI_USERS_LIST_MACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_DELETE_NAME_0 = "GUI_USERS_LIST_MACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_REMOVE_CONF_0 = "GUI_USERS_LIST_MACTION_REMOVE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_REMOVE_HELP_0 = "GUI_USERS_LIST_MACTION_REMOVE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_MACTION_REMOVE_NAME_0 = "GUI_USERS_LIST_MACTION_REMOVE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_LIST_NAME_0 = "GUI_USERS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_TRANSFER_LIST_ACTION_TRANSFER_HELP_0 = "GUI_USERS_TRANSFER_LIST_ACTION_TRANSFER_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_TRANSFER_LIST_ACTION_TRANSFER_NAME_0 = "GUI_USERS_TRANSFER_LIST_ACTION_TRANSFER_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_TRANSFER_LIST_COLS_TRANSFER_0 = "GUI_USERS_TRANSFER_LIST_COLS_TRANSFER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_TRANSFER_LIST_COLS_TRANSFER_HELP_0 = "GUI_USERS_TRANSFER_LIST_COLS_TRANSFER_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_TRANSFER_LIST_DEFACTION_TRANSFER_HELP_0 = "GUI_USERS_TRANSFER_LIST_DEFACTION_TRANSFER_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_TRANSFER_LIST_DEFACTION_TRANSFER_NAME_0 = "GUI_USERS_TRANSFER_LIST_DEFACTION_TRANSFER_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_TRANSFER_LIST_NAME_0 = "GUI_USERS_TRANSFER_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_TRANSFER_NOTICE_0 = "GUI_USERS_TRANSFER_NOTICE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERS_TRANSFER_NOTICE_TEXT_0 = "GUI_USERS_TRANSFER_NOTICE_TEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERSORGUNIT_ADMIN_TOOL_GROUP_0 = "GUI_USERSORGUNIT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERSORGUNIT_ADMIN_TOOL_HELP_0 = "GUI_USERSORGUNIT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_USERSORGUNIT_ADMIN_TOOL_NAME_0 = "GUI_USERSORGUNIT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_VIRTUAL_GROUP_DISABLED_EDITION_HELP_0 = "GUI_VIRTUAL_GROUP_DISABLED_EDITION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_WEBOUS_LIST_ACTION_OVERVIEW_NAME_0 = "GUI_WEBOUS_LIST_ACTION_OVERVIEW_NAME_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.accounts.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }

}