/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/cache/Messages.java,v $
 * Date   : $Date: 2008-04-17 13:49:13 $
 * Version: $Revision: 1.8 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.cache;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Jan Baudisch 
 * 
 * @version $Revision: 1.8 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CACHE_ADMIN_TOOL_GROUP_0 = "GUI_CACHE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CACHE_ADMIN_TOOL_HELP_0 = "GUI_CACHE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CACHE_ADMIN_TOOL_NAME_0 = "GUI_CACHE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CORECACHE_CLEAN_ADMIN_TOOL_CONF_0 = "GUI_CORECACHE_CLEAN_ADMIN_TOOL_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CORECACHE_CLEAN_ADMIN_TOOL_GROUP_0 = "GUI_CORECACHE_CLEAN_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CORECACHE_CLEAN_ADMIN_TOOL_HELP_0 = "GUI_CORECACHE_CLEAN_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CORECACHE_CLEAN_ADMIN_TOOL_NAME_0 = "GUI_CORECACHE_CLEAN_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_ADMIN_TOOL_GROUP_0 = "GUI_FLEXCACHE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_ADMIN_TOOL_HELP_0 = "GUI_FLEXCACHE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_ADMIN_TOOL_NAME_0 = "GUI_FLEXCACHE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_CLEAN_ADMIN_TOOL_GROUP_0 = "GUI_FLEXCACHE_CLEAN_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_CLEAN_ADMIN_TOOL_HELP_0 = "GUI_FLEXCACHE_CLEAN_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_CLEAN_ADMIN_TOOL_NAME_0 = "GUI_FLEXCACHE_CLEAN_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_CLEAN_MODE_ALL_0 = "GUI_FLEXCACHE_CLEAN_MODE_ALL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_CLEAN_MODE_VARIATIONS_0 = "GUI_FLEXCACHE_CLEAN_MODE_VARIATIONS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_DETAIL_HIDE_VARIATIONS_HELP_0 = "GUI_FLEXCACHE_DETAIL_HIDE_VARIATIONS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_DETAIL_HIDE_VARIATIONS_NAME_0 = "GUI_FLEXCACHE_DETAIL_HIDE_VARIATIONS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_DETAIL_SHOW_VARIATIONS_HELP_0 = "GUI_FLEXCACHE_DETAIL_SHOW_VARIATIONS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_DETAIL_SHOW_VARIATIONS_NAME_0 = "GUI_FLEXCACHE_DETAIL_SHOW_VARIATIONS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_DETAIL_VARIATIONS_NAME_0 = "GUI_FLEXCACHE_DETAIL_VARIATIONS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_LABEL_CLEAN_BLOCK_0 = "GUI_FLEXCACHE_LABEL_CLEAN_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_LABEL_MEMORY_BLOCK_0 = "GUI_FLEXCACHE_LABEL_MEMORY_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_LABEL_STATS_BLOCK_0 = "GUI_FLEXCACHE_LABEL_STATS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_LIST_ACTION_ICON_NAME_0 = "GUI_FLEXCACHE_LIST_ACTION_ICON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_LIST_COLS_ICON_0 = "GUI_FLEXCACHE_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_LIST_COLS_KEY_0 = "GUI_FLEXCACHE_LIST_COLS_KEY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_LIST_COLS_PROJECT_0 = "GUI_FLEXCACHE_LIST_COLS_PROJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_LIST_COLS_RESOURCE_0 = "GUI_FLEXCACHE_LIST_COLS_RESOURCE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_FLEXCACHE_LIST_NAME_0 = "GUI_FLEXCACHE_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_ADMIN_TOOL_GROUP_0 = "GUI_IMAGECACHE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_ADMIN_TOOL_HELP_0 = "GUI_IMAGECACHE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_ADMIN_TOOL_NAME_0 = "GUI_IMAGECACHE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_CLEAN_ADMIN_TOOL_GROUP_0 = "GUI_IMAGECACHE_CLEAN_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_CLEAN_ADMIN_TOOL_HELP_0 = "GUI_IMAGECACHE_CLEAN_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_CLEAN_ADMIN_TOOL_NAME_0 = "GUI_IMAGECACHE_CLEAN_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_HIDE_SIZE_HELP_0 = "GUI_IMAGECACHE_DETAIL_HIDE_SIZE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_HIDE_SIZE_NAME_0 = "GUI_IMAGECACHE_DETAIL_HIDE_SIZE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_HIDE_VARIATIONS_HELP_0 = "GUI_IMAGECACHE_DETAIL_HIDE_VARIATIONS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_HIDE_VARIATIONS_NAME_0 = "GUI_IMAGECACHE_DETAIL_HIDE_VARIATIONS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_SHOW_SIZE_HELP_0 = "GUI_IMAGECACHE_DETAIL_SHOW_SIZE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_SHOW_SIZE_NAME_0 = "GUI_IMAGECACHE_DETAIL_SHOW_SIZE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_SHOW_VARIATIONS_HELP_0 = "GUI_IMAGECACHE_DETAIL_SHOW_VARIATIONS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_SHOW_VARIATIONS_NAME_0 = "GUI_IMAGECACHE_DETAIL_SHOW_VARIATIONS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_SIZE_NAME_0 = "GUI_IMAGECACHE_DETAIL_SIZE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_DETAIL_VARIATIONS_NAME_0 = "GUI_IMAGECACHE_DETAIL_VARIATIONS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_LABEL_CLEAN_BLOCK_0 = "GUI_IMAGECACHE_LABEL_CLEAN_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_LABEL_MEMORY_BLOCK_0 = "GUI_IMAGECACHE_LABEL_MEMORY_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_LABEL_STATS_BLOCK_0 = "GUI_IMAGECACHE_LABEL_STATS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_LIST_ACTION_ICON_NAME_0 = "GUI_IMAGECACHE_LIST_ACTION_ICON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_LIST_COLS_ICON_0 = "GUI_IMAGECACHE_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_LIST_COLS_LENGTH_0 = "GUI_IMAGECACHE_LIST_COLS_LENGTH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_LIST_COLS_RESOURCE_0 = "GUI_IMAGECACHE_LIST_COLS_RESOURCE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_LIST_COLS_SIZE_0 = "GUI_IMAGECACHE_LIST_COLS_SIZE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMAGECACHE_LIST_NAME_0 = "GUI_IMAGECACHE_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JSP_REPOSITORY_ADMIN_TOOL_CONF_0 = "GUI_JSP_REPOSITORY_ADMIN_TOOL_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JSP_REPOSITORY_ADMIN_TOOL_GROUP_0 = "GUI_JSP_REPOSITORY_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JSP_REPOSITORY_ADMIN_TOOL_HELP_0 = "GUI_JSP_REPOSITORY_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JSP_REPOSITORY_ADMIN_TOOL_NAME_0 = "GUI_JSP_REPOSITORY_ADMIN_TOOL_NAME_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.cache.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}