/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/content/check/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:42 $
 * Version: $Revision: 1.4 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.content.check;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Michael Emmerich
 * 
 * @version $Revision: 1.4 $ 
 * 
 * @since 6.1.2 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CHECK_CONTAINS_FILENAME_2 = "ERR_CHECK_CONTAINS_FILENAME_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CHECK_MATCH_3 = "ERR_CHECK_MATCH_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CHECK_NO_PROPERTYNAME_1 = "ERR_CHECK_NO_PROPERTYNAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CHECK_TOO_SHORT_3 = "ERR_CHECK_TOO_SHORT_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_TEST_0 = "ERR_NO_TEST_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_VFSPATH_0 = "ERR_NO_VFSPATH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_CONFIGURATION_PROPERTY_HELP_0 = "GUI_CHECKCONTENT_CONFIGURATION_PROPERTY_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_DETAIL_HIDE_ERRORINFO_HELP_0 = "GUI_CHECKCONTENT_DETAIL_HIDE_ERRORINFO_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_DETAIL_HIDE_ERRORINFO_NAME_0 = "GUI_CHECKCONTENT_DETAIL_HIDE_ERRORINFO_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_DETAIL_HIDE_WARNINGINFO_HELP_0 = "GUI_CHECKCONTENT_DETAIL_HIDE_WARNINGINFO_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_DETAIL_HIDE_WARNINGINFO_NAME_0 = "GUI_CHECKCONTENT_DETAIL_HIDE_WARNINGINFO_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_DETAIL_SHOW_ERRORINFO_HELP_0 = "GUI_CHECKCONTENT_DETAIL_SHOW_ERRORINFO_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_DETAIL_SHOW_ERRORINFO_NAME_0 = "GUI_CHECKCONTENT_DETAIL_SHOW_ERRORINFO_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_DETAIL_SHOW_WARNINGINFO_HELP_0 = "GUI_CHECKCONTENT_DETAIL_SHOW_WARNINGINFO_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_DETAIL_SHOW_WARNINGINFO_NAME_0 = "GUI_CHECKCONTENT_DETAIL_SHOW_WARNINGINFO_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_LABEL_ERROR_0 = "GUI_CHECKCONTENT_LABEL_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_LABEL_WARNING_0 = "GUI_CHECKCONTENT_LABEL_WARNING_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CHECKCONTENT_LIST_NAME_0 = "GUI_CHECKCONTENT_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CANNOT_CREATE_PLUGIN_1 = "LOG_CANNOT_CREATE_PLUGIN_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CANNOT_CREATE_PLUGIN_2 = "LOG_CANNOT_CREATE_PLUGIN_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_PLUGIN_1 = "LOG_CREATE_PLUGIN_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_CHECKLENGTH_2 = "LOG_DEBUG_PROPERTY_CHECKLENGTH_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_CONFIG_FILE_1 = "LOG_DEBUG_PROPERTY_CONFIG_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_CONFIG_FILENAME_1 = "LOG_DEBUG_PROPERTY_CONFIG_FILENAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_CONFIG_PROPERTY_3 = "LOG_DEBUG_PROPERTY_CONFIG_PROPERTY_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_CONFIG_XPATH_2 = "LOG_DEBUG_PROPERTY_CONFIG_XPATH_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_CONFIGURED_ERRORS_2 = "LOG_DEBUG_PROPERTY_CONFIGURED_ERRORS_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_CONFIGURED_WARNINGS_2 = "LOG_DEBUG_PROPERTY_CONFIGURED_WARNINGS_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_ISEMPTYCHECK_1 = "LOG_DEBUG_PROPERTY_ISEMPTYCHECK_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_ISFILENAME_1 = "LOG_DEBUG_PROPERTY_ISFILENAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_MATCHPATTERN_2 = "LOG_DEBUG_PROPERTY_MATCHPATTERN_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_PROPERTY_1 = "LOG_DEBUG_PROPERTY_PROPERTY_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_RESOURCE_1 = "LOG_DEBUG_PROPERTY_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEBUG_PROPERTY_VALUE_1 = "LOG_DEBUG_PROPERTY_VALUE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ERROR_PROCESSING_PROPERTIES_2 = "LOG_ERROR_PROCESSING_PROPERTIES_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_CHECK_BEGIN_0 = "RPT_CONTENT_CHECK_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_CHECK_END_0 = "RPT_CONTENT_CHECK_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_COLLECT_BEGIN_0 = "RPT_CONTENT_COLLECT_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_COLLECT_END_1 = "RPT_CONTENT_COLLECT_END_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_PROCESS_2 = "RPT_CONTENT_PROCESS_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_PROCESS_BEGIN_0 = "RPT_CONTENT_PROCESS_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_PROCESS_END_0 = "RPT_CONTENT_PROCESS_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_PROCESS_ERROR_0 = "RPT_CONTENT_PROCESS_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_PROCESS_ERROR_1 = "RPT_CONTENT_PROCESS_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_PROCESS_ERROR_2 = "RPT_CONTENT_PROCESS_ERROR_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_PROCESS_RESOURCE_1 = "RPT_CONTENT_PROCESS_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_PROCESS_WARNING_0 = "RPT_CONTENT_PROCESS_WARNING_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONTENT_PROCESS_WARNING_1 = "RPT_CONTENT_PROCESS_WARNING_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EMPTY_0 = "RPT_EMPTY_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXTRACT_FROM_PATH_1 = "RPT_EXTRACT_FROM_PATH_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXTRACT_FROM_PATH_BEGIN_1 = "RPT_EXTRACT_FROM_PATH_BEGIN_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXTRACT_FROM_PATH_END_0 = "RPT_EXTRACT_FROM_PATH_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXTRACT_FROM_PATH_ERROR_2 = "RPT_EXTRACT_FROM_PATH_ERROR_2";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.content.check.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}