/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/database/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:51 $
 * Version: $Revision: 1.20 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.database;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Andreas Zahner 
 * 
 * @version $Revision: 1.20 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_FILE_EXPORT_0 = "ERR_ACTION_FILE_EXPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_FILE_UPLOAD_1 = "ERR_ACTION_FILE_UPLOAD_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_ZIPFILE_UPLOAD_0 = "ERR_ACTION_ZIPFILE_UPLOAD_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_FILE_NOT_FOUND_1 = "ERR_FILE_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_FILE_NOT_SPECIFIED_0 = "ERR_FILE_NOT_SPECIFIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_FILE_NOT_WRITTEN_0 = "ERR_FILE_NOT_WRITTEN_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_FOLDER_NOT_CREATED_0 = "ERR_FOLDER_NOT_CREATED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_GET_FILE_BYTES_1 = "ERR_GET_FILE_BYTES_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_HTMLIMPORT_PARSE_1 = "ERR_HTMLIMPORT_PARSE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ZIPFILE_READ_1 = "ERR_ZIPFILE_READ_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ZIPFILE_UNZIP_1 = "ERR_ZIPFILE_UNZIP_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_BUTTON_SEARCH_0 = "GUI_BUTTON_SEARCH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DATABASE_ADMIN_TOOL_GROUP_0 = "GUI_DATABASE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DATABASE_ADMIN_TOOL_HELP_0 = "GUI_DATABASE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DATABASE_ADMIN_TOOL_NAME_0 = "GUI_DATABASE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DATABASE_EXPORT_FILE_BLOCK_0 = "GUI_DATABASE_EXPORT_FILE_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DATABASE_EXPORT_RESOURCES_BLOCK_0 = "GUI_DATABASE_EXPORT_RESOURCES_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DATABASE_EXPORT_SETTINGS_BLOCK_0 = "GUI_DATABASE_EXPORT_SETTINGS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DATABASE_EXPORT_TYPES_BLOCK_0 = "GUI_DATABASE_EXPORT_TYPES_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DATABASE_IMPORT_BLOCK_0 = "GUI_DATABASE_IMPORT_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DATABASE_IMPORT_FILE_0 = "GUI_DATABASE_IMPORT_FILE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DB_PUBLOCKS_ADMIN_TOOL_HELP_0 = "GUI_DB_PUBLOCKS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DB_PUBLOCKS_ADMIN_TOOL_NAME_0 = "GUI_DB_PUBLOCKS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DB_PUBLOCKS_NOTICE_0 = "GUI_DB_PUBLOCKS_NOTICE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DB_PUBLOCKS_THREAD_NAME_0 = "GUI_DB_PUBLOCKS_THREAD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_HELP_EXPORTFILE_1 = "GUI_EDITOR_HELP_EXPORTFILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTSERVER_ADMIN_TOOL_HELP_0 = "GUI_EXPORTSERVER_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTSERVER_ADMIN_TOOL_NAME_0 = "GUI_EXPORTSERVER_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXTENDEDTOOLS_ADMIN_TOOL_GROUP_0 = "GUI_EXTENDEDTOOLS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLDEFAULT_ADMIN_TOOL_HELP_0 = "GUI_HTMLDEFAULT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLDEFAULT_ADMIN_TOOL_NAME_0 = "GUI_HTMLDEFAULT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_ADMIN_TOOL_HELP_0 = "GUI_HTMLIMPORT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_ADMIN_TOOL_NAME_0 = "GUI_HTMLIMPORT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_BLOCK_LABEL_FOLDER_0 = "GUI_HTMLIMPORT_BLOCK_LABEL_FOLDER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_BLOCK_LABEL_GALLERY_0 = "GUI_HTMLIMPORT_BLOCK_LABEL_GALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_BLOCK_LABEL_SETTINGS_0 = "GUI_HTMLIMPORT_BLOCK_LABEL_SETTINGS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_CONSTRAINT_OFFLINE_0 = "GUI_HTMLIMPORT_CONSTRAINT_OFFLINE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_DESTDIR_1 = "GUI_HTMLIMPORT_DESTDIR_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_DIALOG_TITLE_0 = "GUI_HTMLIMPORT_DIALOG_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_DOWNGALLERY_1 = "GUI_HTMLIMPORT_DOWNGALLERY_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_DOWNGALLERY_INVALID_1 = "GUI_HTMLIMPORT_DOWNGALLERY_INVALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_IMGGALLERY_1 = "GUI_HTMLIMPORT_IMGGALLERY_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_IMGGALLERY_INVALID_1 = "GUI_HTMLIMPORT_IMGGALLERY_INVALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_INPUTDIR_1 = "GUI_HTMLIMPORT_INPUTDIR_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_INVALID_ELEM_2 = "GUI_HTMLIMPORT_INVALID_ELEM_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_LINKGALLERY_1 = "GUI_HTMLIMPORT_LINKGALLERY_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_LINKGALLERY_INVALID_1 = "GUI_HTMLIMPORT_LINKGALLERY_INVALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_HTMLIMPORT_TEMPLATE_1 = "GUI_HTMLIMPORT_TEMPLATE_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTEXPORT_ADMIN_TOOL_GROUP_0 = "GUI_IMPORTEXPORT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTHTTP_ADMIN_TOOL_HELP_0 = "GUI_IMPORTHTTP_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTHTTP_ADMIN_TOOL_NAME_0 = "GUI_IMPORTHTTP_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTSERVER_ADMIN_TOOL_HELP_0 = "GUI_IMPORTSERVER_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTSERVER_ADMIN_TOOL_NAME_0 = "GUI_IMPORTSERVER_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTSERVER_NO_DB_EXPORTS_0 = "GUI_IMPORTSERVER_NO_DB_EXPORTS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MESSAGEBOX_STATICEXPORT1_0 = "GUI_MESSAGEBOX_STATICEXPORT1_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_STATEXP_ADMIN_TOOL_HELP_0 = "GUI_STATEXP_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_STATEXP_ADMIN_TOOL_NAME_0 = "GUI_STATEXP_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_STATEXP_THREAD_NAME_0 = "GUI_STATEXP_THREAD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_STATICEXPORT_0 = "GUI_TITLE_STATICEXPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_HTMLIMPORT_CONVERSION_ERROR_0 = "LOG_HTMLIMPORT_CONVERSION_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_HTMLIMPORT_CONVERSION_ERROR_1 = "LOG_HTMLIMPORT_CONVERSION_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_ARROW_RIGHT_0 = "RPT_ARROW_RIGHT_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CREATE_EXTERNAL_LINK_0 = "RPT_CREATE_EXTERNAL_LINK_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CREATE_FILE_0 = "RPT_CREATE_FILE_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CREATE_FOLDER_0 = "RPT_CREATE_FOLDER_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CREATE_INDEX_0 = "RPT_CREATE_INDEX_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DB_PUBLOCKS_BEGIN_0 = "RPT_DB_PUBLOCKS_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DB_PUBLOCKS_END_0 = "RPT_DB_PUBLOCKS_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DB_PUBLOCKS_FAILED_0 = "RPT_DB_PUBLOCKS_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DB_PUBLOCKS_READLOCKS_1 = "RPT_DB_PUBLOCKS_READLOCKS_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DB_PUBLOCKS_UNLOCKING_1 = "RPT_DB_PUBLOCKS_UNLOCKING_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTML_DELETE_0 = "RPT_HTML_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTML_IMPORT_BEGIN_0 = "RPT_HTML_IMPORT_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTML_IMPORT_END_0 = "RPT_HTML_IMPORT_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_HTML_UNZIP_0 = "RPT_HTML_UNZIP_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_0 = "RPT_IMPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_OVERWRITE_0 = "RPT_OVERWRITE_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_SKIP_EXTERNAL_0 = "RPT_SKIP_EXTERNAL_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.database.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}