/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/history/CmsHistoryClear.java,v $
 * Date   : $Date: 2008-02-27 12:05:33 $
 * Version: $Revision: 1.4 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.history;

import org.opencms.main.OpenCms;

/**
 * Bean to store the entries made by the user in the History Clear form in the
 * administration view.<p>
 * 
 * @author Peter Bonrad
 * 
 * @version $Revision: 1.4 $ 
 * 
 * @since 6.9.1
 */
public class CmsHistoryClear {

    /** Flag if to clear the versions of the deleted resources too. */
    private boolean m_clearDeleted;

    /** The date versions older than will be cleared. */
    private long m_clearOlderThan;

    /** Number of versions to keep. */
    private int m_keepVersions;

    /**
     * Default constructor initializing values.<p>
     */
    public CmsHistoryClear() {

        m_keepVersions = OpenCms.getSystemInfo().getHistoryVersions();
        m_clearDeleted = true;
    }

    /**
     * Returns the date versions older than will be cleared.<p>
     *
     * @return the date versions older than will be cleared
     */
    public long getClearOlderThan() {

        return m_clearOlderThan;
    }

    /**
     * Returns the number of versions to keep.<p>
     *
     * @return the number of versions to keep
     */
    public int getKeepVersions() {

        return m_keepVersions;
    }

    /**
     * Returns if to clear the versions of the deleted resources.<p>
     *
     * @return true if to clear the versions of the deleted resources
     */
    public boolean isClearDeleted() {

        return m_clearDeleted;
    }

    /**
     * Sets if to clear the versions of the deleted resources.<p>
     *
     * @param clearDeleted if to clear the versions of the deleted resources
     */
    public void setClearDeleted(boolean clearDeleted) {

        m_clearDeleted = clearDeleted;
    }

    /**
     * Sets the date versions older than will be cleared.<p>
     *
     * @param clearOlderThan the date versions older than will be cleared
     */
    public void setClearOlderThan(long clearOlderThan) {

        m_clearOlderThan = clearOlderThan;
    }

    /**
     * Sets the number of versions to keep.<p>
     *
     * @param keepVersions the number of versions to keep
     */
    public void setKeepVersions(int keepVersions) {

        m_keepVersions = keepVersions;
    }
}
