/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/modules/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:32 $
 * Version: $Revision: 1.18 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.modules;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @version $Revision: 1.18 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_DEPENDENCIES_DELETE_2 = "ERR_ACTION_DEPENDENCIES_DELETE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_EXPORTPOINTS_DELETE_2 = "ERR_ACTION_EXPORTPOINTS_DELETE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_MODULE_DELETE_1 = "ERR_ACTION_MODULE_DELETE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_MODULE_DEPENDENCY_2 = "ERR_ACTION_MODULE_DEPENDENCY_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_MODULE_EDIT_1 = "ERR_ACTION_MODULE_EDIT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_MODULE_EXPORT_1 = "ERR_ACTION_MODULE_EXPORT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_MODULE_UPLOAD_1 = "ERR_ACTION_MODULE_UPLOAD_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ACTION_MODULES_DELETE_1 = "ERR_ACTION_MODULES_DELETE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_RESOURCE_1 = "ERR_READ_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETEDEPENDENCIES_ADMIN_TOOL_HELP_0 = "GUI_DELETEDEPENDENCIES_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETEDEPENDENCIES_ADMIN_TOOL_NAME_0 = "GUI_DELETEDEPENDENCIES_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETEEXPORTPOINTS_ADMIN_TOOL_HELP_0 = "GUI_DELETEEXPORTPOINTS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETEEXPORTPOINTS_ADMIN_TOOL_NAME_0 = "GUI_DELETEEXPORTPOINTS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETEMODULE_ADMIN_TOOL_HELP_0 = "GUI_DELETEMODULE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETEMODULE_ADMIN_TOOL_NAME_0 = "GUI_DELETEMODULE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_ADMIN_TOOL_GROUP_0 = "GUI_DEPENDENCIES_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_DELETE_CONF_0 = "GUI_DEPENDENCIES_LIST_ACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_DELETE_HELP_0 = "GUI_DEPENDENCIES_LIST_ACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_DELETE_NAME_0 = "GUI_DEPENDENCIES_LIST_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_EDIT_HELP_0 = "GUI_DEPENDENCIES_LIST_ACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_EDIT_NAME_0 = "GUI_DEPENDENCIES_LIST_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_MDELETE_CONF_0 = "GUI_DEPENDENCIES_LIST_ACTION_MDELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_MDELETE_HELP_0 = "GUI_DEPENDENCIES_LIST_ACTION_MDELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_MDELETE_NAME_0 = "GUI_DEPENDENCIES_LIST_ACTION_MDELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_OVERVIEW_HELP_0 = "GUI_DEPENDENCIES_LIST_ACTION_OVERVIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_ACTION_OVERVIEW_NAME_0 = "GUI_DEPENDENCIES_LIST_ACTION_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_COLS_NAME_0 = "GUI_DEPENDENCIES_LIST_COLS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_COLS_VERSION_0 = "GUI_DEPENDENCIES_LIST_COLS_VERSION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEPENDENCIES_LIST_NAME_0 = "GUI_DEPENDENCIES_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITDEPENDENCIES_ADMIN_TOOL_HELP_0 = "GUI_EDITDEPENDENCIES_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITDEPENDENCIES_ADMIN_TOOL_NAME_0 = "GUI_EDITDEPENDENCIES_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITEXPORTPOINTS_ADMIN_TOOL_HELP_0 = "GUI_EDITEXPORTPOINTS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITEXPORTPOINTS_ADMIN_TOOL_NAME_0 = "GUI_EDITEXPORTPOINTS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITMODULE_ADMIN_TOOL_HELP_0 = "GUI_EDITMODULE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITMODULE_ADMIN_TOOL_NAME_0 = "GUI_EDITMODULE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITMODULEPARAMETERS_ADMIN_TOOL_HELP_0 = "GUI_EDITMODULEPARAMETERS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITMODULEPARAMETERS_ADMIN_TOOL_NAME_0 = "GUI_EDITMODULEPARAMETERS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITMODULERESOURCES_ADMIN_TOOL_HELP_0 = "GUI_EDITMODULERESOURCES_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITMODULERESOURCES_ADMIN_TOOL_NAME_0 = "GUI_EDITMODULERESOURCES_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTMODULE_ADMIN_TOOL_HELP_0 = "GUI_EXPORTMODULE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTMODULE_ADMIN_TOOL_NAME_0 = "GUI_EXPORTMODULE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_ADMIN_TOOL_GROUP_0 = "GUI_EXPORTPOINTS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_ADMIN_TOOL_HELP_0 = "GUI_EXPORTPOINTS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_ADMIN_TOOL_NAME_0 = "GUI_EXPORTPOINTS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_ACTION_DELETE_CONF_0 = "GUI_EXPORTPOINTS_LIST_ACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_ACTION_DELETE_HELP_0 = "GUI_EXPORTPOINTS_LIST_ACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_ACTION_DELETE_NAME_0 = "GUI_EXPORTPOINTS_LIST_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_ACTION_EDIT_HELP_0 = "GUI_EXPORTPOINTS_LIST_ACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_ACTION_EDIT_NAME_0 = "GUI_EXPORTPOINTS_LIST_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_ACTION_OVERVIEW_HELP_0 = "GUI_EXPORTPOINTS_LIST_ACTION_OVERVIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_ACTION_OVERVIEW_NAME_0 = "GUI_EXPORTPOINTS_LIST_ACTION_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_COLS_DESTINATION_0 = "GUI_EXPORTPOINTS_LIST_COLS_DESTINATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_COLS_SERVERDESTINATION_0 = "GUI_EXPORTPOINTS_LIST_COLS_SERVERDESTINATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_COLS_URI_0 = "GUI_EXPORTPOINTS_LIST_COLS_URI_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPORTPOINTS_LIST_NAME_0 = "GUI_EXPORTPOINTS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTMODULE_ADMIN_TOOL_HELP_0 = "GUI_IMPORTMODULE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTMODULE_ADMIN_TOOL_NAME_0 = "GUI_IMPORTMODULE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTMODULESERVER_ADMIN_TOOL_HELP_0 = "GUI_IMPORTMODULESERVER_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORTMODULESERVER_ADMIN_TOOL_NAME_0 = "GUI_IMPORTMODULESERVER_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULE_ADMIN_TOOL_GROUP_0 = "GUI_MODULE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULEDEPENDENCIES_ADMIN_TOOL_HELP_0 = "GUI_MODULEDEPENDENCIES_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULEDEPENDENCIES_ADMIN_TOOL_NAME_0 = "GUI_MODULEDEPENDENCIES_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_ADMIN_TOOL_GROUP_0 = "GUI_MODULES_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_ADMIN_TOOL_HELP_0 = "GUI_MODULES_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_ADMIN_TOOL_NAME_0 = "GUI_MODULES_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_HIDE_AUTHORINFO_HELP_0 = "GUI_MODULES_DETAIL_HIDE_AUTHORINFO_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_HIDE_AUTHORINFO_NAME_0 = "GUI_MODULES_DETAIL_HIDE_AUTHORINFO_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_HIDE_DEPENDENCIES_HELP_0 = "GUI_MODULES_DETAIL_HIDE_DEPENDENCIES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_HIDE_DEPENDENCIES_NAME_0 = "GUI_MODULES_DETAIL_HIDE_DEPENDENCIES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_HIDE_RESOURCES_HELP_0 = "GUI_MODULES_DETAIL_HIDE_RESOURCES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_HIDE_RESOURCES_NAME_0 = "GUI_MODULES_DETAIL_HIDE_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_HIDE_RESTYPES_HELP_0 = "GUI_MODULES_DETAIL_HIDE_RESTYPES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_HIDE_RESTYPES_NAME_0 = "GUI_MODULES_DETAIL_HIDE_RESTYPES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_SHOW_AUTHORINFO_HELP_0 = "GUI_MODULES_DETAIL_SHOW_AUTHORINFO_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_SHOW_AUTHORINFO_NAME_0 = "GUI_MODULES_DETAIL_SHOW_AUTHORINFO_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_SHOW_DEPENDENCIES_HELP_0 = "GUI_MODULES_DETAIL_SHOW_DEPENDENCIES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_SHOW_DEPENDENCIES_NAME_0 = "GUI_MODULES_DETAIL_SHOW_DEPENDENCIES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_SHOW_RESOURCES_HELP_0 = "GUI_MODULES_DETAIL_SHOW_RESOURCES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_SHOW_RESOURCES_NAME_0 = "GUI_MODULES_DETAIL_SHOW_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_SHOW_RESTYPES_HELP_0 = "GUI_MODULES_DETAIL_SHOW_RESTYPES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_DETAIL_SHOW_RESTYPES_NAME_0 = "GUI_MODULES_DETAIL_SHOW_RESTYPES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_IMPORT_BLOCK_0 = "GUI_MODULES_IMPORT_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_IMPORT_FILE_0 = "GUI_MODULES_IMPORT_FILE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_IMPORT_NOT_AVAILABLE_0 = "GUI_MODULES_IMPORT_NOT_AVAILABLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LABEL_AUTHOR_0 = "GUI_MODULES_LABEL_AUTHOR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LABEL_DEPENDENCIES_0 = "GUI_MODULES_LABEL_DEPENDENCIES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LABEL_EXPLORERSETTINGSS_DETAIL_0 = "GUI_MODULES_LABEL_EXPLORERSETTINGSS_DETAIL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LABEL_RESOURCES_0 = "GUI_MODULES_LABEL_RESOURCES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LABEL_RESTYPES_0 = "GUI_MODULES_LABEL_RESTYPES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LABEL_RESTYPES_DETAIL_0 = "GUI_MODULES_LABEL_RESTYPES_DETAIL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_DELETE_CONF_0 = "GUI_MODULES_LIST_ACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_DELETE_HELP_0 = "GUI_MODULES_LIST_ACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_DELETE_NAME_0 = "GUI_MODULES_LIST_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_EDIT_HELP_0 = "GUI_MODULES_LIST_ACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_EDIT_NAME_0 = "GUI_MODULES_LIST_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_EXPORT_CONF_0 = "GUI_MODULES_LIST_ACTION_EXPORT_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_EXPORT_HELP_0 = "GUI_MODULES_LIST_ACTION_EXPORT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_EXPORT_NAME_0 = "GUI_MODULES_LIST_ACTION_EXPORT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_MDELETE_CONF_0 = "GUI_MODULES_LIST_ACTION_MDELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_MDELETE_HELP_0 = "GUI_MODULES_LIST_ACTION_MDELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_MDELETE_NAME_0 = "GUI_MODULES_LIST_ACTION_MDELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_OVERVIEW_HELP_0 = "GUI_MODULES_LIST_ACTION_OVERVIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_ACTION_OVERVIEW_NAME_0 = "GUI_MODULES_LIST_ACTION_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_COLS_DELETE_0 = "GUI_MODULES_LIST_COLS_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_COLS_EDIT_0 = "GUI_MODULES_LIST_COLS_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_COLS_EXPORT_0 = "GUI_MODULES_LIST_COLS_EXPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_COLS_GROUP_0 = "GUI_MODULES_LIST_COLS_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_COLS_NAME_0 = "GUI_MODULES_LIST_COLS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_COLS_NICENAME_0 = "GUI_MODULES_LIST_COLS_NICENAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_COLS_VERSION_0 = "GUI_MODULES_LIST_COLS_VERSION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_EXPORT_REPORT_HANDLER_NAME_1 = "GUI_MODULES_LIST_EXPORT_REPORT_HANDLER_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MODULES_LIST_NAME_0 = "GUI_MODULES_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWDEPENDENCIES_ADMIN_TOOL_HELP_0 = "GUI_NEWDEPENDENCIES_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWDEPENDENCIES_ADMIN_TOOL_NAME_0 = "GUI_NEWDEPENDENCIES_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWEXPORTPOINTS_ADMIN_TOOL_HELP_0 = "GUI_NEWEXPORTPOINTS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWEXPORTPOINTS_ADMIN_TOOL_NAME_0 = "GUI_NEWEXPORTPOINTS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWMODULE_ADMIN_TOOL_HELP_0 = "GUI_NEWMODULE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWMODULE_ADMIN_TOOL_NAME_0 = "GUI_NEWMODULE_ADMIN_TOOL_NAME_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.modules.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}