/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/projects/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:51 $
 * Version: $Revision: 1.12 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.projects;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Michael Moossen 
 * 
 * @version $Revision: 1.12 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_PROJECT_1 = "ERR_DELETE_PROJECT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_SELECTED_PROJECTS_0 = "ERR_DELETE_SELECTED_PROJECTS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EDIT_FILES_0 = "ERR_EDIT_FILES_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EDIT_PROJECT_0 = "ERR_EDIT_PROJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EDIT_PUBLISH_0 = "ERR_EDIT_PUBLISH_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOCK_PROJECT_1 = "ERR_LOCK_PROJECT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOCK_SELECTED_PROJECTS_0 = "ERR_LOCK_SELECTED_PROJECTS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNLOCK_PROJECT_1 = "ERR_UNLOCK_PROJECT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNLOCK_SELECTED_PROJECTS_0 = "ERR_UNLOCK_SELECTED_PROJECTS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_ADMIN_TOOL_GROUP_0 = "GUI_EDITPROJECT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_ADMIN_TOOL_HELP_0 = "GUI_EDITPROJECT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_ADMIN_TOOL_NAME_0 = "GUI_EDITPROJECT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITPROJECT_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_DELETE_ADMIN_TOOL_GROUP_0 = "GUI_EDITPROJECT_DELETE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_DELETE_ADMIN_TOOL_HELP_0 = "GUI_EDITPROJECT_DELETE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_DELETE_ADMIN_TOOL_NAME_0 = "GUI_EDITPROJECT_DELETE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_FILES_ADMIN_TOOL_GROUP_0 = "GUI_EDITPROJECT_FILES_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_FILES_ADMIN_TOOL_HELP_0 = "GUI_EDITPROJECT_FILES_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_FILES_ADMIN_TOOL_NAME_0 = "GUI_EDITPROJECT_FILES_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_FILES_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITPROJECT_FILES_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_PUBLISH_ADMIN_TOOL_GROUP_0 = "GUI_EDITPROJECT_PUBLISH_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_PUBLISH_ADMIN_TOOL_HELP_0 = "GUI_EDITPROJECT_PUBLISH_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_PUBLISH_ADMIN_TOOL_NAME_0 = "GUI_EDITPROJECT_PUBLISH_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITPROJECT_PUBLISH_ADMIN_TOOL_NAVBARNAME_0 = "GUI_EDITPROJECT_PUBLISH_ADMIN_TOOL_NAVBARNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWPROJECT_ADMIN_TOOL_GROUP_0 = "GUI_NEWPROJECT_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWPROJECT_ADMIN_TOOL_HELP_0 = "GUI_NEWPROJECT_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWPROJECT_ADMIN_TOOL_NAME_0 = "GUI_NEWPROJECT_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_EDITOR_LABEL_CONTENT_BLOCK_0 = "GUI_PROJECT_EDITOR_LABEL_CONTENT_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_EDITOR_LABEL_IDENTIFICATION_BLOCK_0 = "GUI_PROJECT_EDITOR_LABEL_IDENTIFICATION_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_FILES_FILTER_ACTION_HELP_0 = "GUI_PROJECT_FILES_FILTER_ACTION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_FILES_FILTER_ACTION_NAME_0 = "GUI_PROJECT_FILES_FILTER_ACTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_FILES_LIST_NAME_0 = "GUI_PROJECT_FILES_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_HISTORY_ADMIN_TOOL_GROUP_0 = "GUI_PROJECT_HISTORY_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_HISTORY_ADMIN_TOOL_HELP_0 = "GUI_PROJECT_HISTORY_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_HISTORY_ADMIN_TOOL_NAME_0 = "GUI_PROJECT_HISTORY_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_SETTINGS_ADMIN_TOOL_GROUP_0 = "GUI_PROJECT_SETTINGS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_SETTINGS_ADMIN_TOOL_HELP_0 = "GUI_PROJECT_SETTINGS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECT_SETTINGS_ADMIN_TOOL_NAME_0 = "GUI_PROJECT_SETTINGS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTHISTORY_LIST_NAME_0 = "GUI_PROJECTHISTORY_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_ADMIN_TOOL_GROUP_0 = "GUI_PROJECTS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_ADMIN_TOOL_HELP_0 = "GUI_PROJECTS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_ADMIN_TOOL_NAME_0 = "GUI_PROJECTS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_DETAIL_HIDE_RESOURCES_HELP_0 = "GUI_PROJECTS_DETAIL_HIDE_RESOURCES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_DETAIL_HIDE_RESOURCES_NAME_0 = "GUI_PROJECTS_DETAIL_HIDE_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_DETAIL_RESOURCES_NAME_0 = "GUI_PROJECTS_DETAIL_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_DETAIL_SHOW_RESOURCES_HELP_0 = "GUI_PROJECTS_DETAIL_SHOW_RESOURCES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_DETAIL_SHOW_RESOURCES_NAME_0 = "GUI_PROJECTS_DETAIL_SHOW_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_DELETE_CONF_0 = "GUI_PROJECTS_LIST_ACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_DELETE_HELP_0 = "GUI_PROJECTS_LIST_ACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_DELETE_NAME_0 = "GUI_PROJECTS_LIST_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_EDIT_HELP_0 = "GUI_PROJECTS_LIST_ACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_EDIT_NAME_0 = "GUI_PROJECTS_LIST_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_FILES_HELP_0 = "GUI_PROJECTS_LIST_ACTION_FILES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_FILES_NAME_0 = "GUI_PROJECTS_LIST_ACTION_FILES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_ICON_HELP_0 = "GUI_PROJECTS_LIST_ACTION_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_ICON_NAME_0 = "GUI_PROJECTS_LIST_ACTION_ICON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_LOCK_CONF_0 = "GUI_PROJECTS_LIST_ACTION_LOCK_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_LOCK_HELP_0 = "GUI_PROJECTS_LIST_ACTION_LOCK_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_LOCK_NAME_0 = "GUI_PROJECTS_LIST_ACTION_LOCK_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_PUBLISH_DISABLED_CONF_0 = "GUI_PROJECTS_LIST_ACTION_PUBLISH_DISABLED_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_PUBLISH_DISABLED_HELP_0 = "GUI_PROJECTS_LIST_ACTION_PUBLISH_DISABLED_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_PUBLISH_DISABLED_NAME_0 = "GUI_PROJECTS_LIST_ACTION_PUBLISH_DISABLED_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_PUBLISH_ENABLED_CONF_0 = "GUI_PROJECTS_LIST_ACTION_PUBLISH_ENABLED_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_PUBLISH_ENABLED_HELP_0 = "GUI_PROJECTS_LIST_ACTION_PUBLISH_ENABLED_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_PUBLISH_ENABLED_NAME_0 = "GUI_PROJECTS_LIST_ACTION_PUBLISH_ENABLED_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_UNLOCK_CONF_0 = "GUI_PROJECTS_LIST_ACTION_UNLOCK_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_UNLOCK_HELP_0 = "GUI_PROJECTS_LIST_ACTION_UNLOCK_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_ACTION_UNLOCK_NAME_0 = "GUI_PROJECTS_LIST_ACTION_UNLOCK_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_CREATION_0 = "GUI_PROJECTS_LIST_COLS_CREATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_DELETE_0 = "GUI_PROJECTS_LIST_COLS_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_DELETE_HELP_0 = "GUI_PROJECTS_LIST_COLS_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_DESCRIPTION_0 = "GUI_PROJECTS_LIST_COLS_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_EDIT_0 = "GUI_PROJECTS_LIST_COLS_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_EDIT_HELP_0 = "GUI_PROJECTS_LIST_COLS_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_FILES_0 = "GUI_PROJECTS_LIST_COLS_FILES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_FILES_HELP_0 = "GUI_PROJECTS_LIST_COLS_FILES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_ICON_0 = "GUI_PROJECTS_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_ICON_HELP_0 = "GUI_PROJECTS_LIST_COLS_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_LOCK_0 = "GUI_PROJECTS_LIST_COLS_LOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_LOCK_HELP_0 = "GUI_PROJECTS_LIST_COLS_LOCK_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_MANAGER_0 = "GUI_PROJECTS_LIST_COLS_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_NAME_0 = "GUI_PROJECTS_LIST_COLS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_ORGUNIT_0 = "GUI_PROJECTS_LIST_COLS_ORGUNIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_OWNER_0 = "GUI_PROJECTS_LIST_COLS_OWNER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_PUBLISH_0 = "GUI_PROJECTS_LIST_COLS_PUBLISH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_PUBLISH_HELP_0 = "GUI_PROJECTS_LIST_COLS_PUBLISH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_PUBLISHED_BY_0 = "GUI_PROJECTS_LIST_COLS_PUBLISHED_BY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_PUBLISHED_DATE_0 = "GUI_PROJECTS_LIST_COLS_PUBLISHED_DATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_COLS_USER_0 = "GUI_PROJECTS_LIST_COLS_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_DEFACTION_EDIT_HELP_0 = "GUI_PROJECTS_LIST_DEFACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_DEFACTION_EDIT_NAME_0 = "GUI_PROJECTS_LIST_DEFACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_MACTION_DELETE_CONF_0 = "GUI_PROJECTS_LIST_MACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_MACTION_DELETE_HELP_0 = "GUI_PROJECTS_LIST_MACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_MACTION_DELETE_NAME_0 = "GUI_PROJECTS_LIST_MACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_MACTION_UNLOCK_CONF_0 = "GUI_PROJECTS_LIST_MACTION_UNLOCK_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_MACTION_UNLOCK_HELP_0 = "GUI_PROJECTS_LIST_MACTION_UNLOCK_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_MACTION_UNLOCK_NAME_0 = "GUI_PROJECTS_LIST_MACTION_UNLOCK_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PROJECTS_LIST_NAME_0 = "GUI_PROJECTS_LIST_NAME_0";
    
    /** Message constant for key in the resource bundle. */
    public static final String GUI_VIEWPROJECT_ADMIN_TOOL_GROUP_0 = "GUI_VIEWPROJECT_ADMIN_TOOL_GROUP_0";
    
    /** Message constant for key in the resource bundle. */
    public static final String GUI_VIEWPROJECT_ADMIN_TOOL_HELP_0 = "GUI_VIEWPROJECT_ADMIN_TOOL_HELP_0";
    
    /** Message constant for key in the resource bundle. */
    public static final String GUI_VIEWPROJECT_ADMIN_TOOL_NAME_0 = "GUI_VIEWPROJECT_ADMIN_TOOL_NAME_0";
    
    /** Message constant for key in the resource bundle. */
    public static final String GUI_VIEWPROJECT_ADMIN_TOOL_NAVBARNAME_0 = "GUI_VIEWPROJECT_ADMIN_TOOL_NAVBARNAME_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.projects.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }

}