/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/publishqueue/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:31 $
 * Version: $Revision: 1.7 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.publishqueue;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Raphael Schnuck 
 * 
 * @version $Revision: 1.7 $ 
 * 
 * @since 6.5.5 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_FILE_ARG_ACCESS_1 = "ERR_FILE_ARG_ACCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DATE_FORMAT_WITH_SECONDS_1 = "GUI_LIST_DATE_FORMAT_WITH_SECONDS_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0 = "GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_ACTION_VIEW_NAME_0 = "GUI_PERSONALQUEUE_ACTION_VIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_COLS_ID_0 = "GUI_PERSONALQUEUE_COLS_ID_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_COLS_PROJECT_0 = "GUI_PERSONALQUEUE_COLS_PROJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_COLS_RESCOUNT_0 = "GUI_PERSONALQUEUE_COLS_RESCOUNT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_COLS_STARTPUBLISHING_0 = "GUI_PERSONALQUEUE_COLS_STARTPUBLISHING_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_COLS_STATE_0 = "GUI_PERSONALQUEUE_COLS_STATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_COLS_STOPPUBLISHING_0 = "GUI_PERSONALQUEUE_COLS_STOPPUBLISHING_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_COLS_USER_0 = "GUI_PERSONALQUEUE_COLS_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_COLS_VIEW_0 = "GUI_PERSONALQUEUE_COLS_VIEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PERSONALQUEUE_LIST_NAME_0 = "GUI_PERSONALQUEUE_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISH_JOB_FINISHED_0 = "GUI_PUBLISH_JOB_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISH_JOB_FINISHED_WITH_WARNS_2 = "GUI_PUBLISH_JOB_FINISHED_WITH_WARNS_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISH_QUEUE_0 = "GUI_PUBLISH_QUEUE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISH_REPORT_VIEW_TITLE_3 = "GUI_PUBLISH_REPORT_VIEW_TITLE_3";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_ACTION_CANCEL_CONF_0 = "GUI_PUBLISHQUEUE_ACTION_CANCEL_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_ACTION_CANCEL_HELP_0 = "GUI_PUBLISHQUEUE_ACTION_CANCEL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_ACTION_CANCEL_NAME_0 = "GUI_PUBLISHQUEUE_ACTION_CANCEL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_ACTION_VIEW_HELP_0 = "GUI_PUBLISHQUEUE_ACTION_VIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_ACTION_VIEW_NAME_0 = "GUI_PUBLISHQUEUE_ACTION_VIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_ADMIN_TOOL_GROUP_0 = "GUI_PUBLISHQUEUE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_ADMIN_TOOL_HELP_0 = "GUI_PUBLISHQUEUE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_ADMIN_TOOL_NAME_0 = "GUI_PUBLISHQUEUE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_ADMIN_TOOL_SHORT_NAME_0 = "GUI_PUBLISHQUEUE_ADMIN_TOOL_SHORT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_COLS_CANCEL_0 = "GUI_PUBLISHQUEUE_COLS_CANCEL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_COLS_INQUEUETIME_0 = "GUI_PUBLISHQUEUE_COLS_INQUEUETIME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_COLS_NUMBER_0 = "GUI_PUBLISHQUEUE_COLS_NUMBER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_COLS_PROJECT_0 = "GUI_PUBLISHQUEUE_COLS_PROJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_COLS_RESCOUNT_0 = "GUI_PUBLISHQUEUE_COLS_RESCOUNT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_COLS_STATE_0 = "GUI_PUBLISHQUEUE_COLS_STATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_COLS_USER_0 = "GUI_PUBLISHQUEUE_COLS_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_DETAIL_HIDE_RESOURCES_HELP_0 = "GUI_PUBLISHQUEUE_DETAIL_HIDE_RESOURCES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_DETAIL_HIDE_RESOURCES_NAME_0 = "GUI_PUBLISHQUEUE_DETAIL_HIDE_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_DETAIL_LABEL_RESOURCES_0 = "GUI_PUBLISHQUEUE_DETAIL_LABEL_RESOURCES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_DETAIL_SHOW_RESOURCES_HELP_0 = "GUI_PUBLISHQUEUE_DETAIL_SHOW_RESOURCES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_DETAIL_SHOW_RESOURCES_NAME_0 = "GUI_PUBLISHQUEUE_DETAIL_SHOW_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_LIST_NAME_0 = "GUI_PUBLISHQUEUE_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_LIVE_ADMIN_TOOL_GROUP_0 = "GUI_PUBLISHQUEUE_LIVE_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_LIVE_ADMIN_TOOL_HELP_0 = "GUI_PUBLISHQUEUE_LIVE_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_LIVE_ADMIN_TOOL_NAME_0 = "GUI_PUBLISHQUEUE_LIVE_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_VIEW_ADMIN_TOOL_GROUP_0 = "GUI_PUBLISHQUEUE_VIEW_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_VIEW_ADMIN_TOOL_HELP_0 = "GUI_PUBLISHQUEUE_VIEW_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_VIEW_ADMIN_TOOL_NAME_0 = "GUI_PUBLISHQUEUE_VIEW_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PUBLISHQUEUE_VIEW_ADMIN_TOOL_NAVBARNAME_0 = "GUI_PUBLISHQUEUE_VIEW_ADMIN_TOOL_NAVBARNAME_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.publishqueue.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }

}