/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/scheduler/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:43 $
 * Version: $Revision: 1.21 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.scheduler;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Michael Moossen 
 * 
 * @version $Revision: 1.21 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_COPY_JOB_1 = "ERR_COPY_JOB_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_JOB_1 = "ERR_DELETE_JOB_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EDIT_JOB_1 = "ERR_EDIT_JOB_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SCHEDULE_JOB_1 = "ERR_SCHEDULE_JOB_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNSCHEDULE_JOB_1 = "ERR_UNSCHEDULE_JOB_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITJOB_ADMIN_TOOL_GROUP_0 = "GUI_EDITJOB_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITJOB_ADMIN_TOOL_HELP_0 = "GUI_EDITJOB_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITJOB_ADMIN_TOOL_NAME_0 = "GUI_EDITJOB_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_CLEARHISTORY_0 = "GUI_EDITOR_CRONCLASS_CLEARHISTORY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_CONTENTNOTIFICATION_0 = "GUI_EDITOR_CRONCLASS_CONTENTNOTIFICATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_IMAGE_CACHECLEAN_0 = "GUI_EDITOR_CRONCLASS_IMAGE_CACHECLEAN_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_IMAGESIZE_0 = "GUI_EDITOR_CRONCLASS_IMAGESIZE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_INTERNALVALIDATION_0 = "GUI_EDITOR_CRONCLASS_INTERNALVALIDATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_MEMORYMONITOR_0 = "GUI_EDITOR_CRONCLASS_MEMORYMONITOR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_POINTERVALIDATION_0 = "GUI_EDITOR_CRONCLASS_POINTERVALIDATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_PUBLISH_0 = "GUI_EDITOR_CRONCLASS_PUBLISH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_SEARCHINDEX_0 = "GUI_EDITOR_CRONCLASS_SEARCHINDEX_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONCLASS_STATICEXPORT_0 = "GUI_EDITOR_CRONCLASS_STATICEXPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONJOB_EXAMPLE1_0 = "GUI_EDITOR_CRONJOB_EXAMPLE1_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONJOB_EXAMPLE2_0 = "GUI_EDITOR_CRONJOB_EXAMPLE2_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONJOB_EXAMPLE3_0 = "GUI_EDITOR_CRONJOB_EXAMPLE3_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONJOB_EXAMPLE4_0 = "GUI_EDITOR_CRONJOB_EXAMPLE4_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_CRONJOB_EXAMPLE5_0 = "GUI_EDITOR_CRONJOB_EXAMPLE5_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_LABEL_CONTEXTINFO_BLOCK_0 = "GUI_EDITOR_LABEL_CONTEXTINFO_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_LABEL_JOBSETTINGS_BLOCK_0 = "GUI_EDITOR_LABEL_JOBSETTINGS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_LABEL_PARAMETERS_BLOCK_0 = "GUI_EDITOR_LABEL_PARAMETERS_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITOR_LABEL_SERVERTIME_BLOCK_0 = "GUI_EDITOR_LABEL_SERVERTIME_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_ADMIN_TOOL_GROUP_0 = "GUI_JOBS_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_ADMIN_TOOL_HELP_0 = "GUI_JOBS_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_ADMIN_TOOL_NAME_0 = "GUI_JOBS_ADMIN_TOOL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_ADMIN_TOOL_SHORTNAME_0 = "GUI_JOBS_ADMIN_TOOL_SHORTNAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_CONTEXTINFO_ENCODING_0 = "GUI_JOBS_DETAIL_CONTEXTINFO_ENCODING_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_CONTEXTINFO_FORMAT_0 = "GUI_JOBS_DETAIL_CONTEXTINFO_FORMAT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_CONTEXTINFO_LOCALE_0 = "GUI_JOBS_DETAIL_CONTEXTINFO_LOCALE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_CONTEXTINFO_PROJECT_0 = "GUI_JOBS_DETAIL_CONTEXTINFO_PROJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_CONTEXTINFO_REMADR_0 = "GUI_JOBS_DETAIL_CONTEXTINFO_REMADR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_CONTEXTINFO_REQURI_0 = "GUI_JOBS_DETAIL_CONTEXTINFO_REQURI_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_CONTEXTINFO_ROOTSITE_0 = "GUI_JOBS_DETAIL_CONTEXTINFO_ROOTSITE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_CONTEXTINFO_USER_0 = "GUI_JOBS_DETAIL_CONTEXTINFO_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_HIDE_CONTEXTINFO_HELP_0 = "GUI_JOBS_DETAIL_HIDE_CONTEXTINFO_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_HIDE_CONTEXTINFO_NAME_0 = "GUI_JOBS_DETAIL_HIDE_CONTEXTINFO_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_HIDE_PARAMETER_HELP_0 = "GUI_JOBS_DETAIL_HIDE_PARAMETER_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_HIDE_PARAMETER_NAME_0 = "GUI_JOBS_DETAIL_HIDE_PARAMETER_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_PARAMETER_FORMAT_0 = "GUI_JOBS_DETAIL_PARAMETER_FORMAT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_SHOW_CONTEXTINFO_HELP_0 = "GUI_JOBS_DETAIL_SHOW_CONTEXTINFO_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_SHOW_CONTEXTINFO_NAME_0 = "GUI_JOBS_DETAIL_SHOW_CONTEXTINFO_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_SHOW_PARAMETER_HELP_0 = "GUI_JOBS_DETAIL_SHOW_PARAMETER_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_DETAIL_SHOW_PARAMETER_NAME_0 = "GUI_JOBS_DETAIL_SHOW_PARAMETER_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_ACTIVATE_CONF_0 = "GUI_JOBS_LIST_ACTION_ACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_ACTIVATE_HELP_0 = "GUI_JOBS_LIST_ACTION_ACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_ACTIVATE_NAME_0 = "GUI_JOBS_LIST_ACTION_ACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_COPY_CONF_0 = "GUI_JOBS_LIST_ACTION_COPY_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_COPY_HELP_0 = "GUI_JOBS_LIST_ACTION_COPY_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_COPY_NAME_0 = "GUI_JOBS_LIST_ACTION_COPY_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_DEACTIVATE_CONF_0 = "GUI_JOBS_LIST_ACTION_DEACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_DEACTIVATE_HELP_0 = "GUI_JOBS_LIST_ACTION_DEACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_DEACTIVATE_NAME_0 = "GUI_JOBS_LIST_ACTION_DEACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_DELETE_CONF_0 = "GUI_JOBS_LIST_ACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_DELETE_HELP_0 = "GUI_JOBS_LIST_ACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_DELETE_NAME_0 = "GUI_JOBS_LIST_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_EDIT_CONF_0 = "GUI_JOBS_LIST_ACTION_EDIT_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_EDIT_HELP_0 = "GUI_JOBS_LIST_ACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_EDIT_NAME_0 = "GUI_JOBS_LIST_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_MACTIVATE_CONF_0 = "GUI_JOBS_LIST_ACTION_MACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_MACTIVATE_HELP_0 = "GUI_JOBS_LIST_ACTION_MACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_MACTIVATE_NAME_0 = "GUI_JOBS_LIST_ACTION_MACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_MDEACTIVATE_CONF_0 = "GUI_JOBS_LIST_ACTION_MDEACTIVATE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_MDEACTIVATE_HELP_0 = "GUI_JOBS_LIST_ACTION_MDEACTIVATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_MDEACTIVATE_NAME_0 = "GUI_JOBS_LIST_ACTION_MDEACTIVATE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_MDELETE_CONF_0 = "GUI_JOBS_LIST_ACTION_MDELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_MDELETE_HELP_0 = "GUI_JOBS_LIST_ACTION_MDELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_ACTION_MDELETE_NAME_0 = "GUI_JOBS_LIST_ACTION_MDELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_ACTIVE_0 = "GUI_JOBS_LIST_COL_ACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_ACTIVE_HELP_0 = "GUI_JOBS_LIST_COL_ACTIVE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_CLASS_0 = "GUI_JOBS_LIST_COL_CLASS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_COPY_0 = "GUI_JOBS_LIST_COL_COPY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_COPY_HELP_0 = "GUI_JOBS_LIST_COL_COPY_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_DELETE_0 = "GUI_JOBS_LIST_COL_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_DELETE_HELP_0 = "GUI_JOBS_LIST_COL_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_EDIT_0 = "GUI_JOBS_LIST_COL_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_EDIT_HELP_0 = "GUI_JOBS_LIST_COL_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_LASTEXE_0 = "GUI_JOBS_LIST_COL_LASTEXE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_NAME_0 = "GUI_JOBS_LIST_COL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_COL_NEXTEXE_0 = "GUI_JOBS_LIST_COL_NEXTEXE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_JOBS_LIST_NAME_0 = "GUI_JOBS_LIST_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWJOB_ADMIN_TOOL_GROUP_0 = "GUI_NEWJOB_ADMIN_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWJOB_ADMIN_TOOL_HELP_0 = "GUI_NEWJOB_ADMIN_TOOL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NEWJOB_ADMIN_TOOL_NAME_0 = "GUI_NEWJOB_ADMIN_TOOL_NAME_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.scheduler.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}