/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/searchindex/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:39 $
 * Version: $Revision: 1.11 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.searchindex;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Jan Baudisch 
 * @author Achim Westermann
 * 
 * @version $Revision: 1.11 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1 = "ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SEARCHINDEX_REBUILD_MULTI_0 = "ERR_SEARCHINDEX_REBUILD_MULTI_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELD_TOOL_DELETE_0 = "GUI_GROUPS_FIELD_TOOL_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELD_TOOL_DELETE_HELP_0 = "GUI_GROUPS_FIELD_TOOL_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELD_TOOL_EDIT_0 = "GUI_GROUPS_FIELD_TOOL_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELD_TOOL_EDIT_HELP_0 = "GUI_GROUPS_FIELD_TOOL_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELD_TOOL_GROUP_0 = "GUI_GROUPS_FIELD_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELD_TOOL_OVERVIEW_0 = "GUI_GROUPS_FIELD_TOOL_OVERVIEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_DELETE_HELP_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_EDIT_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_EDIT_HELP_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_GROUP_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_INDEX_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_INDEX_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_INDEX_HELP_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_INDEX_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_NEW_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_NEW_HELP_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_NEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_OVERVIEW_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_OVERVIEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_FIELDCONFIGURATION_TOOL_OVERVIEW_NAVACTIVE_0 = "GUI_GROUPS_FIELDCONFIGURATION_TOOL_OVERVIEW_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_DELETE_HELP_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_EDIT_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_EDIT_HELP_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_EDIT_NAVACTIVE_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_EDIT_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_GROUP_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_INDEX_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_INDEX_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_INDEX_HELP_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_INDEX_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_NEW_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_NEW_HELP_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_NEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_OVERVIEW_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_OVERVIEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_OVERVIEW_NAVACTIVE_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_OVERVIEW_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_INDEXSOURCE_TOOL_RESOURCES_HELP_0 = "GUI_GROUPS_INDEXSOURCE_TOOL_RESOURCES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_DELETE_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_DELETE_HELP_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_DELETE_NAVACTIVE_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_DELETE_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_EDIT_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_EDIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_EDIT_GROUP_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_EDIT_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_EDIT_HELP_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_EDIT_NAVACTIVE_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_EDIT_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_GROUP_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_INDEXSOURCES_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_INDEXSOURCES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_INDEXSOURCES_NAVACTIVE_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_INDEXSOURCES_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_NEW_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_NEW_HELP_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_NEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_OVERVIEW_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_OVERVIEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_OVERVIEW_HELP_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_OVERVIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_OVERVIEW_NAVACTIVE_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_OVERVIEW_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_HELP_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_NAVACTIVE_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_REPORT_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_REPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_REPORT_NAVACTIVE_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_REBUILD_REPORT_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_SEARCH_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_SEARCH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_SEARCH_HELP_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_SEARCH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_GROUPS_SEARCHINDEX_TOOL_SEARCH_NAVACTIVE_0 = "GUI_GROUPS_SEARCHINDEX_TOOL_SEARCH_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INDEXING_THREAD_NAME_0 = "GUI_INDEXING_THREAD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INDEXING_THREAD_NAME_1 = "GUI_INDEXING_THREAD_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_FIELD_BLOCK_SETTINGS_0 = "GUI_LABEL_FIELD_BLOCK_SETTINGS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_FIELDCONFIGURATION_BLOCK_SETTINGS_0 = "GUI_LABEL_FIELDCONFIGURATION_BLOCK_SETTINGS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_INDEXSOURCE_BLOCK_SETTINGS_0 = "GUI_LABEL_INDEXSOURCE_BLOCK_SETTINGS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_CATEGORIES_1 = "GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_CATEGORIES_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_FIELDS_0 = "GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_FIELDS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_QUERY_0 = "GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_QUERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_TIME_RANGES_0 = "GUI_LABEL_SEARCHINDEX_BLOCK_SEARCH_TIME_RANGES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_SEARCHINDEX_BLOCK_SETTINGS_0 = "GUI_LABEL_SEARCHINDEX_BLOCK_SETTINGS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_COL_DOCCLASS_0 = "GUI_LIST_DOCTYPE_COL_DOCCLASS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_HIDE_0 = "GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_HIDE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_HIDE_HELP_0 = "GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_HIDE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_NAME_0 = "GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_SHOW_0 = "GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_SHOW_HELP_0 = "GUI_LIST_DOCTYPE_DETAIL_MIMETYPES_SHOW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_HIDE_0 = "GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_HIDE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_HIDE_HELP_0 = "GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_HIDE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_NAME_0 = "GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_SHOW_0 = "GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_SHOW_HELP_0 = "GUI_LIST_DOCTYPE_DETAIL_RESOURCETYPES_SHOW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCUMENTTYPE_NAME_0 = "GUI_LIST_DOCUMENTTYPE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCUMENTTYPE_NAME_HELP_0 = "GUI_LIST_DOCUMENTTYPE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCUMENTTYPES_AVAIL_NAME_0 = "GUI_LIST_DOCUMENTTYPES_AVAIL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCUMENTTYPES_NAME_0 = "GUI_LIST_DOCUMENTTYPES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DOCUMENTTYPES_NAME_HELP_0 = "GUI_LIST_DOCUMENTTYPES_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_DELETE_CONF_1 = "GUI_LIST_FIELD_ACTION_DELETE_CONF_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_DELETE_NAME_0 = "GUI_LIST_FIELD_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_EDIT_NAME_0 = "GUI_LIST_FIELD_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_FALSE_CONF_0 = "GUI_LIST_FIELD_ACTION_FALSE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_FALSE_HELP_0 = "GUI_LIST_FIELD_ACTION_FALSE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_FALSE_NAME_0 = "GUI_LIST_FIELD_ACTION_FALSE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_MAPPING_0 = "GUI_LIST_FIELD_ACTION_MAPPING_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_TRUE_CONF_0 = "GUI_LIST_FIELD_ACTION_TRUE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_TRUE_HELP_0 = "GUI_LIST_FIELD_ACTION_TRUE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_ACTION_TRUE_NAME_0 = "GUI_LIST_FIELD_ACTION_TRUE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_BOOST_0 = "GUI_LIST_FIELD_COL_BOOST_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_DEFAULT_0 = "GUI_LIST_FIELD_COL_DEFAULT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_DISPLAY_0 = "GUI_LIST_FIELD_COL_DISPLAY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_EDIT_NAME_0 = "GUI_LIST_FIELD_COL_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_EDIT_NAME_HELP_0 = "GUI_LIST_FIELD_COL_EDIT_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_EXCERPT_0 = "GUI_LIST_FIELD_COL_EXCERPT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_INDEX_0 = "GUI_LIST_FIELD_COL_INDEX_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_MAPPING_0 = "GUI_LIST_FIELD_COL_MAPPING_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_MAPPING_HELP_0 = "GUI_LIST_FIELD_COL_MAPPING_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_OVERVIEW_NAME_0 = "GUI_LIST_FIELD_COL_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_OVERVIEW_NAME_HELP_0 = "GUI_LIST_FIELD_COL_OVERVIEW_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_STORE_0 = "GUI_LIST_FIELD_COL_STORE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_COL_TOKEN_0 = "GUI_LIST_FIELD_COL_TOKEN_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_DETAIL_MAPPINGS_HIDE_0 = "GUI_LIST_FIELD_DETAIL_MAPPINGS_HIDE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_DETAIL_MAPPINGS_HIDE_HELP_0 = "GUI_LIST_FIELD_DETAIL_MAPPINGS_HIDE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_DETAIL_MAPPINGS_NAME_0 = "GUI_LIST_FIELD_DETAIL_MAPPINGS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_DETAIL_MAPPINGS_SHOW_0 = "GUI_LIST_FIELD_DETAIL_MAPPINGS_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_DETAIL_MAPPINGS_SHOW_HELP_0 = "GUI_LIST_FIELD_DETAIL_MAPPINGS_SHOW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_MACTION_DELETEFIELD_CONF_0 = "GUI_LIST_FIELD_MACTION_DELETEFIELD_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_MACTION_DELETEFIELD_NAME_0 = "GUI_LIST_FIELD_MACTION_DELETEFIELD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_MACTION_DELETEFIELD_NAME_HELP_0 = "GUI_LIST_FIELD_MACTION_DELETEFIELD_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_MACTION_DELETEMAPPING_CONF_0 = "GUI_LIST_FIELD_MACTION_DELETEMAPPING_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_MACTION_DELETEMAPPING_NAME_0 = "GUI_LIST_FIELD_MACTION_DELETEMAPPING_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_MACTION_DELETEMAPPING_NAME_HELP_0 = "GUI_LIST_FIELD_MACTION_DELETEMAPPING_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_NAME_0 = "GUI_LIST_FIELD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELD_NAME_HELP_0 = "GUI_LIST_FIELD_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_ACTION_DELETE_CONF_1 = "GUI_LIST_FIELDCONFIGURATION_ACTION_DELETE_CONF_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_ACTION_DELETE_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_ACTION_EDIT_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_ACTION_FIELD_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_ACTION_FIELD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_DELETE_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_COL_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_DESCRIPTION_0 = "GUI_LIST_FIELDCONFIGURATION_COL_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_EDIT_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_COL_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_EDIT_NAME_HELP_0 = "GUI_LIST_FIELDCONFIGURATION_COL_EDIT_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_FIELD_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_COL_FIELD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_FIELD_NAME_HELP_0 = "GUI_LIST_FIELDCONFIGURATION_COL_FIELD_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_ICON_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_COL_ICON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_ICON_NAME_HELP_0 = "GUI_LIST_FIELDCONFIGURATION_COL_ICON_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_OVERVIEW_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_COL_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_COL_OVERVIEW_NAME_HELP_0 = "GUI_LIST_FIELDCONFIGURATION_COL_OVERVIEW_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_HIDE_0 = "GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_HIDE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_HIDE_HELP_0 = "GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_HIDE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_SHOW_0 = "GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_SHOW_HELP_0 = "GUI_LIST_FIELDCONFIGURATION_DETAIL_FIELDS_SHOW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_MACTION_DELETECONFIGURATION_CONF_0 = "GUI_LIST_FIELDCONFIGURATION_MACTION_DELETECONFIGURATION_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_MACTION_DELETECONFIGURATION_NAME_0 = "GUI_LIST_FIELDCONFIGURATION_MACTION_DELETECONFIGURATION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATION_MACTION_DELETECONFIGURATION_NAME_HELP_0 = "GUI_LIST_FIELDCONFIGURATION_MACTION_DELETECONFIGURATION_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDCONFIGURATIONS_NAME_0 = "GUI_LIST_FIELDCONFIGURATIONS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDS_NAME_0 = "GUI_LIST_FIELDS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_FIELDS_NAME_HELP_0 = "GUI_LIST_FIELDS_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_ACTION_DELETE_CONF_0 = "GUI_LIST_INDEXSOURCE_ACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_ACTION_DELETE_CONF_1 = "GUI_LIST_INDEXSOURCE_ACTION_DELETE_CONF_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_ACTION_DELETE_NAME_0 = "GUI_LIST_INDEXSOURCE_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_ACTION_DELETE_NAME_NAVACTIVE_0 = "GUI_LIST_INDEXSOURCE_ACTION_DELETE_NAME_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_ACTION_EDIT_NAME_0 = "GUI_LIST_INDEXSOURCE_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_ACTION_RESOURCES_NAME_0 = "GUI_LIST_INDEXSOURCE_ACTION_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_ACTION_RESOURCES_NAME_NAVACTIVE_0 = "GUI_LIST_INDEXSOURCE_ACTION_RESOURCES_NAME_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_ADD_DOCTYPE_NAME_0 = "GUI_LIST_INDEXSOURCE_COL_ADD_DOCTYPE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_ADD_DOCTYPE_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_COL_ADD_DOCTYPE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_ADDSOURCE_NAME_0 = "GUI_LIST_INDEXSOURCE_COL_ADDSOURCE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_ADDSOURCE_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_COL_ADDSOURCE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_DOCUMENTS_NAME_0 = "GUI_LIST_INDEXSOURCE_COL_DOCUMENTS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_DOCUMENTS_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_COL_DOCUMENTS_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_EDIT_NAME_0 = "GUI_LIST_INDEXSOURCE_COL_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_EDIT_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_COL_EDIT_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_ICON_NAME_0 = "GUI_LIST_INDEXSOURCE_COL_ICON_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_ICON_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_COL_ICON_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_INDEXER_0 = "GUI_LIST_INDEXSOURCE_COL_INDEXER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_OVERVIEW_NAME_0 = "GUI_LIST_INDEXSOURCE_COL_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_OVERVIEW_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_COL_OVERVIEW_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_REMOVE_DOCTYPE_NAME_0 = "GUI_LIST_INDEXSOURCE_COL_REMOVE_DOCTYPE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_REMOVE_DOCTYPE_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_COL_REMOVE_DOCTYPE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_REMOVESOURCE_NAME_0 = "GUI_LIST_INDEXSOURCE_COL_REMOVESOURCE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_REMOVESOURCE_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_COL_REMOVESOURCE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_RESOURCES_NAME_0 = "GUI_LIST_INDEXSOURCE_COL_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_COL_RESOURCES_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_COL_RESOURCES_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_HIDE_0 = "GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_HIDE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_HIDE_HELP_0 = "GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_HIDE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_NAME_0 = "GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_SHOW_0 = "GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_SHOW_HELP_0 = "GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_SHOW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_HIDE_0 = "GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_HIDE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_HIDE_HELP_0 = "GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_HIDE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_NAME_0 = "GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_SHOW_0 = "GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_SHOW_HELP_0 = "GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_SHOW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_MACTION_DELETESOURCE_CONF_0 = "GUI_LIST_INDEXSOURCE_MACTION_DELETESOURCE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_MACTION_DELETESOURCE_NAME_0 = "GUI_LIST_INDEXSOURCE_MACTION_DELETESOURCE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCE_MACTION_DELETESOURCE_NAME_HELP_0 = "GUI_LIST_INDEXSOURCE_MACTION_DELETESOURCE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCES_AVAIL_NAME_0 = "GUI_LIST_INDEXSOURCES_AVAIL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_INDEXSOURCES_NAME_0 = "GUI_LIST_INDEXSOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_MAPPING_COL_DEFAULT_0 = "GUI_LIST_MAPPING_COL_DEFAULT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_MAPPING_COL_EDIT_NAME_0 = "GUI_LIST_MAPPING_COL_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_MAPPING_COL_EDIT_NAME_HELP_0 = "GUI_LIST_MAPPING_COL_EDIT_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_MAPPING_COL_TYPE_0 = "GUI_LIST_MAPPING_COL_TYPE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_MAPPING_COL_VALUE_0 = "GUI_LIST_MAPPING_COL_VALUE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_MAPPING_NAME_HELP_0 = "GUI_LIST_MAPPING_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_MAPPINGS_NAME_0 = "GUI_LIST_MAPPINGS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_RESOURCES_NAME_0 = "GUI_LIST_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_RESOURCES_NAME_HELP_0 = "GUI_LIST_RESOURCES_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_ADD_DOCTYPE_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_ADD_DOCTYPE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_ADDSOURCE_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_ADDSOURCE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_DELETE_CONF_0 = "GUI_LIST_SEARCHINDEX_ACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_DELETE_CONF_1 = "GUI_LIST_SEARCHINDEX_ACTION_DELETE_CONF_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_DELETE_HELP_0 = "GUI_LIST_SEARCHINDEX_ACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_DELETE_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_DOCUMENTS_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_DOCUMENTS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_DOCUMENTS_NAME_NAVACTIVE_0 = "GUI_LIST_SEARCHINDEX_ACTION_DOCUMENTS_NAME_NAVACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_EDIT_HELP_0 = "GUI_LIST_SEARCHINDEX_ACTION_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_EDIT_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_FIELDCONFIGURATIONS_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_FIELDCONFIGURATIONS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_FIELDS_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_FIELDS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_INDEXSOURCES_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_INDEXSOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_MAPPINGS_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_MAPPINGS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_REBUILD_CONF_0 = "GUI_LIST_SEARCHINDEX_ACTION_REBUILD_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_REBUILD_HELP_0 = "GUI_LIST_SEARCHINDEX_ACTION_REBUILD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_REBUILD_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_REBUILD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_REBUILD_NAME_CONF_1 = "GUI_LIST_SEARCHINDEX_ACTION_REBUILD_NAME_CONF_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_REMOVE_DOCTYPE_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_REMOVE_DOCTYPE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_REMOVESOURCE_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_REMOVESOURCE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_RESOURCES_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_RESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_SEARCH_HELP_0 = "GUI_LIST_SEARCHINDEX_ACTION_SEARCH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_ACTION_SEARCH_NAME_0 = "GUI_LIST_SEARCHINDEX_ACTION_SEARCH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_CONFIGURATION_0 = "GUI_LIST_SEARCHINDEX_COL_CONFIGURATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_DELETE_HELP_0 = "GUI_LIST_SEARCHINDEX_COL_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_DELETE_NAME_0 = "GUI_LIST_SEARCHINDEX_COL_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_EDIT_HELP_0 = "GUI_LIST_SEARCHINDEX_COL_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_EDIT_NAME_0 = "GUI_LIST_SEARCHINDEX_COL_EDIT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_FIELDCONFIGURATIONS_NAME_0 = "GUI_LIST_SEARCHINDEX_COL_FIELDCONFIGURATIONS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_FIELDCONFIGURATIONS_NAME_HELP_0 = "GUI_LIST_SEARCHINDEX_COL_FIELDCONFIGURATIONS_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_INDEXSOURCES_NAME_0 = "GUI_LIST_SEARCHINDEX_COL_INDEXSOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_INDEXSOURCES_NAME_HELP_0 = "GUI_LIST_SEARCHINDEX_COL_INDEXSOURCES_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_LOCALE_0 = "GUI_LIST_SEARCHINDEX_COL_LOCALE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_NAME_0 = "GUI_LIST_SEARCHINDEX_COL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_OVERVIEW_HELP_0 = "GUI_LIST_SEARCHINDEX_COL_OVERVIEW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_OVERVIEW_NAME_0 = "GUI_LIST_SEARCHINDEX_COL_OVERVIEW_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_PROJECT_0 = "GUI_LIST_SEARCHINDEX_COL_PROJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_REBUILD_HELP_0 = "GUI_LIST_SEARCHINDEX_COL_REBUILD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_REBUILD_NAME_0 = "GUI_LIST_SEARCHINDEX_COL_REBUILD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_REBUILDMODE_0 = "GUI_LIST_SEARCHINDEX_COL_REBUILDMODE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_SEARCH_HELP_0 = "GUI_LIST_SEARCHINDEX_COL_SEARCH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_COL_SEARCH_NAME_0 = "GUI_LIST_SEARCHINDEX_COL_SEARCH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_HIDE_0 = "GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_HIDE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_HIDE_HELP_0 = "GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_HIDE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_NAME_0 = "GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_SHOW_0 = "GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_SHOW_HELP_0 = "GUI_LIST_SEARCHINDEX_DETAIL_FIELDCONFIGURATION_SHOW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_HIDE_0 = "GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_HIDE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_HIDE_HELP_0 = "GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_HIDE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_NAME_0 = "GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_SHOW_0 = "GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_SHOW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_SHOW_HELP_0 = "GUI_LIST_SEARCHINDEX_DETAIL_INDEXSOURCE_SHOW_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_ADD_DOCTYPE_NAME_0 = "GUI_LIST_SEARCHINDEX_MACTION_ADD_DOCTYPE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_ADD_DOCTYPE_NAME_HELP_0 = "GUI_LIST_SEARCHINDEX_MACTION_ADD_DOCTYPE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_ADDSOURCE_NAME_0 = "GUI_LIST_SEARCHINDEX_MACTION_ADDSOURCE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_ADDSOURCE_NAME_HELP_0 = "GUI_LIST_SEARCHINDEX_MACTION_ADDSOURCE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_DELETE_CONF_0 = "GUI_LIST_SEARCHINDEX_MACTION_DELETE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_DELETE_HELP_0 = "GUI_LIST_SEARCHINDEX_MACTION_DELETE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_DELETE_NAME_0 = "GUI_LIST_SEARCHINDEX_MACTION_DELETE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_REBUILD_CONF_0 = "GUI_LIST_SEARCHINDEX_MACTION_REBUILD_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_REBUILD_HELP_0 = "GUI_LIST_SEARCHINDEX_MACTION_REBUILD_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_REBUILD_NAME_0 = "GUI_LIST_SEARCHINDEX_MACTION_REBUILD_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_REMOVE_DOCTYPE_NAME_0 = "GUI_LIST_SEARCHINDEX_MACTION_REMOVE_DOCTYPE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_REMOVE_DOCTYPE_NAME_HELP_0 = "GUI_LIST_SEARCHINDEX_MACTION_REMOVE_DOCTYPE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_REMOVESOURCE_NAME_0 = "GUI_LIST_SEARCHINDEX_MACTION_REMOVESOURCE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_MACTION_REMOVESOURCE_NAME_HELP_0 = "GUI_LIST_SEARCHINDEX_MACTION_REMOVESOURCE_NAME_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHINDEX_NAME_0 = "GUI_LIST_SEARCHINDEX_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SEARCHRESOURCES_NAME_0 = "GUI_LIST_SEARCHRESOURCES_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NAVTEXT_SEARCHINDEX_0 = "GUI_NAVTEXT_SEARCHINDEX_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_NAVTEXT_SEARCHINDEX_SHORT_0 = "GUI_NAVTEXT_SEARCHINDEX_SHORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SELECT_LABEL_SEARCH_SORT_DATE_CREATED_0 = "GUI_SELECT_LABEL_SEARCH_SORT_DATE_CREATED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SELECT_LABEL_SEARCH_SORT_DATE_LAST_MODIFIED_0 = "GUI_SELECT_LABEL_SEARCH_SORT_DATE_LAST_MODIFIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SELECT_LABEL_SEARCH_SORT_SCORE_0 = "GUI_SELECT_LABEL_SEARCH_SORT_SCORE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SELECT_LABEL_SEARCH_SORT_TITLE_0 = "GUI_SELECT_LABEL_SEARCH_SORT_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ERR_LIST_ITEM_SKIPPED_2 = "LOG_ERR_LIST_ITEM_SKIPPED_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_REBUILD_SEARCH_INDEXES_BEGIN_0 = "RPT_REBUILD_SEARCH_INDEXES_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_REBUILD_SEARCH_INDEXES_END_0 = "RPT_REBUILD_SEARCH_INDEXES_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_SEARCH_CONFIG_NOT_FOUND_0 = "RPT_SEARCH_CONFIG_NOT_FOUND_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.searchindex.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}