/*
 * File   : $Source: /usr/local/cvs/opencms/src-modules/org/opencms/workplace/tools/workplace/broadcast/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:54 $
 * Version: $Revision: 1.15 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.tools.workplace.broadcast;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Michael Moossen 
 * 
 * @version $Revision: 1.15 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EMPTY_STRING_0 = "ERR_EMPTY_STRING_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_SELECTED_GROUP_0 = "ERR_NO_SELECTED_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_SELECTED_RECEIVERS_0 = "ERR_NO_SELECTED_RECEIVERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_SELECTED_USER_WITH_EMAIL_0 = "ERR_NO_SELECTED_USER_WITH_EMAIL_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SEND_EMAIL_0 = "ERR_SEND_EMAIL_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SEND_MESSAGE_0 = "ERR_SEND_MESSAGE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXCLUDED_USERS_WARNING_0 = "GUI_EXCLUDED_USERS_WARNING_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MESSAGE_EDITOR_LABEL_CONTENT_BLOCK_0 = "GUI_MESSAGE_EDITOR_LABEL_CONTENT_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MESSAGE_EDITOR_LABEL_HEADER_BLOCK_0 = "GUI_MESSAGE_EDITOR_LABEL_HEADER_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SELECT_EDITOR_LABEL_BLOCK_0 = "GUI_SELECT_EDITOR_LABEL_BLOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_DETAIL_HIDE_EMAIL_HELP_0 = "GUI_SESSIONS_DETAIL_HIDE_EMAIL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_DETAIL_HIDE_EMAIL_NAME_0 = "GUI_SESSIONS_DETAIL_HIDE_EMAIL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_DETAIL_SHOW_EMAIL_HELP_0 = "GUI_SESSIONS_DETAIL_SHOW_EMAIL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_DETAIL_SHOW_EMAIL_NAME_0 = "GUI_SESSIONS_DETAIL_SHOW_EMAIL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LABEL_EMAIL_0 = "GUI_SESSIONS_LABEL_EMAIL_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_ACTION_MESSAGE_HELP_0 = "GUI_SESSIONS_LIST_ACTION_MESSAGE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_ACTION_MESSAGE_NAME_0 = "GUI_SESSIONS_LIST_ACTION_MESSAGE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_ACTION_NOTPENDING_HELP_0 = "GUI_SESSIONS_LIST_ACTION_NOTPENDING_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_ACTION_NOTPENDING_NAME_0 = "GUI_SESSIONS_LIST_ACTION_NOTPENDING_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_ACTION_PENDING_HELP_0 = "GUI_SESSIONS_LIST_ACTION_PENDING_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_ACTION_PENDING_NAME_0 = "GUI_SESSIONS_LIST_ACTION_PENDING_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_COLS_CREATION_0 = "GUI_SESSIONS_LIST_COLS_CREATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_COLS_INACTIVE_0 = "GUI_SESSIONS_LIST_COLS_INACTIVE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_COLS_MESSAGE_0 = "GUI_SESSIONS_LIST_COLS_MESSAGE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_COLS_MESSAGE_HELP_0 = "GUI_SESSIONS_LIST_COLS_MESSAGE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_COLS_ORGUNIT_0 = "GUI_SESSIONS_LIST_COLS_ORGUNIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_COLS_PENDING_0 = "GUI_SESSIONS_LIST_COLS_PENDING_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_COLS_PROJECT_0 = "GUI_SESSIONS_LIST_COLS_PROJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_COLS_SITE_0 = "GUI_SESSIONS_LIST_COLS_SITE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_COLS_USER_0 = "GUI_SESSIONS_LIST_COLS_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_MACTION_EMAIL_CONF_0 = "GUI_SESSIONS_LIST_MACTION_EMAIL_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_MACTION_EMAIL_HELP_0 = "GUI_SESSIONS_LIST_MACTION_EMAIL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_MACTION_EMAIL_NAME_0 = "GUI_SESSIONS_LIST_MACTION_EMAIL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_MACTION_MESSAGE_CONF_0 = "GUI_SESSIONS_LIST_MACTION_MESSAGE_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_MACTION_MESSAGE_HELP_0 = "GUI_SESSIONS_LIST_MACTION_MESSAGE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_MACTION_MESSAGE_NAME_0 = "GUI_SESSIONS_LIST_MACTION_MESSAGE_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_SESSIONS_LIST_NAME_0 = "GUI_SESSIONS_LIST_NAME_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.tools.workplace.broadcast.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}