/*
 * File   : $Source: /usr/local/cvs/opencms/src-setup/org/opencms/setup/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:28 $
 * Version: $Revision: 1.3 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.setup;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Jan Baudisch 
 * @author Michael Moossen
 * 
 * @version $Revision: 1.3 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_COMPONENT_MODULES_EMPTY_1 = "ERR_COMPONENT_MODULES_EMPTY_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_COMPONENT_NAME_EMPTY_1 = "ERR_COMPONENT_NAME_EMPTY_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DB_CONNECT_1 = "ERR_DB_CONNECT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOAD_JDBC_DRIVER_1 = "ERR_LOAD_JDBC_DRIVER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MISSING_DB_SETUP_SCRIPT_1 = "ERR_MISSING_DB_SETUP_SCRIPT_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_WARNING_ALL_MODULES_UPTODATE_0 = "GUI_WARNING_ALL_MODULES_UPTODATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORT_WORKPLACE_FINISHED_0 = "INIT_IMPORT_WORKPLACE_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORT_WORKPLACE_START_0 = "INIT_IMPORT_WORKPLACE_START_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_NO_WORKPLACE_IMPORT_NEEDED_0 = "INIT_NO_WORKPLACE_IMPORT_NEEDED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_UPDATE_WORKPLACE_FINISHED_0 = "INIT_UPDATE_WORKPLACE_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_UPDATE_WORKPLACE_START_0 = "INIT_UPDATE_WORKPLACE_START_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_WELCOME_SETUP_0 = "INIT_WELCOME_SETUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_WELCOME_UPDATE_0 = "INIT_WELCOME_UPDATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WARN_COMPONENT_DEPENDENCY_BROKEN_2 = "LOG_WARN_COMPONENT_DEPENDENCY_BROKEN_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WARN_COMPONENT_DESC_EMPTY_1 = "LOG_WARN_COMPONENT_DESC_EMPTY_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WARN_COMPONENT_POS_EMPTY_1 = "LOG_WARN_COMPONENT_POS_EMPTY_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WARN_MODULES_LEFT_1 = "LOG_WARN_MODULES_LEFT_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_BEGIN_DELETE_JARS_0 = "RPT_BEGIN_DELETE_JARS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_BEGIN_DELETE_MODULE_1 = "RPT_BEGIN_DELETE_MODULE_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_BEGIN_IMPORT_MODULE_1 = "RPT_BEGIN_IMPORT_MODULE_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_BEGIN_UPDATE_JARS_0 = "RPT_BEGIN_UPDATE_JARS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_BEGIN_UPDATE_MODULE_1 = "RPT_BEGIN_UPDATE_MODULE_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_JAR_FILE_3 = "RPT_DELETE_JAR_FILE_3";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_JAR_FILE_FAILED_3 = "RPT_DELETE_JAR_FILE_FAILED_3";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_JAR_PERMISSIONS_3 = "RPT_DELETE_JAR_PERMISSIONS_3";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_JAR_SKIPPED_FILE_3 = "RPT_DELETE_JAR_SKIPPED_FILE_3";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_JARS_FAILED_1 = "RPT_DELETE_JARS_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_END_DELETE_JARS_0 = "RPT_END_DELETE_JARS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_END_DELETE_MODULE_1 = "RPT_END_DELETE_MODULE_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_END_IMPORT_MODULE_1 = "RPT_END_IMPORT_MODULE_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_END_UPDATE_JARS_0 = "RPT_END_UPDATE_JARS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_END_UPDATE_MODULE_1 = "RPT_END_UPDATE_MODULE_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_FINISH_UPDATE_RELATIONS_0 = "RPT_FINISH_UPDATE_RELATIONS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_MODULE_UPTODATE_1 = "RPT_MODULE_UPTODATE_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_START_UPDATE_RELATIONS_0 = "RPT_START_UPDATE_RELATIONS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_UPDATE_JAR_FILE_3 = "RPT_UPDATE_JAR_FILE_3";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_UPDATE_JAR_FILE_FAILED_3 = "RPT_UPDATE_JAR_FILE_FAILED_3";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_UPDATE_JAR_PERMISSIONS_3 = "RPT_UPDATE_JAR_PERMISSIONS_3";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_UPDATE_JAR_SKIPPED_FILE_3 = "RPT_UPDATE_JAR_SKIPPED_FILE_3";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_UPDATE_JARS_FAILED_1 = "RPT_UPDATE_JARS_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_UPDATE_JARS_PERMISSIONS_1 = "RPT_UPDATE_JARS_PERMISSIONS_1";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.setup.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}