/*
 * File   : $Source: /usr/local/cvs/opencms/src/org/opencms/configuration/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:48 $
 * Version: $Revision: 1.19 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.configuration;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Alexander Kandzior 
 * 
 * @version $Revision: 1.19 $
 * 
 * @since 6.0.0
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CONFIG_WITH_UNKNOWN_CLASS_1 = "ERR_CONFIG_WITH_UNKNOWN_CLASS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOAD_CLASS_1 = "ERR_LOAD_CLASS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNKNOWN_RESTYPE_CLASS_2 = "ERR_UNKNOWN_RESTYPE_CLASS_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADMIN_GROUP_1 = "INIT_ADMIN_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADMIN_USER_1 = "INIT_ADMIN_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_AUTHORIZATION_HANDLER_CLASS_INVALID_1 = "INIT_AUTHORIZATION_HANDLER_CLASS_INVALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_AUTHORIZATION_HANDLER_CLASS_SUCCESS_1 = "INIT_AUTHORIZATION_HANDLER_CLASS_SUCCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_CHECKING_DEFAULT_USER_NAMES_0 = "INIT_CHECKING_DEFAULT_USER_NAMES_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_CONFIG_I18N_FINISHED_0 = "INIT_CONFIG_I18N_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_DEFAULT_USER_NAMES_INITIALIZED_0 = "INIT_DEFAULT_USER_NAMES_INITIALIZED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_DELETED_RESOURCE_USER_1 = "INIT_DELETED_RESOURCE_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_EVENTMANAGER_CLASS_INVALID_1 = "INIT_EVENTMANAGER_CLASS_INVALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_EVENTMANAGER_CLASS_SUCCESS_1 = "INIT_EVENTMANAGER_CLASS_SUCCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_EXPORT_USER_1 = "INIT_EXPORT_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_GUEST_USER_1 = "INIT_GUEST_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_GUESTS_GROUP_1 = "INIT_GUESTS_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_HISTORY_SETTINGS_3 = "INIT_HISTORY_SETTINGS_3";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORT_CONFIG_FINISHED_0 = "INIT_IMPORT_CONFIG_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORT_CONFIG_INIT_0 = "INIT_IMPORT_CONFIG_INIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORT_MANAGER_0 = "INIT_IMPORT_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_LOGINMANAGER_2 = "INIT_LOGINMANAGER_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_LOGINMESSAGE_3 = "INIT_LOGINMESSAGE_3";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_MODULE_CONFIG_FINISHED_0 = "INIT_MODULE_CONFIG_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_MODULE_CONFIG_INIT_0 = "INIT_MODULE_CONFIG_INIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_NOTIFICATION_PROJECT_1 = "INIT_NOTIFICATION_PROJECT_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_NOTIFICATION_TIME_1 = "INIT_NOTIFICATION_TIME_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_PROJECT_MANAGERS_GROUP_1 = "INIT_PROJECT_MANAGERS_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_PUBLISH_RELATED_RESOURCES_MODE_1 = "INIT_PUBLISH_RELATED_RESOURCES_MODE_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_PWD_HANDLER_SUCCESS_1 = "INIT_PWD_HANDLER_SUCCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_RELATION_DELETION_DISABLED_0 = "INIT_RELATION_DELETION_DISABLED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_RELATION_DELETION_ENABLED_0 = "INIT_RELATION_DELETION_ENABLED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_REQUEST_HANDLER_INVALID_1 = "INIT_REQUEST_HANDLER_INVALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_REQUEST_HANDLER_SUCCESS_1 = "INIT_REQUEST_HANDLER_SUCCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_RESOURCE_INIT_INVALID_CLASS_1 = "INIT_RESOURCE_INIT_INVALID_CLASS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_RESOURCE_INIT_SUCCESS_1 = "INIT_RESOURCE_INIT_SUCCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_RUNTIME_INFO_FACTORY_FAILURE_1 = "INIT_RUNTIME_INFO_FACTORY_FAILURE_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_RUNTIME_INFO_FACTORY_SUCCESS_1 = "INIT_RUNTIME_INFO_FACTORY_SUCCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SCHEDULER_CONFIG_JOB_3 = "INIT_SCHEDULER_CONFIG_JOB_3";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SEARCH_CONFIG_FINISHED_0 = "INIT_SEARCH_CONFIG_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SEARCH_CONFIG_INIT_0 = "INIT_SEARCH_CONFIG_INIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SEARCH_MANAGER_FINISHED_0 = "INIT_SEARCH_MANAGER_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SESSION_STORAGEPROVIDER_SUCCESS_1 = "INIT_SESSION_STORAGEPROVIDER_SUCCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SITE_CONFIG_FINISHED_0 = "INIT_SITE_CONFIG_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_STATEXP_MANAGER_0 = "INIT_STATEXP_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SYSTEM_CONFIG_FINISHED_0 = "INIT_SYSTEM_CONFIG_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SYSTEM_CONFIG_INIT_0 = "INIT_SYSTEM_CONFIG_INIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_TEMPFILE_PROJECT_ID_1 = "INIT_TEMPFILE_PROJECT_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_USERS_GROUP_1 = "INIT_USERS_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VALIDATION_HANDLER_CLASS_INVALID_1 = "INIT_VALIDATION_HANDLER_CLASS_INVALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VALIDATION_HANDLER_CLASS_SUCCESS_1 = "INIT_VALIDATION_HANDLER_CLASS_SUCCESS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_ADD_FILE_TRANSLATION_1 = "INIT_VFS_ADD_FILE_TRANSLATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_ADD_FOLDER_TRANSLATION_1 = "INIT_VFS_ADD_FOLDER_TRANSLATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_CONFIG_FINISHED_0 = "INIT_VFS_CONFIG_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_CONFIG_INIT_0 = "INIT_VFS_CONFIG_INIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_DEFAULT_FILE_2 = "INIT_VFS_DEFAULT_FILE_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_FILE_TRANSLATION_DISABLE_0 = "INIT_VFS_FILE_TRANSLATION_DISABLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_FILE_TRANSLATION_ENABLE_0 = "INIT_VFS_FILE_TRANSLATION_ENABLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_FOLDER_TRANSLATION_DISABLE_0 = "INIT_VFS_FOLDER_TRANSLATION_DISABLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_FOLDER_TRANSLATION_ENABLE_0 = "INIT_VFS_FOLDER_TRANSLATION_ENABLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_VFS_XML_CONTENT_FINISHED_0 = "INIT_VFS_XML_CONTENT_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_WORKPLACE_FINISHED_0 = "INIT_WORKPLACE_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_WORKPLACE_INIT_0 = "INIT_WORKPLACE_INIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_WORKPLACE_INIT_FINISHED_0 = "INIT_WORKPLACE_INIT_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ADD_CONFIG_1 = "LOG_ADD_CONFIG_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ADD_CONFIG_PARAM_3 = "LOG_ADD_CONFIG_PARAM_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_BASE_URL_1 = "LOG_BASE_URL_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CACHE_DTD_SYSTEM_ID_1 = "LOG_CACHE_DTD_SYSTEM_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CACHE_DTD_SYSTEM_ID_FAILURE_1 = "LOG_CACHE_DTD_SYSTEM_ID_FAILURE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CONFIG_BASE_FOLDER_1 = "LOG_CONFIG_BASE_FOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CONFIG_BKP_FOLDER_1 = "LOG_CONFIG_BKP_FOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_CONFIG_BKP_2 = "LOG_CREATE_CONFIG_BKP_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_CONFIG_BKP_FAILURE_1 = "LOG_CREATE_CONFIG_BKP_FAILURE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_CONFIG_BKP_FOLDER_1 = "LOG_CREATE_CONFIG_BKP_FOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_GET_CONFIGURATION_1 = "LOG_GET_CONFIGURATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INIT_CONFIGURATION_1 = "LOG_INIT_CONFIGURATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INIT_REQUEST_HANDLER_FAILURE_1 = "LOG_INIT_REQUEST_HANDLER_FAILURE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INIT_SESSION_STORAGEPROVIDER_FAILURE_1 = "LOG_INIT_SESSION_STORAGEPROVIDER_FAILURE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INVALID_CONFIG_BASE_FOLDER_1 = "LOG_INVALID_CONFIG_BASE_FOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LOAD_CONFIG_XMLFILE_1 = "LOG_LOAD_CONFIG_XMLFILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MAIL_SETTINGS_1 = "LOG_MAIL_SETTINGS_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REMOVE_CONFIG_FILE_1 = "LOG_REMOVE_CONFIG_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_RESOURCE_INIT_CLASS_INVALID_1 = "LOG_RESOURCE_INIT_CLASS_INVALID_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_RESOURCE_INIT_FAILURE_1 = "LOG_RESOURCE_INIT_FAILURE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WRITE_CONFIG_SUCCESS_2 = "LOG_WRITE_CONFIG_SUCCESS_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WRITE_CONFIG_XMLFILE_1 = "LOG_WRITE_CONFIG_XMLFILE_1";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.configuration.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}