/*
 * File   : $Source: /usr/local/cvs/opencms/src/org/opencms/db/generic/Messages.java,v $
 * Date   : $Date: 2008-03-27 13:22:44 $
 * Version: $Revision: 1.30 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.db.generic;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Thomas Weckert 
 * @author Jan Baudisch 
 * 
 * @version $Revision: 1.30 $
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_COUNTING_PROPERTIES_1 = "ERR_COUNTING_PROPERTIES_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CREATE_SIBLING_FILE_NOT_FOUND_1 = "ERR_CREATE_SIBLING_FILE_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_HISTORY_VERSIONS_1 = "ERR_DELETE_HISTORY_VERSIONS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_NONEMTY_FOLDER_2 = "ERR_DELETE_NONEMTY_FOLDER_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_USED_PROPERTY_1 = "ERR_DELETE_USED_PROPERTY_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ERROR_DELETING_PROPERTYDEF_1 = "ERR_ERROR_DELETING_PROPERTYDEF_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ERROR_PUBLISHING_DELETED_FOLDER_1 = "ERR_ERROR_PUBLISHING_DELETED_FOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ERROR_PUBLISHING_FILE_1 = "ERR_ERROR_PUBLISHING_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ERROR_PUBLISHING_FOLDER_1 = "ERR_ERROR_PUBLISHING_FOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_GENERIC_SQL_0 = "ERR_GENERIC_SQL_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_GENERIC_SQL_1 = "ERR_GENERIC_SQL_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_GROUP_WITH_NAME_ALREADY_EXISTS_1 = "ERR_GROUP_WITH_NAME_ALREADY_EXISTS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_HISTORY_FILE_NOT_FOUND_1 = "ERR_HISTORY_FILE_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_HISTORY_PRINCIPAL_NOT_FOUND_1 = "ERR_HISTORY_PRINCIPAL_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INITIALIZING_USER_DRIVER_0 = "ERR_INITIALIZING_USER_DRIVER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INITIALIZING_VFS_DRIVER_0 = "ERR_INITIALIZING_VFS_DRIVER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_DELETE_OPTION_1 = "ERR_INVALID_DELETE_OPTION_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_RESOURCE_LENGTH_2 = "ERR_INVALID_RESOURCE_LENGTH_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_JDBC_CONN_INVALID_PROJECT_ID_1 = "ERR_JDBC_CONN_INVALID_PROJECT_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_ACE_FOUND_2 = "ERR_NO_ACE_FOUND_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_GROUP_WITH_ID_1 = "ERR_NO_GROUP_WITH_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_HISTORY_PROJECT_WITH_ID_1 = "ERR_NO_HISTORY_PROJECT_WITH_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_HISTORY_PROJECT_WITH_TAG_ID_1 = "ERR_NO_HISTORY_PROJECT_WITH_TAG_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_PROJECT_WITH_ID_1 = "ERR_NO_PROJECT_WITH_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_PROJECT_WITH_NAME_1 = "ERR_NO_PROJECT_WITH_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_PROJECTRESOURCE_1 = "ERR_NO_PROJECTRESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_PROPERTIES_FOR_PROPERTYDEF_1 = "ERR_NO_PROPERTIES_FOR_PROPERTYDEF_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_PROPERTYDEF_WITH_NAME_1 = "ERR_NO_PROPERTYDEF_WITH_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_USER_WITH_ID_1 = "ERR_NO_USER_WITH_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ORGUNIT_ALREADY_CONTAINS_PRINCIPAL_2 = "ERR_ORGUNIT_ALREADY_CONTAINS_PRINCIPAL_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ORGUNIT_DOESNOT_CONTAINS_PRINCIPAL_2 = "ERR_ORGUNIT_DOESNOT_CONTAINS_PRINCIPAL_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ORGUNIT_DOESNOT_CONTAINS_RESOURCE_2 = "ERR_ORGUNIT_DOESNOT_CONTAINS_RESOURCE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ORGUNIT_REMOVE_LAST_RESOURCE_2 = "ERR_ORGUNIT_REMOVE_LAST_RESOURCE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ORGUNIT_RESOURCE_IS_NOT_FOLDER_2 = "ERR_ORGUNIT_RESOURCE_IS_NOT_FOLDER_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ORGUNIT_WITH_NAME_ALREADY_EXISTS_1 = "ERR_ORGUNIT_WITH_NAME_ALREADY_EXISTS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_OUT_OF_MEMORY_0 = "ERR_OUT_OF_MEMORY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_OVERWRITE_MOVED_RESOURCE_3 = "ERR_OVERWRITE_MOVED_RESOURCE_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PARENT_FOLDER_DELETED_1 = "ERR_PARENT_FOLDER_DELETED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PATH_NOT_IN_PARENT_ORGUNIT_SCOPE_2 = "ERR_PATH_NOT_IN_PARENT_ORGUNIT_SCOPE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PUBLISHLIST_DESERIALIZATION_FAILED_1 = "ERR_PUBLISHLIST_DESERIALIZATION_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_QUERY_NOT_FOUND_1 = "ERR_QUERY_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_CONTENT_WITH_RESOURCE_ID_2 = "ERR_READ_CONTENT_WITH_RESOURCE_ID_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_DELETED_FILE_1 = "ERR_READ_DELETED_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_DELETED_RESOURCE_1 = "ERR_READ_DELETED_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_FOLDER_1 = "ERR_READ_FOLDER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_FOLDER_WITH_ID_1 = "ERR_READ_FOLDER_WITH_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_ORGUNIT_1 = "ERR_READ_ORGUNIT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_PARENT_ID_1 = "ERR_READ_PARENT_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_PUBLISH_JOB_1 = "ERR_READ_PUBLISH_JOB_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_RESOURCE_1 = "ERR_READ_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_RESOURCE_VERSIONS_1 = "ERR_READ_RESOURCE_VERSIONS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READ_RESOURCE_WITH_ID_1 = "ERR_READ_RESOURCE_WITH_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READING_ADDITIONAL_INFO_1 = "ERR_READING_ADDITIONAL_INFO_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READING_USER_0 = "ERR_READING_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_READING_USERS_0 = "ERR_READING_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1 = "ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_RESOURCE_WITH_NAME_CURRENTLY_CREATED_1 = "ERR_RESOURCE_WITH_NAME_CURRENTLY_CREATED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_RESOURCENAME_TOO_LONG_2 = "ERR_RESOURCENAME_TOO_LONG_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SERIALIZING_PUBLISHLIST_1 = "ERR_SERIALIZING_PUBLISHLIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SERIALIZING_USER_DATA_1 = "ERR_SERIALIZING_USER_DATA_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SIBLING_WITH_NAME_ALREADY_EXISTS_1 = "ERR_SIBLING_WITH_NAME_ALREADY_EXISTS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_TOO_MANY_PROPERTIES_3 = "ERR_TOO_MANY_PROPERTIES_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3 = "ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_USER_WITH_NAME_ALREADY_EXISTS_1 = "ERR_USER_WITH_NAME_ALREADY_EXISTS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_WRITING_HISTORY_OF_PROJECT_1 = "ERR_WRITING_HISTORY_OF_PROJECT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_WRITING_TO_OUTPUT_STREAM_1 = "ERR_WRITING_TO_OUTPUT_STREAM_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEFAULTGROUP_OU_USERS_DESCRIPTION_1 = "GUI_DEFAULTGROUP_OU_USERS_DESCRIPTION_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEFAULTGROUP_ROOT_ADMINS_DESCRIPTION_0 = "GUI_DEFAULTGROUP_ROOT_ADMINS_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEFAULTGROUP_ROOT_GUESTS_DESCRIPTION_0 = "GUI_DEFAULTGROUP_ROOT_GUESTS_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEFAULTGROUP_ROOT_PROJMANS_DESCRIPTION_0 = "GUI_DEFAULTGROUP_ROOT_PROJMANS_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEFAULTGROUP_ROOT_USERS_DESCRIPTION_0 = "GUI_DEFAULTGROUP_ROOT_USERS_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEFAULTUSER_ROOT_ADMIN_DESCRIPTION_0 = "GUI_DEFAULTUSER_ROOT_ADMIN_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEFAULTUSER_ROOT_DELETED_DESCRIPTION_0 = "GUI_DEFAULTUSER_ROOT_DELETED_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEFAULTUSER_ROOT_EXPORT_DESCRIPTION_0 = "GUI_DEFAULTUSER_ROOT_EXPORT_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DEFAULTUSER_ROOT_GUEST_DESCRIPTION_0 = "GUI_DEFAULTUSER_ROOT_GUEST_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_ROOT_DESCRIPTION_0 = "GUI_ORGUNIT_ROOT_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ASSIGNED_POOL_1 = "INIT_ASSIGNED_POOL_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_DEFAULT_USERS_CREATED_0 = "INIT_DEFAULT_USERS_CREATED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_DEFAULT_USERS_CREATION_FAILED_0 = "INIT_DEFAULT_USERS_CREATION_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_DIGEST_ALGORITHM_1 = "INIT_DIGEST_ALGORITHM_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_DIGEST_ENC_3 = "INIT_DIGEST_ENC_3";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_DIGEST_ENCODING_1 = "INIT_DIGEST_ENCODING_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_DRIVER_SQL_MANAGER_1 = "INIT_DRIVER_SQL_MANAGER_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_FILL_DEFAULTS_0 = "INIT_FILL_DEFAULTS_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ROOT_ORGUNIT_DEFAULTS_INITIALIZED_0 = "INIT_ROOT_ORGUNIT_DEFAULTS_INITIALIZED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ROOT_ORGUNIT_INITIALIZATION_FAILED_0 = "INIT_ROOT_ORGUNIT_INITIALIZATION_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SET_DIGEST_ERROR_0 = "INIT_SET_DIGEST_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SHUTDOWN_DRIVER_1 = "INIT_SHUTDOWN_DRIVER_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SYSTEM_FOLDER_INITIALIZATION_FAILED_0 = "INIT_SYSTEM_FOLDER_INITIALIZATION_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SYSTEM_FOLDER_INITIALIZED_0 = "INIT_SYSTEM_FOLDER_INITIALIZED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SYSTEM_ROLES_CREATED_0 = "INIT_SYSTEM_ROLES_CREATED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SYSTEM_ROLES_CREATION_FAILED_0 = "INIT_SYSTEM_ROLES_CREATION_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_RELATION_2 = "LOG_CREATE_RELATION_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DBG_CLEAR_LOCKS_1 = "LOG_DBG_CLEAR_LOCKS_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DBG_READ_LOCKS_1 = "LOG_DBG_READ_LOCKS_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DBG_WRITE_LOCKS_1 = "LOG_DBG_WRITE_LOCKS_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEL_FILE_3 = "LOG_DEL_FILE_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEL_FOLDER_3 = "LOG_DEL_FOLDER_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DELETING_PROPERTIES_1 = "LOG_DELETING_PROPERTIES_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ERROR_RESETTING_RESOURCE_STATE_1 = "LOG_ERROR_RESETTING_RESOURCE_STATE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_LOAD_QUERY_PROP_FILE_FAILED_1 = "LOG_LOAD_QUERY_PROP_FILE_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_NULL_DB_CONTEXT_0 = "LOG_NULL_DB_CONTEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISHING_ACL_1 = "LOG_PUBLISHING_ACL_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISHING_FILE_3 = "LOG_PUBLISHING_FILE_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISHING_FILE_CONTENT_1 = "LOG_PUBLISHING_FILE_CONTENT_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISHING_FOLDER_3 = "LOG_PUBLISHING_FOLDER_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISHING_PROPERTIES_1 = "LOG_PUBLISHING_PROPERTIES_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISHING_RESOURCE_1 = "LOG_PUBLISHING_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_QUERY_NOT_FOUND_1 = "LOG_QUERY_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_READING_RESOURCE_1 = "LOG_READING_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REMOVING_ACL_1 = "LOG_REMOVING_ACL_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REMOVING_RELATIONS_1 = "LOG_REMOVING_RELATIONS_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REMOVING_RESOURCE_1 = "LOG_REMOVING_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SQL_MANAGER_INIT_FAILED_1 = "LOG_SQL_MANAGER_INIT_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_START_PUBLISHING_PROJECT_2 = "LOG_START_PUBLISHING_PROJECT_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1 = "LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WARN_FOLDER_WRONG_STATE_CN_1 = "LOG_WARN_FOLDER_WRONG_STATE_CN_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WARN_FOLDER_WRONG_STATE_NC_1 = "LOG_WARN_FOLDER_WRONG_STATE_NC_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_WRITING_PUBLISHING_HISTORY_1 = "LOG_WRITING_PUBLISHING_HISTORY_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_FILE_0 = "RPT_DELETE_FILE_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_FOLDER_0 = "RPT_DELETE_FOLDER_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_FOLDERS_BEGIN_0 = "RPT_DELETE_FOLDERS_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_FOLDERS_END_0 = "RPT_DELETE_FOLDERS_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_FILE_0 = "RPT_PUBLISH_FILE_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_FILES_BEGIN_0 = "RPT_PUBLISH_FILES_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_FILES_END_0 = "RPT_PUBLISH_FILES_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_FOLDER_0 = "RPT_PUBLISH_FOLDER_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_FOLDERS_BEGIN_0 = "RPT_PUBLISH_FOLDERS_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_FOLDERS_END_0 = "RPT_PUBLISH_FOLDERS_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_STAT_4 = "RPT_PUBLISH_STAT_4";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.db.generic.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }

}
