/*
 * File   : $Source: /usr/local/cvs/opencms/src/org/opencms/importexport/Messages.java,v $
 * Date   : $Date: 2008-04-11 10:25:00 $
 * Version: $Revision: 1.18 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.importexport;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Thomas Weckert  
 * @author Jan Baudisch 
 * 
 * @version $Revision: 1.18 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_CONTENT_AGE_1 = "ERR_BAD_CONTENT_AGE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_FILE_NAME_1 = "ERR_BAD_FILE_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BODY_CONTENT_NOT_FOUND_0 = "ERR_BODY_CONTENT_NOT_FOUND_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_ADDING_CHILD_RESOURCES_1 = "ERR_IMPORTEXPORT_ERROR_ADDING_CHILD_RESOURCES_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_ADDING_FILE_1 = "ERR_IMPORTEXPORT_ERROR_ADDING_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_ADDING_PARENT_FOLDERS_1 = "ERR_IMPORTEXPORT_ERROR_ADDING_PARENT_FOLDERS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_ADDING_RELATION_TO_RESOURCE_1 = "ERR_IMPORTEXPORT_ERROR_ADDING_RELATION_TO_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_APPENDING_RESOURCE_TO_MANIFEST_1 = "ERR_IMPORTEXPORT_ERROR_APPENDING_RESOURCE_TO_MANIFEST_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_CANNOT_MERGE_PAGE_FILE_3 = "ERR_IMPORTEXPORT_ERROR_CANNOT_MERGE_PAGE_FILE_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_CLOSING_ZIP_ARCHIVE_1 = "ERR_IMPORTEXPORT_ERROR_CLOSING_ZIP_ARCHIVE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_COPYING_PROPERTY_DEFINITIONS_0 = "ERR_IMPORTEXPORT_ERROR_COPYING_PROPERTY_DEFINITIONS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_CREATING_DIGEST_1 = "ERR_IMPORTEXPORT_ERROR_CREATING_DIGEST_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_CREATING_ZIP_ENTRY_FOR_VFS_RESOURCE_1 = "ERR_IMPORTEXPORT_ERROR_CREATING_ZIP_ENTRY_FOR_VFS_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_EXPORTING_TO_FILE_1 = "ERR_IMPORTEXPORT_ERROR_EXPORTING_TO_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_EXPORTING_USER_1 = "ERR_IMPORTEXPORT_ERROR_EXPORTING_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_IMPORT_FILE_DOES_NOT_EXIST_1 = "ERR_IMPORTEXPORT_ERROR_IMPORT_FILE_DOES_NOT_EXIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUP_1 = "ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUP_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUPS_0 = "ERR_IMPORTEXPORT_ERROR_IMPORTING_GROUPS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_IMPORTING_ORGUNITS_0 = "ERR_IMPORTEXPORT_ERROR_IMPORTING_ORGUNITS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_IMPORTING_PROJECTS_0 = "ERR_IMPORTEXPORT_ERROR_IMPORTING_PROJECTS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCE_1 = "ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0 = "ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_IMPORTING_USER_1 = "ERR_IMPORTEXPORT_ERROR_IMPORTING_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_IMPORTING_USERS_0 = "ERR_IMPORTEXPORT_ERROR_IMPORTING_USERS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_MERGING_PAGE_FILE_1 = "ERR_IMPORTEXPORT_ERROR_MERGING_PAGE_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_NO_HANDLER_FOUND_1 = "ERR_IMPORTEXPORT_ERROR_NO_HANDLER_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_OPENING_ZIP_ARCHIVE_1 = "ERR_IMPORTEXPORT_ERROR_OPENING_ZIP_ARCHIVE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_READING_FILE_1 = "ERR_IMPORTEXPORT_ERROR_READING_FILE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_ERROR_REMOVING_FOLDERS_OF_IMPORTED_BODY_FILES_0 = "ERR_IMPORTEXPORT_ERROR_REMOVING_FOLDERS_OF_IMPORTED_BODY_FILES_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_FILE_NOT_FOUND_1 = "ERR_IMPORTEXPORT_FILE_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORTEXPORT_LINK_CONVERSION_FAILED_2 = "ERR_IMPORTEXPORT_LINK_CONVERSION_FAILED_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NOT_FOUND_ELEM_XMLTEMPLATE_0 = "ERR_NOT_FOUND_ELEM_XMLTEMPLATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_CMSIMPORTHANDLER_DEFAULT_DESC_0 = "GUI_CMSIMPORTHANDLER_DEFAULT_DESC_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORTEXPORT_ADDED_GROUP_TRANSLATION_2 = "INIT_IMPORTEXPORT_ADDED_GROUP_TRANSLATION_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORTEXPORT_ADDED_USER_TRANSLATION_2 = "INIT_IMPORTEXPORT_ADDED_USER_TRANSLATION_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORTEXPORT_INITIALIZING_0 = "INIT_IMPORTEXPORT_INITIALIZING_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORTEXPORT_OLD_CONTEXT_PATH_2 = "INIT_IMPORTEXPORT_OLD_CONTEXT_PATH_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORTEXPORT_OLD_CONTEXT_SUPPORT_DISABLED_0 = "INIT_IMPORTEXPORT_OLD_CONTEXT_SUPPORT_DISABLED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_IMPORTEXPORT_OLD_CONTEXT_SUPPORT_ENABLED_0 = "INIT_IMPORTEXPORT_OLD_CONTEXT_SUPPORT_ENABLED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CONVERT_LINK_DOTS_OK_3 = "LOG_CONVERT_LINK_DOTS_OK_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CONVERT_LINK_OK_3 = "LOG_CONVERT_LINK_OK_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_EXPORTING_OK_2 = "LOG_EXPORTING_OK_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ADDED_IMMUTABLE_RESOURCE_1 = "LOG_IMPORTEXPORT_ADDED_IMMUTABLE_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ADDED_IMPORT_VERSION_1 = "LOG_IMPORTEXPORT_ADDED_IMPORT_VERSION_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ADDED_IMPORTEXPORT_HANDLER_1 = "LOG_IMPORTEXPORT_ADDED_IMPORTEXPORT_HANDLER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ADDED_PRINCIPAL_TRANSLATION_3 = "LOG_IMPORTEXPORT_ADDED_PRINCIPAL_TRANSLATION_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_CANNOT_CONVERT_XML_STRUCTURE_1 = "LOG_IMPORTEXPORT_CANNOT_CONVERT_XML_STRUCTURE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_END_CONVERTING_TO_XML_0 = "LOG_IMPORTEXPORT_END_CONVERTING_TO_XML_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_END_IMPORTING_XML_PAGE_0 = "LOG_IMPORTEXPORT_END_IMPORTING_XML_PAGE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_END_MERGING_1 = "LOG_IMPORTEXPORT_END_MERGING_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ERROR_GETTING_WEBAPP_COMPATIBILITY_NAMES_0 = "LOG_IMPORTEXPORT_ERROR_GETTING_WEBAPP_COMPATIBILITY_NAMES_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ERROR_IMPORTING_ACE_1 = "LOG_IMPORTEXPORT_ERROR_IMPORTING_ACE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ERROR_IMPORTING_RELATION_1 = "LOG_IMPORTEXPORT_ERROR_IMPORTING_RELATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ERROR_ON_TEST_IMMUTABLE_1 = "LOG_IMPORTEXPORT_ERROR_ON_TEST_IMMUTABLE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ERROR_READING_MANIFEST_1 = "LOG_IMPORTEXPORT_ERROR_READING_MANIFEST_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_FILE_NOT_FOUND_IN_ZIP_1 = "LOG_IMPORTEXPORT_FILE_NOT_FOUND_IN_ZIP_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_IGNORING_PROPERTY_1 = "LOG_IMPORTEXPORT_IGNORING_PROPERTY_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_IMMUTABLE_FLAG_SET_1 = "LOG_IMPORTEXPORT_IMMUTABLE_FLAG_SET_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_IMMUTABLE_RESOURCES_SIZE_1 = "LOG_IMPORTEXPORT_IMMUTABLE_RESOURCES_SIZE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_ORIGINAL_RESOURCE_NAME_1 = "LOG_IMPORTEXPORT_ORIGINAL_RESOURCE_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_RESOURCENAME_IMMUTABLE_1 = "LOG_IMPORTEXPORT_RESOURCENAME_IMMUTABLE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_REWRITING_1 = "LOG_IMPORTEXPORT_REWRITING_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_SET_CONVERT_PARAMETER_1 = "LOG_IMPORTEXPORT_SET_CONVERT_PARAMETER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_SET_OLD_WEBAPP_URL_1 = "LOG_IMPORTEXPORT_SET_OLD_WEBAPP_URL_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_SET_OVERWRITE_PARAMETER_1 = "LOG_IMPORTEXPORT_SET_OVERWRITE_PARAMETER_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_START_CONVERTING_TO_XML_0 = "LOG_IMPORTEXPORT_START_CONVERTING_TO_XML_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_START_IMPORTING_XML_PAGE_0 = "LOG_IMPORTEXPORT_START_IMPORTING_XML_PAGE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_START_MERGING_1 = "LOG_IMPORTEXPORT_START_MERGING_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_TRANSLATED_RESOURCE_NAME_1 = "LOG_IMPORTEXPORT_TRANSLATED_RESOURCE_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTEXPORT_UNABLE_TO_UNLOCK_RESOURCE_1 = "LOG_IMPORTEXPORT_UNABLE_TO_UNLOCK_RESOURCE_1";

    /** Message constant for key in the resource bundle.<p> */
    public static final String LOG_IMPORTEXPORT_WARN_DELETE_RELATIONS_1 = "LOG_IMPORTEXPORT_WARN_DELETE_RELATIONS_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_IMPORTING_4 = "LOG_IMPORTING_4";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MERGING_3 = "LOG_MERGING_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SKIPPING_3 = "LOG_SKIPPING_3";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CLEARCACHE_0 = "RPT_CLEARCACHE_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONVERT_LINK_0 = "RPT_CONVERT_LINK_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_CONVERT_LINK_NOTFOUND_1 = "RPT_CONVERT_LINK_NOTFOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELFOLDER_0 = "RPT_DELFOLDER_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELFOLDER_START_0 = "RPT_DELFOLDER_START_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_END_IMPORT_RELATIONS_0 = "RPT_END_IMPORT_RELATIONS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_END_PARSE_LINKS_0 = "RPT_END_PARSE_LINKS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXPORT_0 = "RPT_EXPORT_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXPORT_DB_BEGIN_0 = "RPT_EXPORT_DB_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXPORT_DB_END_0 = "RPT_EXPORT_DB_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXPORT_GROUP_0 = "RPT_EXPORT_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXPORT_ORGUNIT_0 = "RPT_EXPORT_ORGUNIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXPORT_PROJECT_0 = "RPT_EXPORT_PROJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXPORT_USER_0 = "RPT_EXPORT_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_ACL_DATA_FAILED_0 = "RPT_IMPORT_ACL_DATA_FAILED_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_DB_BEGIN_0 = "RPT_IMPORT_DB_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_DB_END_0 = "RPT_IMPORT_DB_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_DB_NO_CLASS_1 = "RPT_IMPORT_DB_NO_CLASS_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_GROUP_0 = "RPT_IMPORT_GROUP_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_ORGUNIT_0 = "RPT_IMPORT_ORGUNIT_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_PROJECT_0 = "RPT_IMPORT_PROJECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_USER_0 = "RPT_IMPORT_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_VERSION_1 = "RPT_IMPORT_VERSION_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORTING_0 = "RPT_IMPORTING_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORTING_RELATIONS_FOR_2 = "RPT_IMPORTING_RELATIONS_FOR_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_MERGE_0 = "RPT_MERGE_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_MERGE_START_0 = "RPT_MERGE_START_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_NOT_CONVERTED_0 = "RPT_NOT_CONVERTED_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_NOT_CREATED_0 = "RPT_NOT_CREATED_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PARSE_LINKS_FOR_1 = "RPT_PARSE_LINKS_FOR_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_SKIPPING_0 = "RPT_SKIPPING_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_START_IMPORT_RELATIONS_0 = "RPT_START_IMPORT_RELATIONS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_START_PARSE_LINKS_0 = "RPT_START_PARSE_LINKS_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_STORING_LINK_0 = "RPT_STORING_LINK_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_USER_COULDNT_BE_ADDED_TO_GROUP_2 = "RPT_USER_COULDNT_BE_ADDED_TO_GROUP_2";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_USER_COULDNT_BE_ADDED_TO_ROLE_2 = "RPT_USER_COULDNT_BE_ADDED_TO_ROLE_2";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.importexport.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }

}
