/*
 * File   : $Source: /usr/local/cvs/opencms/src/org/opencms/module/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:44 $
 * Version: $Revision: 1.21 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.module;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Jan Baudisch 
 * 
 * @version $Revision: 1.21 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CHECK_DEPENDENCY_INVALID_MODE_1 = "ERR_CHECK_DEPENDENCY_INVALID_MODE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DELETE_MODULE_CHECK_LOCKS_2 = "ERR_DELETE_MODULE_CHECK_LOCKS_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IMPORT_MOD_ALREADY_INSTALLED_1 = "ERR_IMPORT_MOD_ALREADY_INSTALLED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_VERSION_LENGTH_1 = "ERR_INVALID_VERSION_LENGTH_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_VERSION_SUBNUMBER_1 = "ERR_INVALID_VERSION_SUBNUMBER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_IO_MODULE_IMPORT_1 = "ERR_IO_MODULE_IMPORT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MOD_ALREADY_INSTALLED_1 = "ERR_MOD_ALREADY_INSTALLED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MOD_DEPENDENCIES_2 = "ERR_MOD_DEPENDENCIES_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MOD_DEPENDENCY_INFO_2 = "ERR_MOD_DEPENDENCY_INFO_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MODULE_ACTION_CLASS_2 = "ERR_MODULE_ACTION_CLASS_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MODULE_ALREADY_CONFIGURED_1 = "ERR_MODULE_ALREADY_CONFIGURED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MODULE_DEPENDENCY_CYCLE_1 = "ERR_MODULE_DEPENDENCY_CYCLE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MODULE_FROZEN_1 = "ERR_MODULE_FROZEN_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MODULE_IMPORTING_MODULE_1 = "ERR_MODULE_IMPORTING_MODULE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MODULE_NAME_1 = "ERR_MODULE_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MODULE_NOT_CONFIGURED_1 = "ERR_MODULE_NOT_CONFIGURED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MODULE_SELECTION_INCONSISTENT_2 = "ERR_MODULE_SELECTION_INCONSISTENT_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MODULE_VERSION_NUMBER_0 = "ERR_MODULE_VERSION_NUMBER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_MANIFEST_MODULE_IMPORT_1 = "ERR_NO_MANIFEST_MODULE_IMPORT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_MOD_FOR_EXPORT_1 = "ERR_NO_MOD_FOR_EXPORT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NOT_NUMBER_0 = "ERR_NOT_NUMBER_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_OLD_MOD_ERR_1 = "ERR_OLD_MOD_ERR_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SAX_MODULE_IMPORT_1 = "ERR_SAX_MODULE_IMPORT_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETE_MODULE_PROJECT_DESC_1 = "GUI_DELETE_MODULE_PROJECT_DESC_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_DELETE_MODULE_PROJECT_NAME_1 = "GUI_DELETE_MODULE_PROJECT_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORT_MODULE_PROJECT_DESC_1 = "GUI_IMPORT_MODULE_PROJECT_DESC_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_IMPORT_MODULE_PROJECT_NAME_1 = "GUI_IMPORT_MODULE_PROJECT_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_ADD_EXPORT_POINT_2 = "INIT_ADD_EXPORT_POINT_2";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_CREATE_INSTANCE_FAILED_1 = "INIT_CREATE_INSTANCE_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_INITIALIZE_MOD_CLASS_1 = "INIT_INITIALIZE_MOD_CLASS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_MOD_CONFIGURED_1 = "INIT_MOD_CONFIGURED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_MOD_MANAGER_CREATED_0 = "INIT_MOD_MANAGER_CREATED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_NUM_CLASSES_INITIALIZED_1 = "INIT_NUM_CLASSES_INITIALIZED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_NUM_MODS_CONFIGURED_1 = "INIT_NUM_MODS_CONFIGURED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SHUTDOWN_1 = "INIT_SHUTDOWN_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SHUTDOWN_MOD_CLASS_1 = "INIT_SHUTDOWN_MOD_CLASS_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SHUTDOWN_NUM_MOD_CLASSES_1 = "INIT_SHUTDOWN_NUM_MOD_CLASSES_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ADD_EXPORT_POINT_2 = "LOG_ADD_EXPORT_POINT_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ADD_MOD_DEPENDENCY_2 = "LOG_ADD_MOD_DEPENDENCY_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ADD_MOD_PARAM_KEY_2 = "LOG_ADD_MOD_PARAM_KEY_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ADD_MOD_RESOURCE_1 = "LOG_ADD_MOD_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CORRECTED_MOD_NAME_1 = "LOG_CORRECTED_MOD_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_NEW_MOD_1 = "LOG_CREATE_NEW_MOD_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEL_MOD_1 = "LOG_DEL_MOD_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEL_MOD_EXC_1 = "LOG_DEL_MOD_EXC_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DEL_MOD_RESOURCE_1 = "LOG_DEL_MOD_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_DUPLICATE_EXPORT_POINT_2 = "LOG_DUPLICATE_EXPORT_POINT_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_EVENT_CAUGHT_2 = "LOG_EVENT_CAUGHT_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INSTANCE_INIT_ERR_1 = "LOG_INSTANCE_INIT_ERR_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INSTANCE_SHUTDOWN_ERR_1 = "LOG_INSTANCE_SHUTDOWN_ERR_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INSTANCE_UPDATE_ERR_1 = "LOG_INSTANCE_UPDATE_ERR_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INVALID_MOD_NAME_IMPORTED_1 = "LOG_INVALID_MOD_NAME_IMPORTED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MOD_UNINSTALL_ERR_1 = "LOG_MOD_UNINSTALL_ERR_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MOD_UPDATE_1 = "LOG_MOD_UPDATE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MOD_UPDATE_ERR_1 = "LOG_MOD_UPDATE_ERR_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MODULE_INITIALIZED_2 = "LOG_MODULE_INITIALIZED_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MODULE_INSTANCE_CREATED_1 = "LOG_MODULE_INSTANCE_CREATED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MODULE_SHUTDOWN_2 = "LOG_MODULE_SHUTDOWN_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MODULE_UNINSTALLED_2 = "LOG_MODULE_UNINSTALLED_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MODULE_UPDATED_2 = "LOG_MODULE_UPDATED_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MOVE_RESOURCE_FAILED_1 = "LOG_MOVE_RESOURCE_FAILED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_OLD_MODULE_IMPORTED_0 = "LOG_OLD_MODULE_IMPORTED_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_PUBLISH_PROJECT_1 = "LOG_PUBLISH_PROJECT_1";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_0 = "RPT_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_MODULE_BEGIN_0 = "RPT_DELETE_MODULE_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_DELETE_MODULE_END_0 = "RPT_DELETE_MODULE_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXPORT_MODULE_BEGIN_0 = "RPT_EXPORT_MODULE_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_EXPORT_MODULE_END_0 = "RPT_EXPORT_MODULE_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_MODULE_BEGIN_0 = "RPT_IMPORT_MODULE_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_IMPORT_MODULE_END_0 = "RPT_IMPORT_MODULE_END_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_PROJECT_BEGIN_0 = "RPT_PUBLISH_PROJECT_BEGIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String RPT_PUBLISH_PROJECT_END_0 = "RPT_PUBLISH_PROJECT_END_0";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.module.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}
